/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing.sequence;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnySequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.NumberSequence;

public class AnyNumberSequence
extends AnySequence
implements NumberSequence {
    private static final Number ZERO = new BigDecimal("0");

    public AnyNumberSequence(FormulaContext formulaContext) {
        super(formulaContext);
    }

    public AnyNumberSequence(LValue lValue, FormulaContext formulaContext) {
        super(lValue, formulaContext);
    }

    public AnyNumberSequence(ArrayCallback arrayCallback, FormulaContext formulaContext) {
        super(arrayCallback, formulaContext);
    }

    public AnyNumberSequence(AnySequence anySequence) {
        super(anySequence);
    }

    protected boolean isValidNext(LValue lValue) {
        if (lValue == null) {
            return false;
        }
        Type type = lValue.getValueType();
        if (type.isFlagSet("type.numeric")) {
            return true;
        }
        if (type.isFlagSet("type.logical")) {
            return true;
        }
        if (type.isFlagSet("type.text")) {
            return true;
        }
        return type.isFlagSet("type.any");
    }

    public Number nextNumber() throws EvaluationException {
        Object object = super.next();
        if (object instanceof Number) {
            return (Number)object;
        }
        return ZERO;
    }
}

