/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipwriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.LibRepositoryBoot;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipContentLocation;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipEntryOutputStream;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;

public class ZipContentItem
implements ContentItem {
    private boolean newItem;
    private String name;
    private String contentId;
    private ZipRepository repository;
    private ZipContentLocation parent;
    private String comment;
    private long time;
    private Integer method;
    private int compression;

    public ZipContentItem(String string, ZipRepository zipRepository, ZipContentLocation zipContentLocation) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (zipRepository == null) {
            throw new NullPointerException();
        }
        if (zipContentLocation == null) {
            throw new NullPointerException();
        }
        this.time = System.currentTimeMillis();
        this.name = string;
        this.repository = zipRepository;
        this.parent = zipContentLocation;
        this.contentId = RepositoryUtilities.buildName(this, "/");
        this.newItem = true;
        this.method = LibRepositoryBoot.ZIP_METHOD_DEFLATED;
        this.compression = -1;
    }

    public String getMimeType() throws ContentIOException {
        return this.getRepository().getMimeRegistry().getMimeType(this);
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        if (!this.newItem) {
            throw new ContentIOException("This item is no longer writeable.");
        }
        this.newItem = false;
        return new ZipEntryOutputStream(this);
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        throw new ContentIOException("This item is not readable.");
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isWriteable() {
        return this.newItem;
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return this.contentId;
    }

    public Object getAttribute(String string, String string2) {
        if ("org.jfree.repository".equals(string)) {
            if ("version".equals(string2)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(string)) {
            if ("comment".equals(string2)) {
                return this.comment;
            }
            if ("method".equals(string2)) {
                return this.method;
            }
            if ("compression".equals(string2)) {
                return new Integer(this.compression);
            }
        }
        return null;
    }

    public boolean setAttribute(String string, String string2, Object object) {
        if ("org.jfree.repository".equals(string)) {
            if ("version".equals(string2)) {
                if (object instanceof Date) {
                    Date date = (Date)object;
                    this.time = date.getTime();
                    return true;
                }
                if (object instanceof Number) {
                    Number number = (Number)object;
                    this.time = number.longValue();
                    return true;
                }
            }
        } else if ("org.jfree.repository.zip".equals(string)) {
            Integer n;
            int n2;
            if ("comment".equals(string2)) {
                if (object != null) {
                    this.comment = String.valueOf(object);
                    return true;
                }
                this.comment = null;
                return true;
            }
            if ("method".equals(string2)) {
                if (LibRepositoryBoot.ZIP_METHOD_STORED.equals(object)) {
                    this.method = LibRepositoryBoot.ZIP_METHOD_STORED;
                    return true;
                }
                if (LibRepositoryBoot.ZIP_METHOD_DEFLATED.equals(object)) {
                    this.method = LibRepositoryBoot.ZIP_METHOD_DEFLATED;
                    return true;
                }
            }
            if ("compression".equals(string2) && object instanceof Integer && (n2 = (n = (Integer)object).intValue()) >= 0 && n2 <= 9) {
                this.compression = n2;
                return true;
            }
        }
        return false;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public boolean delete() {
        return false;
    }
}

