/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts;

import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.Encoding;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingException;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Utf16LE;

public class ByteAccessUtilities {
    private ByteAccessUtilities() {
    }

    public static int readUShort(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public static long readULong(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        int n5 = byArray[n + 3] & 0xFF;
        long l = (long)n2 << 24;
        l |= (long)n3 << 16;
        l |= (long)n4 << 8;
        return l |= (long)n5;
    }

    public static float readFixed(byte[] byArray, int n) {
        short s = ByteAccessUtilities.readShort(byArray, n);
        int n2 = ByteAccessUtilities.readUShort(byArray, n + 2);
        if (n2 == 0 || s == 0) {
            return 0.0f;
        }
        return (float)s / ((float)n2 / 16384.0f);
    }

    public static long readLongDateTime(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        int n5 = byArray[n + 3] & 0xFF;
        int n6 = byArray[n + 4] & 0xFF;
        int n7 = byArray[n + 5] & 0xFF;
        int n8 = byArray[n + 6] & 0xFF;
        int n9 = byArray[n + 7] & 0xFF;
        long l = (long)n2 << 56;
        l |= (long)n3 << 48;
        l |= (long)n4 << 40;
        l |= (long)n5 << 32;
        l |= (long)n6 << 24;
        l |= (long)n7 << 16;
        l |= (long)n8 << 8;
        return l |= (long)n9;
    }

    public static byte[] readBytes(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static short readShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public static int readLong(byte[] byArray, int n) {
        int n2 = 0;
        n2 = (int)((long)n2 | (long)(byArray[n] & 0xFF) << 24);
        n2 = (int)((long)n2 | (long)(byArray[n + 1] & 0xFF) << 16);
        n2 = (int)((long)n2 | (long)(byArray[n + 2] & 0xFF) << 8);
        n2 = (int)((long)n2 | (long)(byArray[n + 3] & 0xFF));
        return n2;
    }

    public static int readZStringOffset(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n + n2, n + byArray.length);
        for (int i = n; i < n3; ++i) {
            if (byArray[i] != 0) continue;
            return i;
        }
        return n3;
    }

    public static String readZString(byte[] byArray, int n, int n2, String string) throws EncodingException {
        int n3 = Math.min(n + n2, n + byArray.length);
        for (int i = n; i < n3; ++i) {
            if (byArray[i] != 0) continue;
            return ByteAccessUtilities.readString(byArray, n, i - n, string);
        }
        return ByteAccessUtilities.readString(byArray, n, n3, string);
    }

    public static String readString(byte[] byArray, int n, int n2, String string) throws EncodingException {
        Encoding encoding = "UTF-16".equals(string) ? EncodingRegistry.getInstance().getEncoding("UTF-16LE") : EncodingRegistry.getInstance().getEncoding(string);
        ByteBuffer byteBuffer = new ByteBuffer(byArray, n, n2);
        CodePointBuffer codePointBuffer = encoding.decode(byteBuffer, null);
        return Utf16LE.getInstance().encodeString(codePointBuffer);
    }
}

