/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.pentaho.reporting.libraries.fonts.afm.AfmCharMetricsSection;
import org.pentaho.reporting.libraries.fonts.afm.AfmCompositeCharDataSection;
import org.pentaho.reporting.libraries.fonts.afm.AfmDirectionSection;
import org.pentaho.reporting.libraries.fonts.afm.AfmHeader;
import org.pentaho.reporting.libraries.fonts.afm.AfmKernDataSection;
import org.pentaho.reporting.libraries.fonts.afm.AfmParseUtilities;
import org.pentaho.reporting.libraries.fonts.afm.FontDataAsciiReader;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;

public class AfmFont
implements Serializable {
    private static final int PRE_HEADER = 0;
    private static final int IN_HEADER = 1;
    private static final int IN_METRICS = 2;
    private static final int IN_KERNDATA = 3;
    private static final int IN_COMPOSITES = 4;
    private static final int END_OF_FILE = 5;
    private static final int IN_DIRECTION = 6;
    private AfmHeader header;
    private AfmDirectionSection[] directionSections;
    private AfmCharMetricsSection charMetricsSection;
    private AfmKernDataSection kernDataSection;
    private AfmCompositeCharDataSection compositeCharDataSection;
    private boolean embeddable;
    private String fontName;
    private String familyName;
    private String filename;
    private FontDataInputSource input;

    public AfmFont(File file, boolean bl) throws IOException {
        FileFontDataInputSource fileFontDataInputSource = new FileFontDataInputSource(file);
        this.initialize(fileFontDataInputSource, bl);
        fileFontDataInputSource.dispose();
    }

    public AfmFont(FontDataInputSource fontDataInputSource, boolean bl) throws IOException {
        this.initialize(fontDataInputSource, bl);
    }

    private void initialize(FontDataInputSource fontDataInputSource, boolean bl) throws IOException {
        if (fontDataInputSource == null) {
            throw new NullPointerException();
        }
        this.filename = fontDataInputSource.getFileName();
        this.input = fontDataInputSource;
        this.embeddable = bl;
        this.header = new AfmHeader();
        this.directionSections = new AfmDirectionSection[2];
        this.directionSections[0] = new AfmDirectionSection();
        this.directionSections[1] = new AfmDirectionSection();
        this.charMetricsSection = new AfmCharMetricsSection();
        this.kernDataSection = new AfmKernDataSection();
        this.parseFontFile(fontDataInputSource);
        this.fontName = this.header.getFontName();
        if (this.fontName == null) {
            throw new IOException("This font does not define a font-name, therefore it is invalid.");
        }
        this.familyName = this.header.getFamilyName();
        if (this.familyName == null) {
            this.familyName = this.fontName;
        }
    }

    private void parseFontFile(FontDataInputSource fontDataInputSource) throws IOException {
        String string;
        int n = 0;
        int n2 = 0;
        FontDataAsciiReader fontDataAsciiReader = new FontDataAsciiReader(fontDataInputSource);
        block14: while ((string = fontDataAsciiReader.readLine()) != null) {
            if (string.length() == 0) continue;
            switch (n) {
                case 0: {
                    if (!string.startsWith("StartFontMetrics")) {
                        throw new IOException("Expected 'StartMetrics' as initial command line.");
                    }
                    n = 1;
                    continue block14;
                }
                case 1: {
                    if (string.startsWith("EndFontMetrics")) {
                        n = 5;
                        continue block14;
                    }
                    if (string.startsWith("StartDirection")) {
                        n = 6;
                        n2 = AfmParseUtilities.parseInt("StartDirection ", string);
                        continue block14;
                    }
                    if (string.startsWith("StartCharMetrics")) {
                        n = 2;
                        n2 = AfmParseUtilities.parseInt("StartCharMetrics ", string);
                        continue block14;
                    }
                    if (string.startsWith("StartKernData")) {
                        n = 3;
                        continue block14;
                    }
                    if (string.startsWith("StartComposites")) {
                        n = 4;
                        this.compositeCharDataSection = new AfmCompositeCharDataSection();
                        continue block14;
                    }
                    this.header.addData(string);
                    this.directionSections[0].add(string);
                    continue block14;
                }
                case 2: {
                    if (string.startsWith("EndCharMetrics")) {
                        n = 1;
                        n2 = 0;
                        continue block14;
                    }
                    this.charMetricsSection.add(string);
                    continue block14;
                }
                case 3: {
                    if (string.startsWith("EndKernData")) {
                        n = 1;
                        n2 = 0;
                        continue block14;
                    }
                    this.kernDataSection.add(string);
                    continue block14;
                }
                case 4: {
                    if (string.startsWith("EndComposites")) {
                        n = 1;
                        n2 = 0;
                        continue block14;
                    }
                    this.compositeCharDataSection.add(string);
                    continue block14;
                }
                case 5: {
                    continue block14;
                }
                case 6: {
                    if (string.startsWith("EndDirection")) {
                        n = 1;
                        n2 = 0;
                        continue block14;
                    }
                    switch (n2) {
                        case 0: {
                            this.directionSections[0].add(string);
                            continue block14;
                        }
                        case 1: {
                            this.directionSections[1].add(string);
                            continue block14;
                        }
                        case 2: {
                            this.directionSections[0].add(string);
                            this.directionSections[1].add(string);
                            continue block14;
                        }
                    }
                    throw new IllegalStateException("The Type " + n2 + " for the Direction-section was invalid.");
                }
            }
            throw new IllegalStateException("In Parse State " + n + ": Encountered line " + string);
        }
    }

    public int getMetricsSets() {
        return this.header.getMetricsSets();
    }

    public AfmDirectionSection getDirectionSection(int n) {
        return this.directionSections[n];
    }

    public FontDataInputSource getInput() {
        return this.input;
    }

    public AfmHeader getHeader() {
        return this.header;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }

    public void dispose() {
        this.input.dispose();
    }
}

