/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import java.io.Serializable;

public class CodePointBuffer
implements Serializable {
    private int[] data;
    private int offset;
    private int cursor;

    public CodePointBuffer(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        this.data = nArray;
        this.offset = 0;
        this.cursor = 0;
    }

    public CodePointBuffer(int n) {
        this.data = new int[n];
        this.offset = 0;
        this.cursor = 0;
    }

    public int[] getBuffer(int[] nArray) {
        int n = this.getLength();
        if (n < nArray.length) {
            System.arraycopy(this.data, this.offset, nArray, 0, n);
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(this.data, this.offset, nArray2, 0, n);
        return nArray2;
    }

    public int[] getBuffer() {
        int n = this.getLength();
        int[] nArray = new int[n];
        System.arraycopy(this.data, this.offset, nArray, 0, n);
        return nArray;
    }

    public int[] getData() {
        return this.data;
    }

    public void setData(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Length < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Offset < 0");
        }
        if (n + n2 > nArray.length) {
            throw new IllegalArgumentException("Length + Offset");
        }
        this.data = nArray;
        this.cursor = n + n2;
        this.offset = n2;
    }

    public int getLength() {
        return this.cursor - this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void ensureSize(int n) {
        if (this.data.length < this.offset + n) {
            int[] nArray = new int[this.offset + n];
            System.arraycopy(this.data, 0, nArray, 0, this.data.length);
            this.data = nArray;
        }
    }

    public void setCursor(int n) {
        if (n < this.offset) {
            throw new IndexOutOfBoundsException();
        }
        if (n > this.data.length) {
            throw new IndexOutOfBoundsException();
        }
        this.cursor = n;
    }
}

