/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding.manual;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.Encoding;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingErrorType;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingException;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Utf16LE;

public class BuiltInJavaEncoding
implements Encoding {
    private String name;
    private boolean fastMode;

    public BuiltInJavaEncoding(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.fastMode = bl;
    }

    public CodePointBuffer decode(ByteBuffer byteBuffer, CodePointBuffer codePointBuffer) throws EncodingException {
        try {
            byte[] byArray = byteBuffer.getData();
            String string = new String(byArray, byteBuffer.getOffset(), byteBuffer.getLength(), this.name);
            return Utf16LE.getInstance().decodeString(string, codePointBuffer);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncodingException("Failed to encode the string: " + unsupportedEncodingException.getMessage());
        }
    }

    public CodePointBuffer decode(ByteBuffer byteBuffer, CodePointBuffer codePointBuffer, EncodingErrorType encodingErrorType) throws EncodingException {
        return this.decode(byteBuffer, codePointBuffer);
    }

    public ByteBuffer encode(CodePointBuffer codePointBuffer, ByteBuffer byteBuffer) throws EncodingException {
        String string = Utf16LE.getInstance().encodeString(codePointBuffer);
        try {
            byte[] byArray = string.getBytes(this.name);
            int n = codePointBuffer.getLength();
            if (byteBuffer == null) {
                byteBuffer = new ByteBuffer(n * 2);
            } else if (byteBuffer.getLength() * 2 < n) {
                byteBuffer.ensureSize(n * 2);
            }
            System.arraycopy(byArray, 0, byteBuffer.getData(), byteBuffer.getOffset(), byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncodingException("Failed to encode the string: " + unsupportedEncodingException.getMessage());
        }
        return byteBuffer;
    }

    public ByteBuffer encode(CodePointBuffer codePointBuffer, ByteBuffer byteBuffer, EncodingErrorType encodingErrorType) throws EncodingException {
        return this.encode(codePointBuffer, byteBuffer);
    }

    public String getName() {
        return this.name;
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public boolean isUnicodeCharacterSupported(int n) {
        if (this.fastMode) {
            return true;
        }
        if (n == 63) {
            return true;
        }
        String string = String.valueOf((char)n);
        try {
            byte[] byArray = string.getBytes(this.name);
            if (byArray.length != 1) {
                return true;
            }
            return 63 != byArray[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Failed to encode the string: " + unsupportedEncodingException.getMessage());
        }
    }
}

