/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.monospace;

import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class MonospaceFontMetrics
implements FontMetrics {
    private static final long MICRO_DOTS_PER_INCH = 72000L;
    private long charHeight;
    private long charWidth;

    public MonospaceFontMetrics(float f, float f2) {
        this.charHeight = (long)(72000.0f / f2);
        this.charWidth = (long)(72000.0f / f);
    }

    public boolean isUniformFontMetrics() {
        return true;
    }

    public long getAscent() {
        return (long)(0.7 * (double)this.charHeight);
    }

    public long getDescent() {
        return (long)(0.3 * (double)this.charHeight);
    }

    public long getLeading() {
        return 0L;
    }

    public long getXHeight() {
        return (long)(0.5 * (double)this.charHeight);
    }

    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.charHeight / 20L);
    }

    public long getUnderlinePosition() {
        return this.getAscent() + Math.max(1000L, this.charHeight / 20L);
    }

    public long getStrikeThroughPosition() {
        return (long)(0.5 * (double)this.getXHeight());
    }

    public long getMaxAscent() {
        return this.getAscent();
    }

    public long getMaxDescent() {
        return this.getDescent();
    }

    public long getMaxHeight() {
        return this.charHeight;
    }

    public long getMaxCharAdvance() {
        return this.charWidth;
    }

    public long getCharWidth(int n) {
        return this.charWidth;
    }

    public long getKerning(int n, int n2) {
        return 0L;
    }

    public long getItalicAngle() {
        return 0L;
    }

    public BaselineInfo getBaselines(int n, BaselineInfo baselineInfo) {
        if (baselineInfo == null) {
            baselineInfo = new BaselineInfo();
        }
        baselineInfo.setBaseline(0, 0L);
        baselineInfo.setBaseline(1, this.charHeight / 2L);
        baselineInfo.setBaseline(2, this.charHeight / 2L);
        baselineInfo.setBaseline(3, this.charHeight / 2L);
        baselineInfo.setBaseline(4, this.getMaxAscent());
        baselineInfo.setBaseline(5, this.getMaxHeight());
        return baselineInfo;
    }
}

