/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.pentaho.reporting.libraries.fonts.tools.ByteTable;

public class GraphemeClassifierGenerator {
    private static final int MAX_CHARS = 0x110000;
    private static final int MAX_RANGES = 4352;

    private GraphemeClassifierGenerator() {
    }

    public static void main(String[] stringArray) throws IOException {
        String string;
        File file;
        File file2;
        if (stringArray.length < 2) {
            System.out.println("Give the mapping files as first parameter and the target-file as second-parameter.");
            System.exit(1);
        }
        if (!((file2 = new File(stringArray[0])).isFile() && file2.exists() && file2.canRead())) {
            System.out.println("Mapping file is not valid: " + file2);
            System.exit(1);
        }
        if ((file = new File(stringArray[1])).exists() && !file.canWrite()) {
            System.out.println("Target file is not valid: " + file);
            System.exit(1);
        }
        ByteTable byteTable = new ByteTable(4352, 256);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            int n3;
            if (string.length() > 0 && string.charAt(0) == '#' || string.trim().length() == 0 || (n3 = string.indexOf(59)) < 1) continue;
            int n4 = string.indexOf(35);
            if (n4 == -1) {
                n4 = string.length();
            }
            String string2 = string.substring(0, n3).trim();
            String string3 = string.substring(n3 + 1, n4).trim();
            int n5 = string2.indexOf("..");
            if (n5 == -1) {
                n2 = Integer.parseInt(string2, 16);
                n = n2 >> 8;
                byteTable.setByte(n, n2 & 0xFF, GraphemeClassifierGenerator.classify(string3));
                continue;
            }
            n2 = Integer.parseInt(string2.substring(0, n5), 16);
            n = Integer.parseInt(string2.substring(n5 + 2), 16);
            for (int i = n2; i < n; ++i) {
                int n6 = i >> 8;
                byteTable.setByte(n6, i & 0xFF, GraphemeClassifierGenerator.classify(string3));
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(byteTable);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    private static byte classify(String string) {
        if ("CR".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("LF".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("Control".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("Extend".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("L".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("LV".equalsIgnoreCase(string)) {
            return 24;
        }
        if ("LVT".equalsIgnoreCase(string)) {
            return 72;
        }
        if ("V".equalsIgnoreCase(string)) {
            return 56;
        }
        if ("T".equalsIgnoreCase(string)) {
            return 104;
        }
        if ("Other".equalsIgnoreCase(string)) {
            return 0;
        }
        throw new IllegalStateException("Parse Error: Classification is not known: " + string);
    }
}

