/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.FontException;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontSource;
import org.pentaho.reporting.libraries.fonts.truetype.FontHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.NameTable;
import org.pentaho.reporting.libraries.fonts.truetype.OS2Table;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontIdentifier;

public class TrueTypeFontRecord
implements FontSource {
    private int collectionIndex;
    private long offset;
    private boolean bold;
    private boolean italics;
    private boolean oblique;
    private FontFamily family;
    private boolean embeddable;
    private boolean nonWindows;
    private TrueTypeFontIdentifier identifier;
    private String name;
    private String variant;

    public TrueTypeFontRecord(TrueTypeFont trueTypeFont, FontFamily fontFamily) throws IOException, FontException {
        if (trueTypeFont == null) {
            throw new NullPointerException("The font must not be null");
        }
        if (fontFamily == null) {
            throw new NullPointerException("The font-family must not be null");
        }
        this.family = fontFamily;
        this.collectionIndex = trueTypeFont.getCollectionIndex();
        this.offset = trueTypeFont.getOffset();
        OS2Table oS2Table = (OS2Table)trueTypeFont.getTable(1330851634L);
        if (oS2Table != null) {
            this.embeddable = !oS2Table.isRestricted();
            this.nonWindows = false;
        } else {
            this.nonWindows = true;
        }
        NameTable nameTable = (NameTable)trueTypeFont.getTable(1851878757L);
        if (nameTable == null) {
            throw new FontException("This font does not have a 'name' table. It is not valid.");
        }
        this.name = nameTable.getPrimaryName(4);
        this.variant = nameTable.getPrimaryName(2);
        FontHeaderTable fontHeaderTable = (FontHeaderTable)trueTypeFont.getTable(1751474532L);
        if (fontHeaderTable != null) {
            this.bold = fontHeaderTable.isBold();
            this.italics = fontHeaderTable.isItalic();
        } else {
            OS2Table oS2Table2 = (OS2Table)trueTypeFont.getTable(1330851634L);
            if (oS2Table2 != null) {
                this.bold = oS2Table2.isBold();
                this.italics = oS2Table2.isItalic();
            } else {
                this.bold = this.variant.toLowerCase().indexOf("bold") >= 0;
                this.italics = this.variant.toLowerCase().indexOf("italic") >= 0;
            }
        }
        this.oblique = this.oblique || this.variant.toLowerCase().indexOf("oblique") >= 0;
        this.identifier = new TrueTypeFontIdentifier(trueTypeFont.getFilename(), this.name, this.variant, this.collectionIndex, this.offset);
    }

    public long getOffset() {
        return this.offset;
    }

    public FontFamily getFamily() {
        return this.family;
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italics;
    }

    public boolean isOblique() {
        return this.oblique;
    }

    public String getFontSource() {
        return this.identifier.getFontSource();
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TrueTypeFontRecord trueTypeFontRecord = (TrueTypeFontRecord)object;
        if (this.bold != trueTypeFontRecord.bold) {
            return false;
        }
        if (this.embeddable != trueTypeFontRecord.embeddable) {
            return false;
        }
        if (this.italics != trueTypeFontRecord.italics) {
            return false;
        }
        if (this.oblique != trueTypeFontRecord.oblique) {
            return false;
        }
        if (!this.name.equals(trueTypeFontRecord.name)) {
            return false;
        }
        return this.variant.equals(trueTypeFontRecord.variant);
    }

    public FontIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean isNonWindows() {
        return this.nonWindows;
    }

    public int hashCode() {
        int n = this.bold ? 1 : 0;
        n = 29 * n + (this.italics ? 1 : 0);
        n = 29 * n + (this.oblique ? 1 : 0);
        n = 29 * n + (this.embeddable ? 1 : 0);
        n = 29 * n + this.name.hashCode();
        n = 29 * n + this.variant.hashCode();
        return n;
    }
}

