/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ParseException
extends SAXException {
    private int line;
    private int column;
    private boolean noOwnMessage;
    private static final long serialVersionUID = 1188118105409903580L;

    public ParseException(String string) {
        super(string);
        this.fillLocation(null);
        this.noOwnMessage = string == null;
    }

    public ParseException(Exception exception) {
        super(exception);
        this.fillLocation(null);
        this.noOwnMessage = true;
    }

    public ParseException(String string, Exception exception) {
        super(string, exception);
        this.fillLocation(null);
        this.noOwnMessage = string == null;
    }

    public ParseException(String string, Locator locator) {
        super(string);
        this.fillLocation(locator);
        this.noOwnMessage = string == null;
    }

    public ParseException(Exception exception, Locator locator) {
        super(exception);
        this.fillLocation(locator);
        this.noOwnMessage = true;
    }

    public ParseException(String string, Exception exception, Locator locator) {
        super(string, exception);
        this.fillLocation(locator);
        this.noOwnMessage = string == null;
    }

    public String getMessage() {
        if (this.noOwnMessage) {
            Exception exception = this.getException();
            if (exception instanceof ParseException) {
                return exception.getMessage();
            }
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(exception.getMessage()));
            stringBuffer.append(" [Location: Line=");
            stringBuffer.append(this.line);
            stringBuffer.append(" Column=");
            stringBuffer.append(this.column);
            stringBuffer.append("] ");
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(super.getMessage()));
        stringBuffer.append(" [Location: Line=");
        stringBuffer.append(this.line);
        stringBuffer.append(" Column=");
        stringBuffer.append(this.column);
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }

    protected void fillLocation(Locator locator) {
        if (locator == null) {
            this.line = -1;
            this.column = -1;
        } else {
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.getException() != null) {
            printStream.println("ParentException: ");
            this.getException().printStackTrace(printStream);
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.getException() != null) {
            printWriter.println("ParentException: ");
            this.getException().printStackTrace(printWriter);
        }
    }
}

