/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.writer;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriterSupport;

public class XmlWriter
extends XmlWriterSupport {
    private Writer writer;

    public XmlWriter(Writer writer) {
        this(writer, "  ");
    }

    public XmlWriter(Writer writer, TagDescription tagDescription) {
        this(writer, tagDescription, "  ");
    }

    public XmlWriter(Writer writer, String string) {
        this(writer, new DefaultTagDescription(), string);
    }

    public XmlWriter(Writer writer, TagDescription tagDescription, String string) {
        super(tagDescription, string);
        if (writer == null) {
            throw new NullPointerException("Writer must not be null.");
        }
        this.writer = writer;
    }

    public XmlWriter(Writer writer, TagDescription tagDescription, String string, String string2) {
        super(tagDescription, string, string2);
        if (writer == null) {
            throw new NullPointerException("Writer must not be null.");
        }
        this.writer = writer;
    }

    public void writeXmlDeclaration(String string) throws IOException {
        if (string == null) {
            this.writer.write("<?xml version=\"1.0\"?>");
            this.writer.write(this.getLineSeparator());
            return;
        }
        this.writer.write("<?xml version=\"1.0\" encoding=\"");
        this.writer.write(string);
        this.writer.write("\"?>");
        this.writer.write(this.getLineSeparator());
    }

    public void writeTag(String string, String string2, boolean bl) throws IOException {
        if (bl) {
            this.writeTag(this.writer, string, string2, null, true);
        } else {
            this.writeTag(this.writer, string, string2, null, false);
        }
    }

    public void writeCloseTag() throws IOException {
        super.writeCloseTag(this.writer);
    }

    public void writeTag(String string, String string2, String string3, String string4, boolean bl) throws IOException {
        this.writeTag(this.writer, string, string2, string3, string4, bl);
    }

    public void writeTag(String string, String string2, AttributeList attributeList, boolean bl) throws IOException {
        this.writeTag(this.writer, string, string2, attributeList, bl);
    }

    public void writeText(String string) throws IOException {
        this.writer.write(string);
        this.setLineEmpty(false);
    }

    public void writeTextNormalized(String string, boolean bl) throws IOException {
        this.writeTextNormalized(this.writer, string, bl);
    }

    public void writeStream(Reader reader) throws IOException {
        IOUtils.getInstance().copyWriter(reader, this.writer);
        this.setLineEmpty(false);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void writeComment(String string) throws IOException {
        super.writeComment(this.writer, string);
    }

    public void writeNewLine() throws IOException {
        super.writeNewLine(this.writer);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

