/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.editor.ext.html.parser.SyntaxParserResult;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.hints.FixLibDeclaration;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LibraryDeclarationChecker
extends HintsProvider {
    @Override
    public List<Hint> compute(RuleContext ruleContext) {
        ArrayList<Hint> arrayList = new ArrayList<Hint>();
        this.checkLibraryDeclarations(arrayList, ruleContext);
        return arrayList;
    }

    private void checkLibraryDeclarations(final List<Hint> list, final RuleContext ruleContext) {
        Object object;
        Object object22;
        final HtmlParserResult htmlParserResult = (HtmlParserResult)ruleContext.parserResult;
        final Snapshot snapshot = htmlParserResult.getSnapshot();
        Set set = htmlParserResult.getNamespaces().keySet();
        final ArrayList<FaceletsLibrary> arrayList = new ArrayList<FaceletsLibrary>();
        JsfSupport jsfSupport = JsfSupport.findFor((Document)ruleContext.doc);
        Map<Object, Object> map = Collections.emptyMap();
        if (jsfSupport != null) {
            map = jsfSupport.getFaceletsLibraries();
        }
        final HashMap hashMap = new HashMap();
        AstNode astNode = htmlParserResult.root();
        final Document document = snapshot.getSource().getDocument(true);
        final AtomicReference atomicReference = new AtomicReference();
        document.render(new Runnable(){

            @Override
            public void run() {
                try {
                    atomicReference.set(document.getText(0, document.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
        final String string = (String)atomicReference.get();
        AstNodeVisitor astNodeVisitor = new AstNodeVisitor(){

            public void visit(AstNode astNode) {
                Collection collection = astNode.getAttributes(new AstNode.AttributeFilter(){

                    public boolean accepts(AstNode.Attribute attribute) {
                        return "xmlns".equals(attribute.namespacePrefix());
                    }
                });
                for (AstNode.Attribute attribute : collection) {
                    hashMap.put(attribute.unquotedValue(), attribute);
                }
            }
        };
        AstNodeUtils.visitChildren((AstNode)astNode, (AstNodeVisitor)astNodeVisitor, (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
        AstNode astNode2 = htmlParserResult.root(SyntaxParserResult.UNDECLARED_TAGS_NAMESPACE);
        if (astNode2 != null) {
            AstNodeUtils.visitChildren((AstNode)astNode2, (AstNodeVisitor)astNodeVisitor, (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
            AstNodeUtils.visitChildren((AstNode)astNode2, (AstNodeVisitor)new AstNodeVisitor(){

                public void visit(AstNode astNode) {
                    if (astNode.type() == AstNode.NodeType.OPEN_TAG && astNode.getNamespacePrefix() != null) {
                        ArrayList<FixLibDeclaration> arrayList = new ArrayList<FixLibDeclaration>();
                        List<FaceletsLibrary> list2 = FixLibDeclaration.getLibsByPrefix((Document)ruleContext.doc, astNode.getNamespacePrefix());
                        for (FaceletsLibrary faceletsLibrary : list2) {
                            FixLibDeclaration fixLibDeclaration = new FixLibDeclaration((Document)ruleContext.doc, astNode.getNamespacePrefix(), faceletsLibrary);
                            arrayList.add(fixLibDeclaration);
                        }
                        Hint hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNDECLARED_COMPONENT"), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, string, astNode.startOffset(), astNode.startOffset() + astNode.name().length() + 1), arrayList, 50);
                        list.add(hint);
                    }
                }
            });
        }
        for (Object object22 : set) {
            object = (FaceletsLibrary)map.get(object22);
            if (object != null) {
                arrayList.add((FaceletsLibrary)object);
                continue;
            }
            AstNode.Attribute attribute = (AstNode.Attribute)hashMap.get(object22);
            if (attribute == null) continue;
            Hint hint = new Hint((Rule)DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_MISSING_LIBRARY"), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, string, attribute.nameOffset(), attribute.valueOffset() + attribute.value().length()), Collections.emptyList(), 50);
            list.add(hint);
        }
        final ArrayList arrayList2 = new ArrayList();
        ruleContext.doc.render(new Runnable(){

            @Override
            public void run() {
                for (FaceletsLibrary faceletsLibrary : arrayList) {
                    AstNode.Attribute attribute;
                    AstNode astNode = htmlParserResult.root(faceletsLibrary.getNamespace());
                    if (astNode == null) continue;
                    final int[] nArray = new int[1];
                    AstNodeUtils.visitChildren((AstNode)astNode, (AstNodeVisitor)new AstNodeVisitor(){

                        public void visit(AstNode astNode) {
                            nArray[0] = nArray[0] + 1;
                        }
                    }, (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
                    nArray[0] = nArray[0] + (LibraryDeclarationChecker.this.isFunctionLibraryPrefixUsedInEL(ruleContext, faceletsLibrary) ? 1 : 0);
                    if (nArray[0] != 0 || (attribute = (AstNode.Attribute)hashMap.get(faceletsLibrary.getNamespace())) == null) continue;
                    int n = attribute.nameOffset();
                    int n2 = attribute.valueOffset() + attribute.value().length();
                    try {
                        arrayList2.add(new PositionRange(ruleContext, n, n2));
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
        });
        object22 = arrayList2.iterator();
        while (object22.hasNext()) {
            object = (PositionRange)object22.next();
            int n = ((PositionRange)object).getFrom();
            int n2 = ((PositionRange)object).getTo();
            List<HintFix> list2 = Arrays.asList(new RemoveUnusedLibraryDeclarationHintFix(ruleContext.doc, (PositionRange)object), new RemoveUnusedLibrariesDeclarationHintFix(ruleContext.doc, arrayList2));
            Hint hint = new Hint((Rule)DEFAULT_WARNING_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNUSED_LIBRARY_DECLARATION"), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, string, n, n2), list2, 50);
            list.add(hint);
        }
    }

    private boolean isFunctionLibraryPrefixUsedInEL(RuleContext ruleContext, FaceletsLibrary faceletsLibrary) {
        String string = (String)((HtmlParserResult)ruleContext.parserResult).getNamespaces().get(faceletsLibrary.getNamespace());
        BaseDocument baseDocument = ruleContext.doc;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            TokenSequence tokenSequence2 = tokenSequence.embeddedJoined(ELTokenId.language());
            if (tokenSequence2 == null) continue;
            tokenSequence2.moveStart();
            while (tokenSequence2.moveNext()) {
                if (tokenSequence2.token().id() != ELTokenId.TAG_LIB_PREFIX || !CharSequenceUtilities.equals((CharSequence)string, (Object)tokenSequence2.token().text())) continue;
                return true;
            }
        }
        return false;
    }

    private static final class PositionRange {
        private Position from;
        private Position to;

        public PositionRange(RuleContext ruleContext, int n, int n2) throws BadLocationException {
            Snapshot snapshot = ruleContext.parserResult.getSnapshot();
            this.from = ruleContext.doc.createPosition(snapshot.getOriginalOffset(n));
            this.to = ruleContext.doc.createPosition(snapshot.getOriginalOffset(n2));
        }

        public int getFrom() {
            return this.from.getOffset();
        }

        public int getTo() {
            return this.to.getOffset();
        }
    }

    private static class RemoveUnusedLibrariesDeclarationHintFix
    implements HintFix {
        protected Collection<PositionRange> ranges = new ArrayList<PositionRange>();
        protected BaseDocument document;

        public RemoveUnusedLibrariesDeclarationHintFix(BaseDocument baseDocument, Collection<PositionRange> collection) {
            this.document = baseDocument;
            this.ranges = collection;
        }

        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_ALL_UNUSED_LIBRARIES_DECLARATION");
        }

        public void implement() throws Exception {
            this.document.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (PositionRange positionRange : RemoveUnusedLibrariesDeclarationHintFix.this.ranges) {
                            int n;
                            int n2 = positionRange.getFrom();
                            int n3 = positionRange.getTo();
                            int n4 = Utilities.getRowStart((BaseDocument)RemoveUnusedLibrariesDeclarationHintFix.this.document, (int)n2);
                            if (n4 > (n = Utilities.getFirstNonWhiteBwd((BaseDocument)RemoveUnusedLibrariesDeclarationHintFix.this.document, (int)n2))) {
                                n2 = n4 - 1;
                            }
                            RemoveUnusedLibrariesDeclarationHintFix.this.document.remove(n2, n3 - n2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static class RemoveUnusedLibraryDeclarationHintFix
    extends RemoveUnusedLibrariesDeclarationHintFix {
        public RemoveUnusedLibraryDeclarationHintFix(BaseDocument baseDocument, PositionRange positionRange) {
            super(baseDocument, Collections.singletonList(positionRange));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_UNUSED_LIBRARY_DECLARATION");
        }
    }
}

