/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.netbeans.modules.i18n.form.FormI18nInteger;
import org.netbeans.modules.i18n.form.FormI18nSupport;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FormI18nIntegerEditor
extends PropertyEditorSupport
implements FormAwareEditor,
NamedPropertyEditor,
ExPropertyEditor,
XMLPropertyEditor {
    private FormI18nInteger formI18nInteger;
    private FormDataObject sourceDataObject;
    private PropertyEnv env;
    public static final String XML_RESOURCESTRING = "ResourceString";
    public static final String XML_ARGUMENT = "Argument";
    public static final String ATTR_BUNDLE = "bundle";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_IDENTIFIER = "identifier";
    public static final String ATTR_REPLACE_FORMAT = "replaceFormat";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_JAVACODE = "javacode";
    private static final int MAX_INDEX = 1000;
    private final ResourceBundle bundle = NbBundle.getBundle(FormI18nIntegerEditor.class);

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void setAsText(String string) {
    }

    @Override
    public String getAsText() {
        FormI18nInteger formI18nInteger = (FormI18nInteger)((Object)this.getValue());
        DataObject dataObject = formI18nInteger.getSupport().getResourceHolder().getResource();
        if (dataObject == null || formI18nInteger.getKey() == null) {
            return this.bundle.getString("TXT_InvalidValue");
        }
        String string = Util.getResourceName((FileObject)formI18nInteger.getSupport().getSourceDataObject().getPrimaryFile(), (FileObject)dataObject.getPrimaryFile(), (char)'/', (boolean)false);
        return MessageFormat.format(this.bundle.getString("TXT_Key"), formI18nInteger.getKey(), string);
    }

    @Override
    public String getJavaInitializationString() {
        return ((FormI18nInteger)((Object)this.getValue())).getReplaceString();
    }

    @Override
    public Component getCustomEditor() {
        return new CustomEditor((I18nString)new FormI18nInteger((FormI18nInteger)((Object)this.getValue())), this.getProject(), this.sourceDataObject.getPrimaryFile());
    }

    private Project getProject() {
        return Util.getProjectFor((DataObject)this.sourceDataObject);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Object getValue() {
        if (this.formI18nInteger == null) {
            this.formI18nInteger = this.createFormI18nInteger();
            if (I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject) != null) {
                this.formI18nInteger.getSupport().getResourceHolder().setResource(I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject));
            }
        }
        return this.formI18nInteger;
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof FormI18nInteger) {
            this.formI18nInteger = (FormI18nInteger)((Object)object);
        } else {
            this.formI18nInteger = this.createFormI18nInteger();
            if (I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject) != null) {
                this.formI18nInteger.getSupport().getResourceHolder().setResource(I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject));
            }
        }
    }

    private FormI18nInteger createFormI18nInteger() {
        return new FormI18nInteger(new FormI18nSupport.Factory().createI18nSupport((DataObject)this.sourceDataObject));
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.sourceDataObject = FormEditorSupport.getFormDataObject((FormModel)formModel);
    }

    public void updateFormVersionLevel() {
    }

    public String getDisplayName() {
        return NbBundle.getMessage(FormI18nIntegerEditor.class, (String)"PROP_IntegerEditor_name");
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
    }

    public void readFromXML(Node node) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Node node2;
        if (!XML_RESOURCESTRING.equals(node.getNodeName())) {
            throw new IOException();
        }
        FormI18nInteger formI18nInteger = this.createFormI18nInteger();
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            Object object4;
            String string;
            node2 = namedNodeMap.getNamedItem(ATTR_BUNDLE);
            object3 = node2 == null ? null : node2.getNodeValue();
            node2 = namedNodeMap.getNamedItem(ATTR_KEY);
            String string2 = string = node2 == null ? null : node2.getNodeValue();
            if (object3 != null && (object4 = this.sourceDataObject.getPrimaryFile()) != null && (object2 = Util.getResource((FileObject)object4, (String)object3)) != null) {
                try {
                    object = DataObject.find((FileObject)object2);
                    if (object.getClass().equals(formI18nInteger.getSupport().getResourceHolder().getResourceClasses()[0])) {
                        formI18nInteger.getSupport().getResourceHolder().setResource((DataObject)object);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (string != null && string.length() > 0) {
                formI18nInteger.setKey(string);
                formI18nInteger.setValue(formI18nInteger.getSupport().getResourceHolder().getValueForKey(string));
                formI18nInteger.setComment(formI18nInteger.getSupport().getResourceHolder().getCommentForKey(string));
            }
            ((JavaI18nSupport)formI18nInteger.getSupport()).createIdentifier();
            node2 = namedNodeMap.getNamedItem(ATTR_IDENTIFIER);
            if (node2 != null) {
                String string3 = object4 = node2 == null ? null : node2.getNodeValue();
                if (object4 != null) {
                    ((JavaI18nSupport)formI18nInteger.getSupport()).setIdentifier((String)object4);
                }
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_REPLACE_FORMAT)) != null) {
                object4 = node2.getNodeValue();
                if (object4 != null && ((String)object4).length() > 0) {
                    object2 = new HashMap(6);
                    object2.put("0", "{identifier}");
                    object2.put("1", "{key}");
                    object2.put("2", "{bundleNameSlashes}");
                    object2.put("3", "{bundleNameDots}");
                    object2.put("4", "{sourceFileName}");
                    object2.put("fileName", "{sourceFileName}");
                    object = MapFormat.format((String)object4, (Map)object2);
                    formI18nInteger.setReplaceFormat((String)object);
                }
            } else {
                formI18nInteger.setReplaceFormat(I18nUtil.getDefaultReplaceFormat((boolean)false));
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
        if (node instanceof Element) {
            int n;
            Object object5;
            node2 = (Element)node;
            object3 = node2.getElementsByTagName(XML_ARGUMENT);
            int n2 = -1;
            for (int i = 0; i < object3.getLength(); ++i) {
                object2 = object3.item(i).getAttributes();
                object = object2.getNamedItem(ATTR_INDEX);
                Object object6 = object5 = object == null ? null : object.getNodeValue();
                if (object5 == null) continue;
                try {
                    int n3 = Integer.parseInt((String)object5);
                    if (n3 <= n2 || n3 >= 1000) continue;
                    n2 = n3;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String[] stringArray = new String[n2 + 1];
            for (n = 0; n < object3.getLength(); ++n) {
                String string;
                object = object3.item(n).getAttributes();
                object5 = object.getNamedItem(ATTR_INDEX);
                String string4 = string = object5 == null ? null : object5.getNodeValue();
                if (string == null) continue;
                try {
                    String string5;
                    int n4 = Integer.parseInt(string);
                    if (n4 >= 1000) continue;
                    Node node3 = object.getNamedItem(ATTR_JAVACODE);
                    stringArray[n4] = string5 = node3 == null ? null : node3.getNodeValue();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] != null) continue;
                stringArray[n] = "";
            }
            formI18nInteger.setArguments(stringArray);
        }
        this.setValue((Object)formI18nInteger);
    }

    public Node storeToXML(Document document) {
        String string;
        Element element = document.createElement(XML_RESOURCESTRING);
        if (this.formI18nInteger.getSupport().getResourceHolder().getResource() == null) {
            string = "";
        } else {
            string = Util.getResourceName((FileObject)this.formI18nInteger.getSupport().getSourceDataObject().getPrimaryFile(), (FileObject)this.formI18nInteger.getSupport().getResourceHolder().getResource().getPrimaryFile(), (char)'/', (boolean)true);
            if (string == null) {
                string = "";
            }
        }
        element.setAttribute(ATTR_BUNDLE, string);
        element.setAttribute(ATTR_KEY, this.formI18nInteger.getKey() == null ? "" : this.formI18nInteger.getKey());
        JavaI18nSupport javaI18nSupport = (JavaI18nSupport)this.formI18nInteger.getSupport();
        if (javaI18nSupport.getIdentifier() == null) {
            javaI18nSupport.createIdentifier();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put(ATTR_IDENTIFIER, javaI18nSupport.getIdentifier());
        element.setAttribute(ATTR_REPLACE_FORMAT, this.formI18nInteger.getReplaceFormat() == null ? "" : MapFormat.format((String)this.formI18nInteger.getReplaceFormat(), hashMap));
        String[] stringArray = this.formI18nInteger.getArguments();
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = document.createElement(XML_ARGUMENT);
            element2.setAttribute(ATTR_INDEX, "" + i);
            element2.setAttribute(ATTR_JAVACODE, stringArray[i]);
            try {
                element.appendChild(element2);
                continue;
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return element;
    }

    private static boolean isNonNegativeInteger(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c < '0' || c > '9') {
            return false;
        }
        if (string.length() == 1) {
            return true;
        }
        for (char c2 : string.toCharArray()) {
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    private class CustomEditor
    extends I18nPanel
    implements VetoableChangeListener {
        private final ResourceBundle bundle;

        public CustomEditor(I18nString i18nString, Project project, FileObject fileObject) {
            super(i18nString.getSupport().getPropertyPanel(), false, project, fileObject);
            this.bundle = NbBundle.getBundle(FormI18nIntegerEditor.class);
            this.setI18nString(i18nString);
            FormI18nIntegerEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            FormI18nIntegerEditor.this.env.addVetoableChangeListener((VetoableChangeListener)this);
            HelpCtx.setHelpIDString((JComponent)((Object)this), (String)"internation.formed");
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("state".equals(propertyChangeEvent.getPropertyName()) && this.isVisible()) {
                String string = null;
                I18nString i18nString = this.getI18nString();
                string = i18nString == null || !(i18nString instanceof FormI18nInteger) ? "MSG_InvalidValue" : (i18nString.getSupport().getResourceHolder().getResource() == null ? "MSG_BundleNotSpecified" : (i18nString.getKey() == null ? "MSG_KeyNotSpecified" : this.checkMnemonicIndex(i18nString.getValue())));
                if (string != null) {
                    throw new PropertyVetoException(this.bundle.getString(string), propertyChangeEvent);
                }
                i18nString.getSupport().getResourceHolder().addProperty((Object)i18nString.getKey(), (Object)i18nString.getValue(), i18nString.getComment(), false);
                FormI18nIntegerEditor.this.setValue(i18nString);
            }
        }

        private String checkMnemonicIndex(String string) {
            if (string == null || string.length() == 0) {
                return "MSG_MnemonicIndexNotSpecified";
            }
            if (!FormI18nIntegerEditor.isNonNegativeInteger(string)) {
                return "MSG_MnemonicIndexIsInvalid";
            }
            return null;
        }
    }
}

