/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.netbeans.modules.i18n.form.FormI18nString;
import org.netbeans.modules.i18n.form.FormI18nSupport;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FormI18nStringEditor
extends PropertyEditorSupport
implements FormAwareEditor,
NamedPropertyEditor,
XMLPropertyEditor,
ExPropertyEditor {
    private FormDataObject sourceDataObject;
    private PropertyEnv env;
    public static final String XML_RESOURCESTRING = "ResourceString";
    private static final String XML_PLAINSTRING = "PlainString";
    public static final String XML_ARGUMENT = "Argument";
    public static final String ATTR_BUNDLE = "bundle";
    public static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    public static final String ATTR_IDENTIFIER = "identifier";
    public static final String ATTR_REPLACE_FORMAT = "replaceFormat";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_JAVACODE = "javacode";
    private static final int MAX_INDEX = 1000;
    private static final String CODE_MARK_END = "*/\n\\0";
    private static final String CODE_MARK_LINE_COMMENT = "*/\n\\1";
    private static final String CODE_MARK_VARIABLE_SUBST = "*/\n\\2";

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void setAsText(String string) {
        this.setValue(string);
    }

    private FormI18nString updateValue(FormI18nString formI18nString) {
        String string = formI18nString.getKey();
        formI18nString.setValue(formI18nString.getSupport().getResourceHolder().getValueForKey(string));
        return formI18nString;
    }

    @Override
    public String getAsText() {
        Object object = this.getValue();
        if (object instanceof String || object == null) {
            return (String)object;
        }
        FormI18nString formI18nString = (FormI18nString)((Object)object);
        return formI18nString.getValue();
    }

    @Override
    public String getJavaInitializationString() {
        int n;
        Object object = this.getValue();
        if (!(object instanceof FormI18nString)) {
            if (object != null) {
                return "\"" + FormI18nSupport.toAscii((String)object) + "\"";
            }
            return "null";
        }
        FormI18nString formI18nString = (FormI18nString)((Object)object);
        String string = formI18nString.getReplaceString();
        if (string == null) {
            return "\"" + FormI18nSupport.toAscii((String)formI18nString.getValue()) + "\"";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("*/\n\\1NOI18N");
        if (string.startsWith("java.util.ResourceBundle.getBundle(") && (n = string.lastIndexOf(").get") + 1) > 0) {
            stringBuilder.append(CODE_MARK_VARIABLE_SUBST);
            stringBuilder.append(string.substring(0, n));
            stringBuilder.append(CODE_MARK_VARIABLE_SUBST);
            stringBuilder.append("java.util.ResourceBundle");
            stringBuilder.append(CODE_MARK_VARIABLE_SUBST);
            stringBuilder.append(ATTR_BUNDLE);
            string = string.substring(n);
        }
        stringBuilder.append(CODE_MARK_END);
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Override
    public Component getCustomEditor() {
        FormI18nString formI18nString;
        Object object = this.getValue();
        if (object instanceof FormI18nString) {
            formI18nString = new FormI18nString((FormI18nString)((Object)object));
        } else {
            DataObject dataObject;
            formI18nString = this.createFormI18nString();
            if (object instanceof String) {
                formI18nString.setValue((String)object);
            }
            if ((dataObject = I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject)) != null) {
                FileObject fileObject = this.sourceDataObject.getPrimaryFile();
                FileObject fileObject2 = dataObject.getPrimaryFile();
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                if (classPath.contains(fileObject2)) {
                    formI18nString.getSupport().getResourceHolder().setResource(dataObject);
                }
            }
        }
        return new CustomEditor((I18nString)formI18nString, this.getProject(), this.sourceDataObject.getPrimaryFile());
    }

    private Project getProject() {
        return Util.getProjectFor((DataObject)this.sourceDataObject);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof String && this.getValue() instanceof FormI18nString) {
            FormI18nString formI18nString = new FormI18nString((FormI18nString)((Object)this.getValue()));
            formI18nString.setValue((String)object);
            object = formI18nString;
        }
        super.setValue(object);
    }

    private FormI18nString createFormI18nString() {
        return new FormI18nString((DataObject)this.sourceDataObject);
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        if (formModel != null) {
            this.sourceDataObject = FormEditorSupport.getFormDataObject((FormModel)formModel);
        }
    }

    public void updateFormVersionLevel() {
    }

    public String getDisplayName() {
        return NbBundle.getMessage(FormI18nStringEditor.class, (String)"CTL_PropertyEditorName");
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
    }

    public void readFromXML(Node node) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Node node2;
        FormI18nString formI18nString = this.createFormI18nString();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (XML_PLAINSTRING.equals(node.getNodeName())) {
            Node node3 = namedNodeMap.getNamedItem(ATTR_VALUE);
            if (node3 != null) {
                this.setValue(node3.getNodeValue());
            }
            return;
        }
        if (!XML_RESOURCESTRING.equals(node.getNodeName())) {
            throw new IOException();
        }
        try {
            String string;
            String string2;
            node2 = namedNodeMap.getNamedItem(ATTR_BUNDLE);
            object3 = node2 == null ? null : node2.getNodeValue();
            node2 = namedNodeMap.getNamedItem(ATTR_KEY);
            String string3 = string2 = node2 == null ? null : node2.getNodeValue();
            if (object3 != null) {
                string = null;
                object2 = this.sourceDataObject.getPrimaryFile();
                if (object2 != null && (object = Util.getResource((FileObject)object2, (String)object3)) != null) {
                    try {
                        string = DataObject.find((FileObject)object);
                        if (string.getClass().equals(formI18nString.getSupport().getResourceHolder().getResourceClasses()[0])) {
                            formI18nString.getSupport().getResourceHolder().setResource((DataObject)string);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    formI18nString.bundleName = object3;
                }
            }
            if (string2 != null && string2.length() > 0) {
                formI18nString.setKey(string2);
                formI18nString.setValue(formI18nString.getSupport().getResourceHolder().getValueForKey(string2));
                formI18nString.setComment(formI18nString.getSupport().getResourceHolder().getCommentForKey(string2));
            }
            ((JavaI18nSupport)formI18nString.getSupport()).createIdentifier();
            node2 = namedNodeMap.getNamedItem(ATTR_IDENTIFIER);
            if (node2 != null) {
                String string4 = string = node2 == null ? null : node2.getNodeValue();
                if (string != null) {
                    ((JavaI18nSupport)formI18nString.getSupport()).setIdentifier(string);
                }
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_REPLACE_FORMAT)) != null) {
                string = node2.getNodeValue();
                if (string != null && string.length() > 0) {
                    object2 = new HashMap(6);
                    object2.put("0", "{identifier}");
                    object2.put("1", "{key}");
                    object2.put("2", "{bundleNameSlashes}");
                    object2.put("3", "{bundleNameDots}");
                    object2.put("4", "{sourceFileName}");
                    object2.put("fileName", "{sourceFileName}");
                    object = MapFormat.format((String)string, (Map)object2);
                    formI18nString.setReplaceFormat((String)object);
                }
            } else {
                formI18nString.setReplaceFormat(I18nUtil.getDefaultReplaceFormat((boolean)false));
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
        if (node instanceof Element) {
            int n;
            Object object4;
            node2 = (Element)node;
            object3 = node2.getElementsByTagName(XML_ARGUMENT);
            int n2 = -1;
            for (int i = 0; i < object3.getLength(); ++i) {
                object2 = object3.item(i).getAttributes();
                object = object2.getNamedItem(ATTR_INDEX);
                Object object5 = object4 = object == null ? null : object.getNodeValue();
                if (object4 == null) continue;
                try {
                    int n3 = Integer.parseInt((String)object4);
                    if (n3 <= n2 || n3 >= 1000) continue;
                    n2 = n3;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String[] stringArray = new String[n2 + 1];
            for (n = 0; n < object3.getLength(); ++n) {
                String string;
                object = object3.item(n).getAttributes();
                object4 = object.getNamedItem(ATTR_INDEX);
                String string5 = string = object4 == null ? null : object4.getNodeValue();
                if (string == null) continue;
                try {
                    String string6;
                    int n4 = Integer.parseInt(string);
                    if (n4 >= 1000) continue;
                    Node node4 = object.getNamedItem(ATTR_JAVACODE);
                    stringArray[n4] = string6 = node4 == null ? null : node4.getNodeValue();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] != null) continue;
                stringArray[n] = "";
            }
            formI18nString.setArguments(stringArray);
        }
        this.setValue((Object)formI18nString);
    }

    public Node storeToXML(Document document) {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        Element element = document.createElement(XML_RESOURCESTRING);
        if (object instanceof FormI18nString) {
            String string;
            FormI18nString formI18nString = (FormI18nString)((Object)object);
            if (formI18nString.getSupport().getResourceHolder().getResource() == null) {
                string = formI18nString.bundleName;
            } else {
                string = Util.getResourceName((FileObject)formI18nString.getSupport().getSourceDataObject().getPrimaryFile(), (FileObject)formI18nString.getSupport().getResourceHolder().getResource().getPrimaryFile(), (char)'/', (boolean)true);
                if (string == null) {
                    string = "";
                }
            }
            element.setAttribute(ATTR_BUNDLE, string);
            element.setAttribute(ATTR_KEY, formI18nString.getKey() == null ? "" : formI18nString.getKey());
            JavaI18nSupport javaI18nSupport = (JavaI18nSupport)formI18nString.getSupport();
            if (javaI18nSupport.getIdentifier() == null) {
                javaI18nSupport.createIdentifier();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(1);
            hashMap.put(ATTR_IDENTIFIER, javaI18nSupport.getIdentifier());
            element.setAttribute(ATTR_REPLACE_FORMAT, formI18nString.getReplaceFormat() == null ? "" : MapFormat.format((String)formI18nString.getReplaceFormat(), hashMap));
            String[] stringArray = formI18nString.getArguments();
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = document.createElement(XML_ARGUMENT);
                element2.setAttribute(ATTR_INDEX, "" + i);
                element2.setAttribute(ATTR_JAVACODE, stringArray[i]);
                try {
                    element.appendChild(element2);
                    continue;
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
        } else {
            element = document.createElement(XML_PLAINSTRING);
            element.setAttribute(ATTR_VALUE, (String)object);
        }
        return element;
    }

    private class CustomEditor
    extends JPanel
    implements VetoableChangeListener {
        private I18nPanel i18nPanel;

        public CustomEditor(I18nString i18nString, Project project, FileObject fileObject) {
            this.i18nPanel = new I18nPanel(i18nString.getSupport().getPropertyPanel(), false, project, fileObject);
            this.setLayout(new BorderLayout());
            this.add((Component)this.i18nPanel);
            this.i18nPanel.setI18nString(i18nString);
            FormI18nStringEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            FormI18nStringEditor.this.env.addVetoableChangeListener((VetoableChangeListener)this);
            HelpCtx.setHelpIDString((JComponent)this, (String)"internation.formed");
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("state".equals(propertyChangeEvent.getPropertyName()) && this.isVisible()) {
                I18nString i18nString = this.i18nPanel.getI18nString();
                if (i18nString == null || !(i18nString instanceof FormI18nString) || i18nString.getSupport().getResourceHolder().getResource() == null || i18nString.getKey() == null) {
                    throw new PropertyVetoException(NbBundle.getMessage(FormI18nStringEditor.class, (String)"MSG_InvalidValue"), propertyChangeEvent);
                }
                FormI18nStringEditor.this.setValue(i18nString);
            }
        }
    }
}

