/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.toolsui;

import java.awt.Component;
import java.awt.Image;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.toolsui.DLightConfigurationUIWrapper;
import org.netbeans.modules.dlight.toolsui.DLightToolUIWrapper;
import org.openide.util.ImageUtilities;

public class ToolsTable
extends JTable {
    private final List<DLightToolUIWrapper> allDLightTools;
    private final DLightConfigurationUIWrapper dlightConfigurationUIWrapper;

    public ToolsTable(DLightConfigurationUIWrapper dlightConfigurationUIWrapper, List<DLightToolUIWrapper> allDLightTools, ListSelectionListener listSelectionListener) {
        this.allDLightTools = allDLightTools;
        this.dlightConfigurationUIWrapper = dlightConfigurationUIWrapper;
        if (this.getRowHeight() < 20) {
            this.setRowHeight(20);
        }
        this.setModel(new MyTableModel());
        this.getAccessibleContext().setAccessibleDescription("");
        this.getAccessibleContext().setAccessibleName("");
        this.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.getColumnModel().getColumn(0).setMaxWidth(30);
        this.setTableHeader(null);
        this.getSelectionModel().setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void initSelection() {
        int i = 0;
        for (DLightToolUIWrapper dlightTool : this.allDLightTools) {
            if (dlightTool.isEnabled()) {
                this.getSelectionModel().setSelectionInterval(i, i);
                return;
            }
            ++i;
        }
    }

    @Override
    public boolean getShowHorizontalLines() {
        return false;
    }

    @Override
    public boolean getShowVerticalLines() {
        return false;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new MyTableCellRenderer();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        if (col == 0) {
            DLightToolUIWrapper dlightTool = this.allDLightTools.get(row);
            JCheckBox checkBox = new JCheckBox();
            checkBox.setSelected(dlightTool.isEnabled());
            checkBox.setEnabled(dlightTool.canEnable());
            return new DefaultCellEditor(checkBox);
        }
        return super.getCellEditor(row, col);
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ToolsTable.this.allDLightTools.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return ToolsTable.this.allDLightTools.get(row);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                DLightToolUIWrapper dlightTool = (DLightToolUIWrapper)ToolsTable.this.allDLightTools.get(row);
                return dlightTool.canEnable();
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                DLightToolUIWrapper dlightTool = (DLightToolUIWrapper)ToolsTable.this.allDLightTools.get(row);
                ToolsTable.this.dlightConfigurationUIWrapper.setToolEnabled(dlightTool, !dlightTool.isEnabled());
            }
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        Image emptyImage = ImageUtilities.loadImage((String)"/org/openide/resources/actions/empty.gif");

        MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, color, isSelected, hasFocus, row, col);
            DLightToolUIWrapper dlightTool = (DLightToolUIWrapper)ToolsTable.this.allDLightTools.get(row);
            if (col == 0) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(dlightTool.isEnabled());
                checkBox.setBackground(label.getBackground());
                checkBox.setEnabled(dlightTool.canEnable());
                return checkBox;
            }
            label.setText(dlightTool.getDLightTool().getName());
            Image image = null;
            if (dlightTool.getDLightTool().hasIcon()) {
                image = ImageUtilities.loadImage((String)dlightTool.getDLightTool().getIconPath());
            }
            if (image == null) {
                image = this.emptyImage;
            }
            label.setIcon(ImageUtilities.image2Icon((Image)image));
            label.setToolTipText(null);
            return label;
        }
    }
}

