/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.TextLayoutView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public class FoldView
extends EditorView
implements TextLayoutView {
    private static final Logger LOG = Logger.getLogger(FoldView.class.getName());
    private int rawOffset;
    private int length;
    private final JTextComponent textComponent;
    private final Fold fold;

    public FoldView(JTextComponent textComponent, Fold fold) {
        super(null);
        int offset = fold.getStartOffset();
        int len = fold.getEndOffset() - offset;
        assert (len > 0) : "length=" + len + " <= 0";
        this.rawOffset = offset;
        this.length = len;
        this.textComponent = textComponent;
        this.fold = fold;
    }

    public float getPreferredSpan(int axis) {
        TextLayout textLayout = this.getTextLayout();
        if (textLayout == null) {
            return 0.0f;
        }
        float span = axis == 0 ? textLayout.getAdvance() : textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        return span;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean setLength(int length) {
        return false;
    }

    public int getStartOffset() {
        EditorView.Parent parent = (EditorView.Parent)this.getParent();
        return parent != null ? parent.getViewOffset(this.rawOffset) : this.rawOffset;
    }

    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    public Document getDocument() {
        View parent = this.getParent();
        return parent != null ? parent.getDocument() : null;
    }

    public AttributeSet getAttributes() {
        return null;
    }

    public TextLayout createTextLayout() {
        EditorView.Parent parent = (EditorView.Parent)this.getParent();
        FontRenderContext frc = parent.getFontRenderContext();
        if (frc == null) {
            return null;
        }
        Font font = this.textComponent.getFont();
        String text = this.fold.getDescription();
        TextLayout textLayout = new TextLayout(text, font, frc);
        return textLayout;
    }

    private TextLayout getTextLayout() {
        EditorView.Parent parent = (EditorView.Parent)this.getParent();
        return parent != null ? parent.getTextLayout((TextLayoutView)this) : null;
    }

    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        TextLayout textLayout = this.getTextLayout();
        if (textLayout == null) {
            return alloc;
        }
        TextHitInfo hit = TextHitInfo.afterOffset(0);
        Rectangle2D.Double bounds = ViewUtils.shape2Bounds((Shape)alloc);
        return bounds;
    }

    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        int startOffset = this.getStartOffset();
        return startOffset;
    }

    static TextHitInfo x2RelOffset(TextLayout textLayout, float x) {
        TextHitInfo hit = x >= textLayout.getAdvance() ? TextHitInfo.trailing(textLayout.getCharacterCount()) : textLayout.hitTestChar(x, 0.0f);
        return hit;
    }

    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        int startOffset = this.getStartOffset();
        switch (direction) {
            case 1: 
            case 7: {
                if (offset == -1) {
                    offset = Math.max(0, startOffset + this.fold.getDescription().length() - 1);
                    break;
                }
                if (this.fold.isCollapsed()) {
                    offset = this.getStartOffset();
                    break;
                }
                --offset;
                break;
            }
            case 3: 
            case 5: {
                if (offset == -1) {
                    offset = startOffset;
                    break;
                }
                Document doc = this.getDocument();
                if (doc == null) break;
                if (this.fold.isCollapsed()) {
                    offset = this.getEndOffset();
                    break;
                }
                ++offset;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds((Shape)alloc);
        if (allocBounds.intersects(clipBounds)) {
            Font origFont = g.getFont();
            Color origColor = g.getColor();
            try {
                g.setColor(this.textComponent.getForeground());
                int xInt = (int)allocBounds.getX();
                int yInt = (int)allocBounds.getY();
                int endXInt = (int)(allocBounds.getX() + allocBounds.getWidth() - 1.0);
                int endYInt = (int)(allocBounds.getY() + allocBounds.getHeight() - 1.0);
                g.drawRect(xInt, yInt, endXInt - xInt, endYInt - yInt);
                TextLayout textLayout = this.getTextLayout();
                if (textLayout != null) {
                    float x = (float)allocBounds.getX();
                    float y = (float)allocBounds.getY();
                    textLayout.draw(g, x, y + textLayout.getAscent());
                }
            }
            finally {
                g.setColor(origColor);
                g.setFont(origFont);
            }
        }
    }

    protected String getDumpName() {
        return "FV";
    }

    public String toString() {
        return this.appendViewInfo(new StringBuilder(200), 0, -1).toString();
    }
}

