/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.ruby;

import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.ruby.lexer.RubyCommentTokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.spellchecker.bindings.ruby.AbstractRubyTokenList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyTokenList
extends AbstractRubyTokenList {
    private boolean hidden = false;

    public RubyTokenList(BaseDocument doc) {
        super(doc);
    }

    @Override
    public void setStartOffset(int offset) {
        super.setStartOffset(offset);
        FileObject fileObject = FileUtil.getConfigFile((String)"Spellcheckers/Ruby");
        Boolean b = (Boolean)fileObject.getAttribute("Hidden");
        this.hidden = Boolean.TRUE.equals(b);
    }

    @Override
    protected int[] findNextSpellSpan(TokenSequence<? extends TokenId> ts, int offset) throws BadLocationException {
        if (ts == null || this.hidden) {
            return new int[]{-1, -1};
        }
        int diff = ts.move(offset);
        while (ts.moveNext()) {
            TokenId id = ts.token().id();
            if (id != RubyTokenId.LINE_COMMENT && id != RubyTokenId.DOCUMENTATION || this.isPreformatted(ts.offset(), id != RubyTokenId.DOCUMENTATION)) continue;
            TokenSequence t = ts.embedded(RubyCommentTokenId.language());
            if (t == null) {
                return new int[]{ts.offset(), ts.offset() + ts.token().length()};
            }
            t.move(offset);
            while (t.moveNext()) {
                id = t.token().id();
                if (id != RubyCommentTokenId.COMMENT_TEXT && id != RubyCommentTokenId.COMMENT_BOLD && id != RubyCommentTokenId.COMMENT_ITALIC || this.isPreformatted(t.offset(), id != RubyTokenId.DOCUMENTATION)) continue;
                return new int[]{t.offset(), t.offset() + t.token().length()};
            }
        }
        return new int[]{-1, -1};
    }

    private boolean isPreformatted(int offset, boolean isComment) throws BadLocationException {
        int lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)offset);
        if (lineBegin == -1) {
            return false;
        }
        String line = this.doc.getText(lineBegin, Math.min(Utilities.getRowEnd((BaseDocument)this.doc, (int)offset), lineBegin + 5) - lineBegin);
        return isComment ? line.startsWith("#  ") : line.startsWith("  ");
    }
}

