/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Lookup;

public final class RemoteSyncSupport {
    private RemoteSyncSupport() {
    }

    public static RemoteSyncWorker createSyncWorker(Project project, PrintWriter out, PrintWriter err) {
        RemoteSyncFactory syncFactory;
        ServerRecord serverRecord = ServerList.get(project);
        if (serverRecord != null && (syncFactory = serverRecord.getSyncFactory()) != null) {
            return syncFactory.createNew(project, out, err);
        }
        return null;
    }

    public static RemoteSyncWorker createSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter out, PrintWriter err, File privProjectStorageDir, File ... localDirs) {
        RemoteSyncFactory syncFactory;
        ServerRecord serverRecord = ServerList.get(executionEnvironment);
        if (serverRecord != null && (syncFactory = serverRecord.getSyncFactory()) != null) {
            return syncFactory.createNew(executionEnvironment, out, err, privProjectStorageDir, localDirs);
        }
        return null;
    }

    public static Worker createUploader(Project project, ExecutionEnvironment execEnv) {
        RemoteSyncService rss = (RemoteSyncService)Lookup.getDefault().lookup(RemoteSyncService.class);
        return rss == null ? null : rss.getUploader(project, execEnv);
    }

    public static interface Worker {
        public void process(File var1, Writer var2) throws PathMapperException, InterruptedException, ExecutionException, IOException;

        public void close();
    }

    public static class PathMapperException
    extends Exception {
        private final File file;

        public PathMapperException(File file) {
            super("Could not find remote path for " + file.getAbsolutePath());
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

