/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.lexer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.indent.PHPBracketCompleter;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class LexUtilities {
    private static final Set<PHPTokenId> INDENT_BEGIN_TOKENS = new HashSet<PHPTokenId>();
    private static final Set<PHPTokenId> INDENT_END_TOKENS = new HashSet<PHPTokenId>();

    private LexUtilities() {
    }

    public static TokenSequence<? extends TokenId> getMostEmbeddedTokenSequence(final Document doc, final int offset, boolean runUnderLock) {
        final AtomicReference ref = new AtomicReference();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                List sequences = th.embeddedTokenSequences(offset, false);
                if (sequences.isEmpty()) {
                    ref.set(th.tokenSequence());
                } else {
                    ref.set(sequences.get(sequences.size() - 1));
                }
            }
        };
        if (runUnderLock) {
            doc.render(r);
        } else {
            r.run();
        }
        return (TokenSequence)ref.get();
    }

    @CheckForNull
    public static TokenSequence<PHPTokenId> getPHPTokenSequence(Document doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        return LexUtilities.getPHPTokenSequence(th, offset);
    }

    public static TokenSequence<PHPTokenId> getPHPTokenSequence(TokenHierarchy<?> th, int offset) {
        TokenSequence ts;
        TokenSequence tokenSequence = ts = th == null ? null : th.tokenSequence(PHPTokenId.language());
        if (ts == null) {
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() != PHPTokenId.language()) continue;
                ts = t;
                break;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() != PHPTokenId.language()) continue;
                    ts = t;
                    break;
                }
            }
        }
        return ts;
    }

    public static TokenSequence<? extends PHPTokenId> getPositionedSequence(BaseDocument doc, int offset) {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts != null) {
            try {
                ts.move(offset);
            }
            catch (AssertionError e) {
                DataObject dobj = (DataObject)doc.getProperty((Object)"stream");
                if (dobj != null) {
                    Exceptions.attachMessage((Throwable)((Object)e), (String)FileUtil.getFileDisplayName((FileObject)dobj.getPrimaryFile()));
                }
                throw e;
            }
            if (!ts.moveNext() && !ts.movePrevious()) {
                return null;
            }
            return ts;
        }
        return null;
    }

    public static Token<? extends PHPTokenId> getToken(BaseDocument doc, int offset) {
        TokenSequence<? extends PHPTokenId> ts = LexUtilities.getPositionedSequence(doc, offset);
        if (ts != null) {
            return ts.token();
        }
        return null;
    }

    public static char getTokenChar(BaseDocument doc, int offset) {
        Token<? extends PHPTokenId> token = LexUtilities.getToken(doc, offset);
        if (token != null && token.text().length() > 0) {
            return token.text().charAt(0);
        }
        return '\u0000';
    }

    public static OffsetRange findFwd(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts, PHPTokenId tokenUpId, char up, PHPTokenId tokenDownId, char down) {
        int balance = 0;
        while (ts.moveNext()) {
            Token token = ts.token();
            if (token.id() == tokenUpId && LexUtilities.textEquals(token.text(), up)) {
                ++balance;
                continue;
            }
            if (token.id() != tokenDownId || !LexUtilities.textEquals(token.text(), down)) continue;
            if (balance == 0) {
                return new OffsetRange(ts.offset(), ts.offset() + token.length());
            }
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts, PHPTokenId tokenUpId, char up, PHPTokenId tokenDownId, char down) {
        int balance = 0;
        while (ts.movePrevious()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (token.id() == tokenUpId && LexUtilities.textEquals(token.text(), up)) {
                if (balance == 0) {
                    return new OffsetRange(ts.offset(), ts.offset() + token.length());
                }
                ++balance;
                continue;
            }
            if (token.id() != tokenDownId || !LexUtilities.textEquals(token.text(), down)) continue;
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBegin(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts) {
        return OffsetRange.NONE;
    }

    public static boolean isIndentBeginToken(PHPTokenId id) {
        return INDENT_BEGIN_TOKENS.contains((Object)id);
    }

    public static boolean isIndentEndToken(PHPTokenId id) {
        return INDENT_END_TOKENS.contains((Object)id);
    }

    public static int getBeginEndLineBalance(BaseDocument doc, int offset, boolean upToOffset) {
        return 0;
    }

    public static int getLineBalance(BaseDocument doc, int offset, TokenId up, TokenId down, PHPBracketCompleter.LineBalance lineBalance) {
        try {
            int begin = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            int end = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, begin);
            if (ts == null) {
                return 0;
            }
            ts.move(begin);
            if (!ts.moveNext()) {
                return 0;
            }
            int upCount = 0;
            int downCount = 0;
            do {
                Token token;
                TokenId id;
                if ((id = (token = ts.token()).id()) == up) {
                    if (lineBalance.equals((Object)PHPBracketCompleter.LineBalance.DOWN_FIRST)) {
                        if (upCount <= 0) continue;
                        ++upCount;
                        continue;
                    }
                    ++upCount;
                    continue;
                }
                if (id != down) continue;
                if (lineBalance.equals((Object)PHPBracketCompleter.LineBalance.UP_FIRST)) {
                    if (upCount <= 0) continue;
                    ++downCount;
                    continue;
                }
                ++downCount;
            } while (ts.moveNext() && ts.offset() <= end);
            return upCount - downCount;
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
            return 0;
        }
    }

    public static int getTokenBalance(BaseDocument doc, char open, char close, int offset) throws BadLocationException {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, 0);
        if (ts == null) {
            return 0;
        }
        ts.moveIndex(0);
        if (!ts.moveNext()) {
            return 0;
        }
        int balance = 0;
        do {
            Token t = ts.token();
            if (LexUtilities.textEquals(t.text(), open)) {
                ++balance;
                continue;
            }
            if (!LexUtilities.textEquals(t.text(), close)) continue;
            --balance;
        } while (ts.moveNext());
        return balance;
    }

    public static boolean isCommentOnlyLine(BaseDocument doc, int offset) throws BadLocationException {
        int begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (begin == -1) {
            return false;
        }
        Token<? extends PHPTokenId> token = LexUtilities.getToken(doc, begin);
        if (token != null) {
            return token.id() == PHPTokenId.PHP_LINE_COMMENT;
        }
        return false;
    }

    public static boolean textEquals(CharSequence text1, char ... text2) {
        int len = text1.length();
        if (len == text2.length) {
            for (int i = len - 1; i >= 0; --i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Token<? extends PHPTokenId> findNext(TokenSequence<? extends PHPTokenId> ts, List<PHPTokenId> ignores) {
        if (ignores.contains(ts.token().id())) {
            while (ts.moveNext() && ignores.contains(ts.token().id())) {
            }
        }
        return ts.token();
    }

    public static Token<? extends PHPTokenId> findPrevious(TokenSequence<? extends PHPTokenId> ts, List<PHPTokenId> ignores) {
        if (ignores.contains(ts.token().id())) {
            while (ts.movePrevious() && ignores.contains(ts.token().id())) {
            }
        }
        return ts.token();
    }

    public static Token<? extends PHPTokenId> findNextToken(TokenSequence<? extends PHPTokenId> ts, List<PHPTokenId> lookfor) {
        if (!lookfor.contains(ts.token().id())) {
            while (ts.moveNext() && !lookfor.contains(ts.token().id())) {
            }
        }
        return ts.token();
    }

    public static Token<? extends PHPTokenId> findPreviousToken(TokenSequence<? extends PHPTokenId> ts, List<PHPTokenId> lookfor) {
        if (!lookfor.contains(ts.token().id())) {
            while (ts.movePrevious() && !lookfor.contains(ts.token().id())) {
            }
        }
        return ts.token();
    }

    public static Token<? extends PHPTokenId> findEndOfLine(TokenSequence<? extends PHPTokenId> ts) {
        do {
            Token<? extends PHPTokenId> token = LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_LINE_COMMENT));
            for (int i = token.text().length() - 1; i > -1; --i) {
                if (token.text().charAt(i) != '\n') continue;
                return token;
            }
        } while (ts.moveNext());
        return ts.token();
    }
}

