/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocStaticAccessType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;

public class PHPDocCommentParser {
    private static Pattern pattern = Pattern.compile("[\r\n][ \\t]*[*]?[ \\t]*");
    private static final List<PHPDocTag.Type> PHPDocTypeTags = new ArrayList<PHPDocTag.Type>();
    private static final List<PHPDocTag.Type> PHPDocVarTypeTags;

    public PHPDocBlock parse(int startOffset, int endOffset, String comment) {
        PHPDocTag tag;
        PHPDocTag.Type tagType;
        assert (startOffset <= endOffset);
        ArrayList<PHPDocTag> tags = new ArrayList<PHPDocTag>();
        String blockDescription = "";
        if (comment == null || comment.length() == 0) {
            return new PHPDocBlock(startOffset, endOffset, blockDescription, tags);
        }
        Matcher matcher = pattern.matcher(comment);
        int index = 0;
        String line = "";
        String description = "";
        PHPDocTag.Type lastTag = null;
        int lastStartIndex = 0;
        int lastEndIndex = comment.length();
        while (matcher.find()) {
            line = comment.substring(index, matcher.start()).trim();
            if (index == 0) {
                line = this.removeStarAndTrim(line);
            }
            if ((tagType = this.findTagOnLine(line)) != null) {
                if (lastTag == null) {
                    blockDescription = description.trim();
                } else {
                    tag = this.createTag(startOffset + 3 + lastStartIndex, startOffset + 3 + lastEndIndex, lastTag, description.trim(), comment, startOffset + 3);
                    if (tag != null) {
                        tags.add(tag);
                    }
                }
                lastTag = tagType;
                lastStartIndex = index;
                description = "";
                line = line.substring(tagType.name().length() + 1).trim();
            }
            index = matcher.end();
            lastEndIndex = matcher.start();
            description = description + line + "\n";
        }
        line = index == 0 ? this.removeStarAndTrim(comment) : comment.substring(index, comment.length()).trim();
        tagType = this.findTagOnLine(line);
        if (tagType != null) {
            if (lastTag == null) {
                blockDescription = description.trim();
            } else {
                tag = this.createTag(startOffset + 3 + lastStartIndex, startOffset + 3 + lastEndIndex, lastTag, description.trim(), comment, startOffset + 3);
                if (tag != null) {
                    tags.add(tag);
                }
            }
            line = line.substring(tagType.name().length() + 1).trim();
            tag = this.createTag(startOffset + 3 + index, startOffset + 3 + comment.length(), tagType, line, comment, startOffset + 3);
            if (tag != null) {
                tags.add(tag);
            }
        } else if (lastTag == null) {
            blockDescription = description + line;
        } else {
            tag = this.createTag(startOffset + 3 + lastStartIndex, startOffset + 3 + lastEndIndex, lastTag, description = description + line, comment, startOffset + 3);
            if (tag != null) {
                tags.add(tag);
            }
        }
        return new PHPDocBlock(Math.min(startOffset + 3, endOffset), endOffset, blockDescription, tags);
    }

    private PHPDocTag createTag(int start, int end, PHPDocTag.Type type, String description, String originalComment, int originalCommentStart) {
        ArrayList<PHPDocNode> docTypes = new ArrayList<PHPDocNode>();
        if (PHPDocTypeTags.contains((Object)type) || PHPDocVarTypeTags.contains((Object)type)) {
            for (String stype : this.getTypes(description)) {
                PHPDocNode docType;
                stype = this.removeHTMLTags(stype);
                int startDocNode = this.findStartOfDocNode(originalComment, originalCommentStart, stype, start);
                int index = stype.indexOf("::");
                if (index == -1) {
                    docType = new PHPDocNode(startDocNode, startDocNode + stype.length(), stype);
                } else {
                    String className = stype.substring(0, index);
                    String constantName = stype.substring(index + 2, stype.length());
                    PHPDocNode classNameNode = new PHPDocNode(startDocNode, startDocNode + className.length(), className);
                    PHPDocNode constantNode = new PHPDocNode(startDocNode + className.length() + 2, startDocNode + stype.length(), constantName);
                    docType = new PHPDocStaticAccessType(startDocNode, startDocNode + stype.length(), stype, classNameNode, constantNode);
                }
                docTypes.add(docType);
            }
            if (PHPDocVarTypeTags.contains((Object)type)) {
                String variable = this.getVaribleName(description);
                if (variable != null) {
                    int startOfVariable = this.findStartOfDocNode(originalComment, originalCommentStart, variable, start);
                    PHPDocNode varibaleNode = new PHPDocNode(startOfVariable, startOfVariable + variable.length(), variable);
                    return new PHPDocVarTypeTag(start, end, type, description, docTypes, varibaleNode);
                }
                return null;
            }
            return new PHPDocTypeTag(start, end, type, description, docTypes);
        }
        return new PHPDocTag(start, end, type, description);
    }

    private List<String> getTypes(String description) {
        String[] tokens = description.split("[ ]+");
        ArrayList<String> types = new ArrayList<String>();
        if (tokens.length > 0) {
            if (tokens[0].indexOf(124) > -1) {
                String[] ttokens;
                for (String ttoken : ttokens = tokens[0].split("[|]")) {
                    types.add(ttoken.trim());
                }
            } else {
                types.add(tokens[0].trim());
            }
        }
        return types;
    }

    private String getVaribleName(String description) {
        String[] tokens = description.split("[ ]+");
        String variable = null;
        if (tokens.length > 0 && tokens[0].length() > 0 && tokens[0].charAt(0) == '$') {
            variable = tokens[0].trim();
        } else if (tokens.length > 1 && tokens[1].charAt(0) == '$') {
            variable = tokens[1].trim();
        }
        return variable;
    }

    private String removeHTMLTags(String text) {
        String value = text;
        int index = value.indexOf(62);
        if (index > -1 && (index = (value = value.substring(index + 1)).indexOf(60)) > -1) {
            value = value.substring(0, index);
        }
        return value;
    }

    private int findStartOfDocNode(String originalComment, int originalStart, String what, int from) {
        int pos = originalComment.indexOf(what, from - originalStart);
        return originalStart + pos;
    }

    private String removeStarAndTrim(String text) {
        if ((text = text.trim()).length() > 0 && text.charAt(0) == '*') {
            text = text.substring(1).trim();
        }
        return text;
    }

    private PHPDocTag.Type findTagOnLine(String line) {
        String[] tokens;
        PHPDocTag.Type type = null;
        if (line.length() > 0 && line.charAt(0) == '@' && (tokens = line.split("[ ]+")).length > 0) {
            String tag = tokens[0].substring(1).toUpperCase();
            if (tag.indexOf(45) > -1) {
                tag = tag.replace('-', '_');
            }
            try {
                type = PHPDocTag.Type.valueOf(tag);
            }
            catch (IllegalArgumentException iae) {
                type = null;
            }
        }
        return type;
    }

    static {
        PHPDocTypeTags.add(PHPDocTag.Type.RETURN);
        PHPDocTypeTags.add(PHPDocTag.Type.THROWS);
        PHPDocTypeTags.add(PHPDocTag.Type.VAR);
        PHPDocTypeTags.add(PHPDocTag.Type.SEE);
        PHPDocVarTypeTags = new ArrayList<PHPDocTag.Type>();
        PHPDocVarTypeTags.add(PHPDocTag.Type.PARAM);
        PHPDocVarTypeTags.add(PHPDocTag.Type.PROPERTY);
        PHPDocVarTypeTags.add(PHPDocTag.Type.GLOBAL);
        PHPDocVarTypeTags.add(PHPDocTag.Type.PROPERTY_READ);
        PHPDocVarTypeTags.add(PHPDocTag.Type.PROPERTY_WRITE);
    }
}

