/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class J2SEPlatformCustomizer
extends JTabbedPane {
    private static final int CLASSPATH = 0;
    private static final int SOURCES = 1;
    private static final int JAVADOC = 2;
    private J2SEPlatformImpl platform;

    public J2SEPlatformCustomizer(J2SEPlatformImpl platform) {
        this.platform = platform;
        this.initComponents();
    }

    private void initComponents() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AN_J2SEPlatformCustomizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_J2SEPlatformCustomizer"));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Classes"), this.createPathTab(0));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Sources"), this.createPathTab(1));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Javadoc"), this.createPathTab(2));
    }

    private JComponent createPathTab(int type) {
        return new PathView(this.platform, type);
    }

    private static class ArchiveFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public ArchiveFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            if (!this.extensions.contains(extension)) {
                return false;
            }
            try {
                return FileUtil.isArchiveFile((URL)f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                Exceptions.printStackTrace((Throwable)e);
                return false;
            }
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private static class PathModel
    extends AbstractListModel {
        private J2SEPlatformImpl platform;
        private int type;
        private List<URL> data;

        public PathModel(J2SEPlatformImpl platform, int type) {
            this.platform = platform;
            this.type = type;
        }

        @Override
        public int getSize() {
            return this.getData().size();
        }

        @Override
        public Object getElementAt(int index) {
            List<URL> list = this.getData();
            URL url = list.get(index);
            if ("jar".equals(url.getProtocol())) {
                URL fileURL = FileUtil.getArchiveFile((URL)url);
                if (FileUtil.getArchiveRoot((URL)fileURL).equals(url)) {
                    url = fileURL;
                } else {
                    return url.toExternalForm();
                }
            }
            if ("file".equals(url.getProtocol())) {
                File f = new File(URI.create(url.toExternalForm()));
                return f.getAbsolutePath();
            }
            return url.toExternalForm();
        }

        private void removePath(int[] indices) {
            List<URL> data = this.getData();
            for (int i = indices.length - 1; i >= 0; --i) {
                data.remove(indices[i]);
            }
            this.updatePlatform();
            this.fireIntervalRemoved(this, indices[0], indices[indices.length - 1]);
        }

        private void moveUpPath(int[] indices) {
            List<URL> data = this.getData();
            for (int i = 0; i < indices.length; ++i) {
                URL p2 = data.get(indices[i]);
                URL p1 = data.set(indices[i] - 1, p2);
                data.set(indices[i], p1);
            }
            this.updatePlatform();
            this.fireContentsChanged(this, indices[0] - 1, indices[indices.length - 1]);
        }

        private void moveDownPath(int[] indices) {
            List<URL> data = this.getData();
            for (int i = indices.length - 1; i >= 0; --i) {
                URL p1 = data.get(indices[i]);
                URL p2 = data.set(indices[i] + 1, p1);
                data.set(indices[i], p2);
            }
            this.updatePlatform();
            this.fireContentsChanged(this, indices[0], indices[indices.length - 1] + 1);
        }

        private boolean addPath(File f) {
            try {
                URL url = f.toURI().toURL();
                return this.addPath(url);
            }
            catch (MalformedURLException mue) {
                return false;
            }
        }

        private boolean addPath(URL url) {
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            } else if (!url.toExternalForm().endsWith("/")) {
                try {
                    url = new URL(url.toExternalForm() + "/");
                }
                catch (MalformedURLException mue) {
                    Exceptions.printStackTrace((Throwable)mue);
                }
            }
            List<URL> data = this.getData();
            int oldSize = data.size();
            data.add(url);
            this.updatePlatform();
            this.fireIntervalAdded(this, oldSize, oldSize);
            return true;
        }

        private synchronized List<URL> getData() {
            if (this.data == null) {
                switch (this.type) {
                    case 0: {
                        this.data = PathModel.getPathList(this.platform.getBootstrapLibraries());
                        break;
                    }
                    case 1: {
                        this.data = PathModel.getPathList(this.platform.getSourceFolders());
                        break;
                    }
                    case 2: {
                        this.data = new ArrayList<URL>(this.platform.getJavadocFolders());
                    }
                }
            }
            return this.data;
        }

        private static List<URL> getPathList(ClassPath cp) {
            ArrayList<URL> result = new ArrayList<URL>();
            for (ClassPath.Entry entry : cp.entries()) {
                result.add(entry.getURL());
            }
            return result;
        }

        private static ClassPath createClassPath(List<URL> roots) {
            ArrayList<PathResourceImplementation> resources = new ArrayList<PathResourceImplementation>();
            for (URL url : roots) {
                resources.add(ClassPathSupport.createResource((URL)url));
            }
            return ClassPathSupport.createClassPath(resources);
        }

        private void updatePlatform() {
            switch (this.type) {
                case 1: {
                    this.platform.setSourceFolders(PathModel.createClassPath(this.data));
                    break;
                }
                case 2: {
                    this.platform.setJavadocFolders(this.data);
                    break;
                }
                default: {
                    assert (false) : "Trying to update unknown property";
                    break;
                }
            }
        }
    }

    private static class PathView
    extends JPanel {
        private JList resources;
        private JButton addButton;
        private JButton removeButton;
        private JButton moveUpButton;
        private JButton moveDownButton;
        private int type;
        private File currentDir;

        public PathView(J2SEPlatformImpl platform, int type) {
            this.type = type;
            this.initComponents(platform);
        }

        private void initComponents(J2SEPlatformImpl platform) {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            String key = null;
            String mneKey = null;
            String ad = null;
            switch (this.type) {
                case 0: {
                    key = "TXT_JDKClasspath";
                    mneKey = "MNE_JDKClasspath";
                    ad = "AD_JDKClasspath";
                    break;
                }
                case 1: {
                    key = "TXT_JDKSources";
                    mneKey = "MNE_JDKSources";
                    ad = "AD_JDKSources";
                    break;
                }
                case 2: {
                    key = "TXT_JDKJavadoc";
                    mneKey = "MNE_JDKJavadoc";
                    ad = "AD_JDKJavadoc";
                    break;
                }
                default: {
                    assert (false) : "Illegal type of panel";
                    return;
                }
            }
            label.setText(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)key));
            label.setDisplayedMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)mneKey).charAt(0));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.insets = new Insets(6, 6, 2, 6);
            c.fill = 2;
            c.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(label, c);
            this.add(label);
            this.resources = new JList(new PathModel(platform, this.type));
            label.setLabelFor(this.resources);
            this.resources.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)ad));
            this.resources.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    PathView.this.selectionChanged();
                }
            });
            JScrollPane spane = new JScrollPane(this.resources);
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 1;
            c.gridheight = 5;
            c.insets = new Insets(0, 6, 6, 6);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(spane, c);
            this.add(spane);
            if (this.type == 1 || this.type == 2) {
                char mne;
                String text;
                this.addButton = new JButton();
                if (this.type == 1) {
                    text = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Add");
                    mne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Add").charAt(0);
                    ad = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Add");
                } else {
                    text = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddZip");
                    mne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_AddZip").charAt(0);
                    ad = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_AddZip");
                }
                this.addButton.setText(text);
                this.addButton.setMnemonic(mne);
                this.addButton.getAccessibleContext().setAccessibleDescription(ad);
                this.addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathView.this.addPathElement();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 1;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(0, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.addButton, c);
                this.add(this.addButton);
                this.removeButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Remove"));
                this.removeButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Remove").charAt(0));
                this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Remove"));
                this.removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathView.this.removePathElement();
                    }
                });
                this.removeButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 3;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.removeButton, c);
                this.add(this.removeButton);
                this.moveUpButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Up"));
                this.moveUpButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Up").charAt(0));
                this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Up"));
                this.moveUpButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathView.this.moveUpPathElement();
                    }
                });
                this.moveUpButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 4;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveUpButton, c);
                this.add(this.moveUpButton);
                this.moveDownButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Down"));
                this.moveDownButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Down").charAt(0));
                this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Down"));
                this.moveDownButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathView.this.moveDownPathElement();
                    }
                });
                this.moveDownButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 5;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(5, 6, 6, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveDownButton, c);
                this.add(this.moveDownButton);
            }
        }

        private void addPathElement() {
            JFileChooser chooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setMultiSelectionEnabled(true);
            String title = null;
            String message = null;
            String approveButtonName = null;
            String approveButtonNameMne = null;
            if (this.type == 1) {
                title = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenSources");
                message = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Sources");
                approveButtonName = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenSources");
                approveButtonNameMne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_OpenSources");
            } else if (this.type == 2) {
                title = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenJavadoc");
                message = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Javadoc");
                approveButtonName = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenJavadoc");
                approveButtonNameMne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_OpenJavadoc");
            }
            chooser.setDialogTitle(title);
            chooser.setApproveButtonText(approveButtonName);
            chooser.setApproveButtonMnemonic(approveButtonNameMne.charAt(0));
            chooser.setFileSelectionMode(2);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new ArchiveFileFilter(message, new String[]{"ZIP", "JAR"}));
            if (this.currentDir != null) {
                chooser.setCurrentDirectory(this.currentDir);
            }
            if (chooser.showOpenDialog(this) == 0) {
                int lastIndex;
                File[] fs = chooser.getSelectedFiles();
                PathModel model = (PathModel)this.resources.getModel();
                boolean addingFailed = false;
                int firstIndex = this.resources.getModel().getSize();
                for (int i = 0; i < fs.length; ++i) {
                    File parent;
                    File f = fs[i];
                    if (!f.exists() && (parent = f.getParentFile()) != null && f.getName().equals(parent.getName()) && parent.exists()) {
                        f = parent;
                    }
                    addingFailed |= !model.addPath(f);
                }
                if (addingFailed) {
                    new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_CanNotAddResolve"), 0);
                }
                if (firstIndex <= (lastIndex = this.resources.getModel().getSize() - 1)) {
                    int[] toSelect = new int[lastIndex - firstIndex + 1];
                    for (int i = 0; i < toSelect.length; ++i) {
                        toSelect[i] = firstIndex + i;
                    }
                    this.resources.setSelectedIndices(toSelect);
                }
                this.currentDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
            }
        }

        private void removePathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.removePath(indices);
            if (indices[indices.length - 1] - indices.length + 1 < this.resources.getModel().getSize()) {
                this.resources.setSelectedIndex(indices[indices.length - 1] - indices.length + 1);
            } else if (indices[0] > 0) {
                this.resources.setSelectedIndex(indices[0] - 1);
            }
        }

        private void moveDownPathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.moveDownPath(indices);
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = indices[i] + 1;
            }
            this.resources.setSelectedIndices(indices);
        }

        private void moveUpPathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.moveUpPath(indices);
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = indices[i] - 1;
            }
            this.resources.setSelectedIndices(indices);
        }

        private void selectionChanged() {
            if (this.type == 0) {
                return;
            }
            int[] indices = this.resources.getSelectedIndices();
            this.removeButton.setEnabled(indices.length > 0);
            this.moveUpButton.setEnabled(indices.length > 0 && indices[0] > 0);
            this.moveDownButton.setEnabled(indices.length > 0 && indices[indices.length - 1] < this.resources.getModel().getSize() - 1);
        }
    }
}

