/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.game.GameAccessController;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.EditorManagerListener;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GameBuilderNavigator
extends JPanel
implements NavigatorPanel,
EditorManagerListener {
    private static final boolean DEBUG = false;
    private GlobalRepository gameDesign;
    private ADSL listener;

    public GameBuilderNavigator() {
        this.setNavigator(null);
        this.listener = new ADSL();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(GameBuilderNavigator.class, (String)"GameBuilderNavigator.DisplayName");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(GameBuilderNavigator.class, (String)"GameBuilderNavigator.DisplayHint");
    }

    public JComponent getComponent() {
        return this;
    }

    public void panelActivated(Lookup lookup) {
        ActiveDocumentSupport.getDefault().addActiveDocumentListener((ActiveDocumentSupport.Listener)this.listener);
        final JComponent[] jComponentArray = new JComponent[]{null};
        final DesignDocument designDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (designDocument == null) {
            return;
        }
        designDocument.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                GameAccessController gameAccessController = (GameAccessController)designDocument.getListenerManager().getAccessController(GameAccessController.class);
                if (gameAccessController == null) {
                    return;
                }
                GameBuilderNavigator.this.gameDesign = gameAccessController.getGameDesign();
                GameBuilderNavigator.this.gameDesign.getMainView().addEditorManagerListener(GameBuilderNavigator.this);
                Editable editable = GameBuilderNavigator.this.gameDesign.getMainView().getCurrentEditable();
                if (editable == null) {
                    return;
                }
                jComponentArray[0] = editable.getNavigator();
            }
        });
        this.setNavigator(jComponentArray[0]);
    }

    public void panelDeactivated() {
        ActiveDocumentSupport.getDefault().removeActiveDocumentListener((ActiveDocumentSupport.Listener)this.listener);
    }

    public Lookup getLookup() {
        return null;
    }

    private void setNavigator(JComponent jComponent) {
        this.removeAll();
        if (jComponent != null) {
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(jComponent), "Center");
        } else {
            this.setLayout(new GridBagLayout());
            this.add(new JLabel(NbBundle.getMessage(GameBuilderNavigator.class, (String)"GameBuilderNavigator.no_structure_lbl")));
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void editing(Editable editable) {
        this.setNavigator(editable.getNavigator());
    }

    private class ADSL
    implements ActiveDocumentSupport.Listener {
        private ADSL() {
        }

        public void activeDocumentChanged(DesignDocument designDocument, final DesignDocument designDocument2) {
            if (designDocument == designDocument2) {
                return;
            }
            if (designDocument2 == null) {
                GameBuilderNavigator.this.setNavigator(null);
                return;
            }
            final JComponent[] jComponentArray = new JComponent[]{null};
            designDocument2.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    GameAccessController gameAccessController = (GameAccessController)designDocument2.getListenerManager().getAccessController(GameAccessController.class);
                    GameBuilderNavigator.this.gameDesign = gameAccessController.getGameDesign();
                    GameBuilderNavigator.this.gameDesign.getMainView().addEditorManagerListener(GameBuilderNavigator.this);
                    Editable editable = GameBuilderNavigator.this.gameDesign.getMainView().getCurrentEditable();
                    if (editable == null) {
                        return;
                    }
                    jComponentArray[0] = editable.getNavigator();
                }
            });
            GameBuilderNavigator.this.setNavigator(jComponentArray[0]);
        }

        public void activeComponentsChanged(Collection<DesignComponent> collection) {
        }
    }
}

