/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.awt.BorderLayout;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WatchPanel {
    private JPanel panel;
    private JTextComponent editorPane;
    private String expression;

    public WatchPanel(String expression) {
        this.expression = expression;
    }

    public JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle bundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WatchPanel"));
        JLabel textLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)textLabel, (String)bundle.getString("CTL_Watch_Name"));
        textLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", textLabel);
        FileObject file = EditorContextDispatcher.getDefault().getMostRecentFile();
        int line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
        String mimeType = file != null ? file.getMIMEType() : "text/plain";
        JComponent[] editorComponents = Utilities.createSingleLineEditor((String)mimeType);
        this.editorPane = (JTextComponent)editorComponents[1];
        if (file != null && line >= 0) {
            DialogBinding.bindComponentToFile((FileObject)file, (int)line, (int)0, (int)0, (JTextComponent)this.editorPane);
        }
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        this.panel.add("Center", editorComponents[0]);
        this.editorPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setBorder(new CompoundBorder(this.editorPane.getBorder(), new EmptyBorder(2, 0, 2, 0)));
        textLabel.setLabelFor(this.editorPane);
        HelpCtx.setHelpIDString((JComponent)this.editorPane, (String)"debug.customize.watch");
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    private static final class Context {
        public final FileObject fileObject;
        public final int line;

        private Context(FileObject fo, int contextLine) {
            this.fileObject = fo;
            this.line = contextLine <= 0 ? 0 : contextLine;
        }
    }
}

