/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AlignAction
extends NodeAction {
    private JMenuItem[] items;
    private ActionListener menuItemListener;

    protected boolean enable(Node[] nodeArray) {
        List<RADComponent> list = FormUtils.getSelectedLayoutComponents(nodeArray);
        return list != null && list.size() > 1;
    }

    public String getName() {
        return NbBundle.getMessage(AlignAction.class, (String)"ACT_Align");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu jMenu = new JMenu(NbBundle.getMessage(AlignAction.class, (String)"ACT_Align"));
        jMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)jMenu, (String)AlignAction.class.getName());
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)menuEvent.getSource();
                AlignAction.this.createAlignSubmenu(jMenu);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private void createAlignSubmenu(JMenu jMenu) {
        Node[] nodeArray = this.getActivatedNodes();
        List<RADComponent> list = FormUtils.getSelectedLayoutComponents(nodeArray);
        if (jMenu.getMenuComponentCount() <= 0) {
            ResourceBundle resourceBundle = NbBundle.getBundle(AlignAction.class);
            AlignMenuItem alignMenuItem = new AlignMenuItem(resourceBundle.getString("CTL_GroupLeft"), list, 0);
            AlignMenuItem alignMenuItem2 = new AlignMenuItem(resourceBundle.getString("CTL_GroupRight"), list, 1);
            AlignMenuItem alignMenuItem3 = new AlignMenuItem(resourceBundle.getString("CTL_GroupHCenter"), list, 2);
            AlignMenuItem alignMenuItem4 = new AlignMenuItem(resourceBundle.getString("CTL_GroupUp"), list, 3);
            AlignMenuItem alignMenuItem5 = new AlignMenuItem(resourceBundle.getString("CTL_GroupDown"), list, 4);
            AlignMenuItem alignMenuItem6 = new AlignMenuItem(resourceBundle.getString("CTL_GroupVCenter"), list, 5);
            AlignMenuItem alignMenuItem7 = new AlignMenuItem(resourceBundle.getString("CTL_AlignLeft"), list, 6);
            AlignMenuItem alignMenuItem8 = new AlignMenuItem(resourceBundle.getString("CTL_AlignRight"), list, 7);
            AlignMenuItem alignMenuItem9 = new AlignMenuItem(resourceBundle.getString("CTL_AlignUp"), list, 8);
            AlignMenuItem alignMenuItem10 = new AlignMenuItem(resourceBundle.getString("CTL_AlignDown"), list, 9);
            this.items = new JMenuItem[]{alignMenuItem, alignMenuItem2, alignMenuItem3, alignMenuItem4, alignMenuItem5, alignMenuItem6, alignMenuItem7, alignMenuItem8, alignMenuItem9, alignMenuItem10};
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i].addActionListener(this.getMenuItemListener());
                this.items[i].setEnabled(false);
                HelpCtx.setHelpIDString((JComponent)this.items[i], (String)AlignAction.class.getName());
                jMenu.add(this.items[i]);
                if (i != 5) continue;
                jMenu.addSeparator();
            }
        }
        this.updateState(list);
    }

    private void updateState(List list) {
        if (list == null || list.size() < 2) {
            return;
        }
        RADComponent rADComponent = (RADComponent)list.get(0);
        FormDesigner formDesigner = FormEditor.getFormDesigner(rADComponent.getFormModel());
        Collection<Action> collection = formDesigner.getDesignerActions(true);
        assert (this.items.length == 10);
        int n = collection.size();
        Action[] actionArray = collection.toArray(new Action[n]);
        for (int i = 0; i < n; ++i) {
            this.items[i].setEnabled(actionArray[i].isEnabled());
        }
        this.items[n].setEnabled(actionArray[0].isEnabled());
        this.items[n + 1].setEnabled(actionArray[1].isEnabled());
        this.items[n + 2].setEnabled(actionArray[3].isEnabled());
        this.items[n + 3].setEnabled(actionArray[4].isEnabled());
    }

    private ActionListener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new AlignMenuItemListener();
        }
        return this.menuItemListener;
    }

    private static class AlignMenuItemListener
    implements ActionListener {
        private AlignMenuItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof AlignMenuItem)) {
                return;
            }
            AlignMenuItem alignMenuItem = (AlignMenuItem)object;
            if (!alignMenuItem.isEnabled()) {
                return;
            }
            int n = alignMenuItem.getDirection();
            RADComponent rADComponent = (RADComponent)alignMenuItem.getRADComponents().get(0);
            FormModel formModel = rADComponent.getFormModel();
            FormDesigner formDesigner = FormEditor.getFormDesigner(formModel);
            ((Action)formDesigner.getDesignerActions(false).toArray()[n]).actionPerformed(actionEvent);
        }
    }

    private static class AlignMenuItem
    extends JMenuItem {
        private int direction;
        private List components;

        AlignMenuItem(String string, List list, int n) {
            super(string);
            this.components = list;
            this.direction = n;
        }

        int getDirection() {
            return this.direction;
        }

        List getRADComponents() {
            return this.components;
        }
    }
}

