/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.io.IOException;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UpdateHelper {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("carproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private static final String MINIMUM_ANT_VERSION_ELEMENT = "minimum-ant-version";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private final Notifier notifier;
    private boolean alreadyAskedInWriteAccess;
    private Element cachedElement;
    private static final String DATA = "data";
    public static final String MINIMUM_ANT_VERSION = "1.6.5";

    UpdateHelper(Project project, AntProjectHelper helper, AuxiliaryConfiguration cfg, GeneratedFilesHelper genFileHelper, Notifier notifier) {
        assert (project != null && helper != null && cfg != null && genFileHelper != null && notifier != null);
        this.project = project;
        this.helper = helper;
        this.cfg = cfg;
        this.notifier = notifier;
    }

    public EditableProperties getProperties(final String path) {
        return (EditableProperties)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                if (!UpdateHelper.this.isCurrent() && "nbproject/project.properties".equals(path)) {
                    return UpdateHelper.this.getUpdatedProjectProperties();
                }
                return UpdateHelper.this.helper.getProperties(path);
            }
        });
    }

    public void putProperties(final String path, final EditableProperties props) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(path)) {
                    UpdateHelper.this.helper.putProperties(path, props);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate();
                        UpdateHelper.this.helper.putProperties(path, props);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(shared);
                }
                return UpdateHelper.this.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean shared) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate();
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public boolean requestSave() throws IOException {
        if (this.isCurrent()) {
            return true;
        }
        if (!this.canUpdate()) {
            return false;
        }
        this.saveUpdate();
        return true;
    }

    public synchronized boolean isCurrent() {
        return true;
    }

    private boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean canUpdate = this.notifier.canUpdate();
        if (!canUpdate) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                @Override
                public void run() {
                    UpdateHelper.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return canUpdate;
    }

    private void saveUpdate() throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        this.cfg.removeConfigurationFragment(DATA, "http://www.netbeans.org/ns/j2se-project/1", true);
        this.cfg.removeConfigurationFragment(DATA, "http://www.netbeans.org/ns/j2se-project/2", true);
        ProjectManager.getDefault().saveProject(this.project);
    }

    private synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            Element oldRoot = this.cfg.getConfigurationFragment(DATA, "http://www.netbeans.org/ns/j2se-project/1", true);
            if (oldRoot != null) {
                Document doc = oldRoot.getOwnerDocument();
                Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/archive-project/1", DATA);
                XMLUtil.copyDocument((Element)oldRoot, (Element)newRoot, (String)"http://www.netbeans.org/ns/archive-project/1");
                Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/archive-project/1", "source-roots");
                Element root = doc.createElementNS("http://www.netbeans.org/ns/archive-project/1", "root");
                root.setAttribute("id", "src.dir");
                sourceRoots.appendChild(root);
                newRoot.appendChild(sourceRoots);
                Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/archive-project/1", "test-roots");
                root = doc.createElementNS("http://www.netbeans.org/ns/archive-project/1", "root");
                root.setAttribute("id", "test.src.dir");
                testRoots.appendChild(root);
                newRoot.appendChild(testRoots);
                this.cachedElement = UpdateHelper.updateMinAntVersion(newRoot, doc);
            } else {
                oldRoot = this.cfg.getConfigurationFragment(DATA, "http://www.netbeans.org/ns/j2se-project/2", true);
                if (oldRoot != null) {
                    Document doc = oldRoot.getOwnerDocument();
                    Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/archive-project/1", DATA);
                    XMLUtil.copyDocument((Element)oldRoot, (Element)newRoot, (String)"http://www.netbeans.org/ns/archive-project/1");
                    this.cachedElement = UpdateHelper.updateMinAntVersion(newRoot, doc);
                }
            }
        }
        return this.cachedElement;
    }

    private synchronized EditableProperties getUpdatedProjectProperties() {
        EditableProperties cachedProperties = this.helper.getProperties("nbproject/project.properties");
        return cachedProperties;
    }

    private static Element updateMinAntVersion(Element root, Document doc) {
        Element me;
        NodeList list = root.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", MINIMUM_ANT_VERSION_ELEMENT);
        if (list.getLength() == 1 && (list = (me = (Element)list.item(0)).getChildNodes()).getLength() == 1) {
            me.replaceChild(doc.createTextNode(MINIMUM_ANT_VERSION), list.item(0));
            return root;
        }
        assert (false) : "Invalid project file";
        return root;
    }

    public static Notifier createDefaultNotifier() {
        return new Notifier(){

            @Override
            public boolean canUpdate() {
                JButton updateOption = new JButton(NbBundle.getMessage(UpdateHelper.class, (String)"CTL_UpdateOption"));
                updateOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateHelper.class, (String)"AD_UpdateOption"));
                return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption;
            }
        };
    }

    public static interface Notifier {
        public boolean canUpdate();
    }
}

