/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.wizard;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.HashSet;
import java.util.Set;

class EJBClassFile {
    private ByteBuffer header;
    private EJBConstantPoolInfo constantPoolInfo = new EJBConstantPoolInfo();
    public short majorVersion;
    public short minorVersion;
    public EJBConstantPoolInfo[] constantPool;
    public short accessFlags;
    public EJBConstantPoolInfo thisClass;
    public EJBConstantPoolInfo superClass;
    public EJBConstantPoolInfo[] interfaces;
    private static final int magic = -889275714;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_THREADSAFE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;

    EJBClassFile() {
        this.header = ByteBuffer.allocate(12000);
    }

    boolean containsAnnotation(ReadableByteChannel in, long size) throws IOException {
        boolean retVal = false;
        if (null != in) {
            this.header.clear();
            if (size != -1L && size > (long)this.header.capacity()) {
                this.header = ByteBuffer.allocate((int)size);
            }
            long read = in.read(this.header);
            if (size != -1L && read != size) {
                return false;
            }
            this.header.rewind();
            if (this.header.getInt() != -889275714) {
                return false;
            }
            this.majorVersion = this.header.getShort();
            this.minorVersion = this.header.getShort();
            short constantPoolSize = this.header.getShort();
            retVal = this.constantPoolInfo.containsAnnotation(constantPoolSize, this.header);
        }
        return retVal;
    }

    static class EJBConstantPoolInfo {
        byte[] bytes = new byte[Short.MAX_VALUE];
        private Set<String> annotations = new HashSet<String>();
        public static final byte CLASS = 7;
        public static final int FIELDREF = 9;
        public static final int METHODREF = 10;
        public static final int STRING = 8;
        public static final int INTEGER = 3;
        public static final int FLOAT = 4;
        public static final int LONG = 5;
        public static final int DOUBLE = 6;
        public static final int INTERFACEMETHODREF = 11;
        public static final int NAMEANDTYPE = 12;
        public static final int ASCIZ = 1;
        public static final int UNICODE = 2;

        public EJBConstantPoolInfo() {
            this.annotations.add("Ljavax/ejb/Stateless;");
            this.annotations.add("Ljavax/ejb/Stateful;");
            this.annotations.add("Ljavax/ejb/MessageDriven;");
        }

        public boolean containsAnnotation(int constantPoolSize, ByteBuffer buffer) throws IOException {
            block7: for (int i = 1; i < constantPoolSize; ++i) {
                byte type = buffer.get();
                switch (type) {
                    case 1: 
                    case 2: {
                        String stringValue;
                        short length = buffer.getShort();
                        if (length < 0 || length > Short.MAX_VALUE) {
                            return true;
                        }
                        buffer.get(this.bytes, 0, length);
                        if (this.bytes[0] != 76 || this.bytes[1] != 106 || this.bytes[2] != 97 || !this.annotations.contains(stringValue = type == 1 ? new String(this.bytes, 0, (int)length, "US-ASCII") : new String(this.bytes, 0, (int)length))) continue block7;
                        return true;
                    }
                    case 7: 
                    case 8: {
                        buffer.getShort();
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: {
                        buffer.position(buffer.position() + 4);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        buffer.position(buffer.position() + 8);
                        ++i;
                        continue block7;
                    }
                    case 12: {
                        buffer.getShort();
                        buffer.getShort();
                        continue block7;
                    }
                }
            }
            return false;
        }
    }
}

