/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.spi.GoToSourceProvider;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class GoToJavaSourceProvider
extends GoToSourceProvider {
    @Override
    public boolean openSource(Project project, final String string, final String string2, final String string3, final int n) {
        FileObject fileObject;
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        String string4 = GoToJavaSourceProvider.getJavaFileName(string);
        ClasspathInfo classpathInfo = project != null ? ProjectUtilities.getClasspathInfo(project, true) : null;
        ClassPath classPath = classpathInfo != null ? classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE) : null;
        FileObject fileObject2 = fileObject = classPath != null ? classPath.findResource(string4) : null;
        if (fileObject == null) {
            classPath = ClassPathSupport.createClassPath((FileObject[])GlobalPathRegistry.getDefault().getSourceRoots().toArray(new FileObject[0]));
            FileObject fileObject3 = fileObject = classPath != null ? classPath.findResource(string4) : null;
        }
        if (fileObject == null) {
            return false;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource != null) {
            try {
                javaSource.runWhenScanFinished((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        if (!compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).equals((Object)JavaSource.Phase.ELEMENTS_RESOLVED)) {
                            return;
                        }
                        TypeElement typeElement = SourceUtils.resolveClassByName((String)string, (CompilationController)compilationController);
                        if (ElementOpen.open((ClasspathInfo)compilationController.getClasspathInfo(), (Element)typeElement)) {
                            Document document = compilationController.getDocument();
                            if (document != null && document instanceof StyledDocument) {
                                ExecutableElement executableElement;
                                if (GoToJavaSourceProvider.openAtLine(compilationController, document, string2, n)) {
                                    atomicBoolean.set(true);
                                    return;
                                }
                                if (string2 != null && (executableElement = SourceUtils.resolveMethodByName((CompilationInfo)compilationController, (TypeElement)typeElement, (String)string2, (String)string3)) != null && ElementOpen.open((ClasspathInfo)compilationController.getClasspathInfo(), (Element)executableElement)) {
                                    atomicBoolean.set(true);
                                    return;
                                }
                            }
                            atomicBoolean.set(true);
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return atomicBoolean.get();
        }
        return false;
    }

    private static boolean openAtLine(CompilationController compilationController, Document document, String string, int n) {
        try {
            if (n > -1) {
                Line line;
                LineCookie lineCookie;
                String string2;
                DataObject dataObject = DataObject.find((FileObject)compilationController.getFileObject());
                int n2 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)document), (int)n);
                ExecutableElement executableElement = compilationController.getTreeUtilities().scopeFor(n2).getEnclosingMethod();
                if (executableElement != null && string.equals(string2 = executableElement.getSimpleName().toString()) && (lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) != null && (line = lineCookie.getLineSet().getCurrent(n - 1)) != null) {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    return true;
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(GoToJavaSourceProvider.class.getName()).log(Level.WARNING, "Error accessing dataobject", dataObjectNotFoundException);
        }
        return false;
    }

    private static String getJavaFileName(String string) {
        String string2 = string.replace('.', '/');
        int n = string2.indexOf("$");
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        return string2.concat(".java");
    }
}

