/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionProvider;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmIncludeHyperlinkProvider;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.DocOffsetableImpl;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ThisReferenceImpl;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.CharSequences;
import org.openide.util.Parameters;
import org.openide.util.UserQuestionException;

public final class ReferencesSupport {
    private static ReferencesSupport instance = new ReferencesSupport();
    private static Reference<FileToDoc> lastCsmFile = null;
    private final CsmProgressListener progressListener;
    private static final int MAX_CACHE_SIZE = 10;
    private final Object cacheLock = new CacheLock();
    private Map<CsmFile, Map<Integer, CsmObject>> cache = new HashMap<CsmFile, Map<Integer, CsmObject>>();
    private static CsmObject FAKE = new CsmObject(){

        public String toString() {
            return "FAKE REFERENCE";
        }
    };

    private ReferencesSupport() {
        this.progressListener = new CsmProgressAdapter(){

            public void fileParsingFinished(CsmFile file) {
                ReferencesSupport.this.clearFileReferences(file);
            }

            public void projectParsingFinished(CsmProject project) {
                ReferencesSupport.this.clearFileReferences(null);
            }
        };
        CsmListeners.getDefault().addProgressListener(this.progressListener);
    }

    public static ReferencesSupport instance() {
        return instance;
    }

    public static int getDocumentOffset(BaseDocument doc, int lineIndex, int colIndex) {
        return Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(lineIndex - 1)) + (colIndex - 1);
    }

    public static BaseDocument getBaseDocument(String absPath) throws DataObjectNotFoundException, IOException {
        File file = new File(absPath);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie cookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (cookie == null) {
            throw new IllegalStateException("Given file (\"" + dataObject.getName() + "\") does not have EditorCookie.");
        }
        StyledDocument doc = null;
        try {
            doc = cookie.openDocument();
        }
        catch (UserQuestionException ex) {
            ex.confirmed();
            doc = cookie.openDocument();
        }
        return doc instanceof BaseDocument ? (BaseDocument)doc : null;
    }

    public CsmObject findReferencedObject(CsmFile csmFile, BaseDocument doc, int offset) {
        return this.findReferencedObject(csmFile, doc, offset, null, null);
    }

    static CsmObject findOwnerObject(CsmFile csmFile, BaseDocument baseDocument, int offset, TokenItem<CppTokenId> token) {
        CsmObject csmOwner = CsmOffsetResolver.findObject(csmFile, offset);
        return csmOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmObject findReferencedObject(CsmFile csmFile, BaseDocument doc, int offset, TokenItem<CppTokenId> jumpToken, FileReferencesContext fileReferencesContext) {
        long oldVersion = CsmFileInfoQuery.getDefault().getFileVersion(csmFile);
        CsmInclude csmItem = null;
        Object incl = null;
        if (jumpToken == null) {
            doc.readLock();
            try {
                jumpToken = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)offset);
            }
            finally {
                doc.readUnlock();
            }
        }
        if (jumpToken != null) {
            switch ((CppTokenId)jumpToken.id()) {
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: {
                    csmItem = ReferencesSupport.findInclude(csmFile, offset);
                    break;
                }
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_USER_INCLUDE: {
                    csmItem = ReferencesSupport.findInclude(csmFile, offset);
                    if (csmItem == null) break;
                    csmItem = csmItem.getIncludeFile();
                }
            }
        }
        if (csmItem == null) {
            int key = jumpToken.offset();
            if (key < 0) {
                key = offset;
            }
            if ((csmItem = this.getReferencedObject(csmFile, key, oldVersion)) == null) {
                csmItem = ReferencesSupport.findDeclaration(csmFile, (Document)doc, (TokenItem<CppTokenId>)jumpToken, key, fileReferencesContext);
                if (csmItem == null) {
                    this.putReferencedObject(csmFile, key, FAKE, oldVersion);
                } else {
                    this.putReferencedObject(csmFile, key, (CsmObject)csmItem, oldVersion);
                }
            } else if (csmItem == FAKE) {
                csmItem = null;
            }
        }
        return csmItem;
    }

    public static CsmInclude findInclude(CsmFile csmFile, int offset) {
        assert (csmFile != null);
        return (CsmInclude)CsmOffsetUtilities.findObject(csmFile.getIncludes(), null, offset);
    }

    public static CsmObject findDeclaration(CsmFile csmFile, Document doc, TokenItem<CppTokenId> tokenUnderOffset, int offset) {
        return ReferencesSupport.findDeclaration(csmFile, doc, tokenUnderOffset, offset, null);
    }

    private static CsmObject findDeclaration(CsmFile csmFile, Document doc, TokenItem<CppTokenId> tokenUnderOffset, int offset, FileReferencesContext fileReferencesContext) {
        CsmObject csmItem = null;
        List macroUsages = CsmFileInfoQuery.getDefault().getMacroUsages(csmFile);
        csmItem = ReferencesSupport.findMacro(macroUsages, offset);
        if (csmItem != null) {
            return csmItem;
        }
        CsmObject objUnderOffset = CsmOffsetResolver.findObject(csmFile, offset, fileReferencesContext);
        if (CsmKindUtilities.isEnumerator((Object)objUnderOffset)) {
            CsmEnumerator enmrtr = (CsmEnumerator)objUnderOffset;
            if (enmrtr.getExplicitValue() == null) {
                csmItem = enmrtr;
            }
        } else if (CsmKindUtilities.isLabel((CsmObject)objUnderOffset)) {
            csmItem = objUnderOffset;
        } else if (CsmKindUtilities.isGotoStatement((CsmObject)objUnderOffset)) {
            Collection labels;
            CsmGotoStatement csmGoto = (CsmGotoStatement)objUnderOffset;
            CsmScope scope = csmGoto.getScope();
            while (scope != null && CsmKindUtilities.isScopeElement((CsmObject)scope) && !CsmKindUtilities.isFunctionDefinition((CsmObject)scope)) {
                scope = ((CsmScopeElement)scope).getScope();
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)scope) && !(labels = CsmLabelResolver.getDefault().getLabels((CsmFunctionDefinition)scope, csmGoto.getLabel(), EnumSet.of(CsmLabelResolver.LabelKind.Definiton))).isEmpty()) {
                csmItem = ((CsmReference)labels.iterator().next()).getReferencedObject();
            }
            if (csmItem == null) {
                return null;
            }
        } else if (CsmKindUtilities.isVariable((CsmObject)objUnderOffset) || CsmKindUtilities.isTypedef((CsmObject)objUnderOffset)) {
            boolean repeat;
            CsmType type = CsmKindUtilities.isVariable((CsmObject)objUnderOffset) ? ((CsmVariable)objUnderOffset).getType() : ((CsmTypedef)objUnderOffset).getType();
            CsmParameter parameter = null;
            do {
                CsmParameter deeperParameter;
                repeat = false;
                if (CsmOffsetUtilities.isInObject((CsmObject)type, offset)) {
                    parameter = null;
                    continue;
                }
                if (!CsmKindUtilities.isFunctionPointerType((CsmObject)type) || (deeperParameter = (CsmParameter)CsmOffsetUtilities.findObject(((CsmFunctionPointerType)type).getParameters(), null, offset)) == null) continue;
                parameter = deeperParameter;
                type = deeperParameter.getType();
                repeat = true;
            } while (repeat);
            csmItem = parameter;
        }
        if (csmItem == null) {
            int[] idFunBlk = null;
            try {
                if (doc instanceof BaseDocument) {
                    idFunBlk = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)((BaseDocument)doc), (int)offset);
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            if (idFunBlk != null && idFunBlk.length != 3) {
                csmItem = ReferencesSupport.findDeclaration(csmFile, doc, tokenUnderOffset, offset, CsmCompletionQuery.QueryScope.SMART_QUERY, fileReferencesContext);
            }
        }
        csmItem = csmItem != null ? csmItem : ReferencesSupport.findDeclaration(csmFile, doc, tokenUnderOffset, offset, CsmCompletionQuery.QueryScope.GLOBAL_QUERY, fileReferencesContext);
        return csmItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CsmObject findDeclaration(CsmFile csmFile, Document doc, TokenItem<CppTokenId> tokenUnderOffset, int offset, CsmCompletionQuery.QueryScope queryScope, FileReferencesContext fileReferencesContext) {
        Collection<CsmObject> objs;
        assert (csmFile != null);
        if (tokenUnderOffset == null && doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
            try {
                tokenUnderOffset = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)offset);
            }
            finally {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        if (tokenUnderOffset == null) {
            return null;
        }
        CsmObject csmObject = null;
        if (tokenUnderOffset.id() == CppTokenId.OPERATOR) {
            CsmObject foundObject = CsmOffsetResolver.findObject(csmFile, offset, fileReferencesContext);
            csmObject = foundObject;
            if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
                CsmFunction decl = null;
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                    decl = ((CsmFunctionDefinition)csmObject).getDeclaration();
                } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmObject)) {
                    decl = ((CsmFriendFunction)csmObject).getReferencedFunction();
                }
                if (decl != null) {
                    csmObject = decl;
                }
            } else {
                csmObject = null;
            }
        }
        if (csmObject == null && !(objs = CompletionUtilities.findItemsReferencedAtCaretPos(null, doc, CsmCompletionProvider.getCompletionQuery(csmFile, queryScope, fileReferencesContext), offset)).isEmpty()) {
            csmObject = objs.iterator().next();
        }
        return csmObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReferenceImpl createReferenceImpl(CsmFile file, BaseDocument doc, int offset) {
        ReferenceImpl ref = null;
        doc.readLock();
        try {
            TokenItem token = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)offset);
            if (ReferencesSupport.isSupportedToken((TokenItem<CppTokenId>)token)) {
                ref = ReferencesSupport.createReferenceImpl(file, doc, offset, (TokenItem<CppTokenId>)token, null);
            }
        }
        finally {
            doc.readUnlock();
        }
        return ref;
    }

    public static ReferenceImpl createReferenceImpl(CsmFile file, BaseDocument doc, int offset, TokenItem<CppTokenId> token, CsmReferenceKind kind) {
        assert (token != null);
        assert (file != null) : "null file for document " + doc + " on offset " + offset + " " + token;
        if (token.id() == CppTokenId.THIS) {
            return new ThisReferenceImpl(file, doc, offset, token, kind);
        }
        return new ReferenceImpl(file, doc, offset, token, kind);
    }

    private static boolean isSupportedToken(TokenItem<CppTokenId> token) {
        return token != null && (CsmIncludeHyperlinkProvider.isSupportedToken(token, HyperlinkType.GO_TO_DECLARATION) || CsmHyperlinkProvider.isSupportedToken(token, HyperlinkType.GO_TO_DECLARATION));
    }

    public static CsmReferenceResolver.Scope fastCheckScope(CsmReference ref) {
        Parameters.notNull((CharSequence)"ref", (Object)ref);
        CsmObject target = ReferencesSupport.getTargetIfPossible(ref);
        if (target == null) {
            int offset = ReferencesSupport.getRefOffset(ref);
            BaseDocument doc = ReferencesSupport.getRefDocument(ref);
            if (doc != null) {
                TokenItem<CppTokenId> token = ReferencesSupport.getRefTokenIfPossible(ref);
                target = ReferencesSupport.findDeclaration(ref.getContainingFile(), (Document)doc, token, offset, CsmCompletionQuery.QueryScope.LOCAL_QUERY, null);
                ReferencesSupport.setResolvedInfo(ref, target);
            }
        }
        return ReferencesSupport.getTargetScope(target);
    }

    private static CsmReferenceResolver.Scope getTargetScope(CsmObject obj) {
        if (obj == null) {
            return CsmReferenceResolver.Scope.UNKNOWN;
        }
        if (ReferencesSupport.isLocalElement(obj)) {
            return CsmReferenceResolver.Scope.LOCAL;
        }
        if (ReferencesSupport.isFileLocalElement(obj)) {
            return CsmReferenceResolver.Scope.FILE_LOCAL;
        }
        return CsmReferenceResolver.Scope.GLOBAL;
    }

    private static CsmObject getTargetIfPossible(CsmReference ref) {
        if (ref instanceof ReferenceImpl) {
            return ((ReferenceImpl)ref).getTarget();
        }
        return null;
    }

    static TokenItem<CppTokenId> getRefTokenIfPossible(CsmReference ref) {
        if (ref instanceof ReferenceImpl) {
            return ((ReferenceImpl)ref).getToken();
        }
        return null;
    }

    private static CsmReferenceKind getRefKindIfPossible(CsmReference ref) {
        if (ref instanceof ReferenceImpl) {
            return ((ReferenceImpl)ref).getKindImpl();
        }
        return null;
    }

    private static BaseDocument getRefDocument(CsmReference ref) {
        if (ref instanceof DocOffsetableImpl) {
            return ((DocOffsetableImpl)ref).getDocument();
        }
        CsmFile file = ref.getContainingFile();
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)file);
        StyledDocument doc = null;
        if (ces != null) {
            doc = ces.getDocument();
        }
        return doc instanceof BaseDocument ? (BaseDocument)doc : null;
    }

    private static int getRefOffset(CsmReference ref) {
        if (ref instanceof ReferenceImpl) {
            return ((ReferenceImpl)ref).getOffset();
        }
        return (ref.getStartOffset() + ref.getEndOffset() + 1) / 2;
    }

    private static void setResolvedInfo(CsmReference ref, CsmObject target) {
        if (target != null && ref instanceof ReferenceImpl) {
            ((ReferenceImpl)ref).setTarget(target);
        }
    }

    private static boolean isLocalElement(CsmObject decl) {
        assert (decl != null);
        CsmObject scopeElem = decl;
        while (CsmKindUtilities.isScopeElement((CsmObject)scopeElem)) {
            CsmScope scope = ((CsmScopeElement)scopeElem).getScope();
            if (CsmKindUtilities.isFunction((CsmObject)scope)) {
                return true;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)scope)) break;
            scopeElem = (CsmScopeElement)scope;
        }
        return false;
    }

    private static boolean isFileLocalElement(CsmObject decl) {
        assert (decl != null);
        if (CsmBaseUtilities.isDeclarationFromUnnamedNamespace((CsmObject)decl)) {
            return true;
        }
        if (CsmKindUtilities.isFileLocalVariable((CsmObject)decl)) {
            return true;
        }
        if (CsmKindUtilities.isFunction((CsmObject)decl)) {
            return CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)decl));
        }
        return false;
    }

    static BaseDocument getDocument(CsmFile file) {
        BaseDocument doc = null;
        try {
            FileToDoc pair;
            Reference<FileToDoc> lcf = lastCsmFile;
            if (lcf != null && (pair = lcf.get()) != null && pair.file == file) {
                return pair.doc;
            }
            doc = ReferencesSupport.getBaseDocument(((Object)file.getAbsolutePath()).toString());
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        if (doc != null) {
            lastCsmFile = new WeakReference<FileToDoc>(new FileToDoc(doc, file));
        }
        return doc;
    }

    static CsmReferenceKind getReferenceKind(CsmReference ref) {
        CsmReferenceKind kind = CsmReferenceKind.UNKNOWN;
        CsmObject owner = ref.getOwner();
        if (CsmKindUtilities.isType((CsmObject)owner) || CsmKindUtilities.isInheritance((CsmObject)owner)) {
            kind = ReferencesSupport.getReferenceUsageKind(ref);
        } else if (CsmKindUtilities.isInclude((CsmObject)owner)) {
            kind = CsmReferenceKind.DIRECT_USAGE;
        } else {
            CsmObject target = ref.getReferencedObject();
            if (target == null) {
                kind = ReferencesSupport.getReferenceUsageKind(ref);
            } else {
                CsmObject[] decDef = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)target, (boolean)true);
                CsmObject targetDecl = decDef[0];
                CsmObject targetDef = decDef[1];
                assert (targetDecl != null);
                kind = CsmReferenceKind.DIRECT_USAGE;
                if (owner != null) {
                    kind = owner.equals(targetDef) ? CsmReferenceKind.DEFINITION : (ReferencesSupport.sameDeclaration(owner, targetDecl) ? CsmReferenceKind.DECLARATION : ReferencesSupport.getReferenceUsageKind(ref));
                }
            }
        }
        return kind;
    }

    private static boolean sameDeclaration(CsmObject checkDecl, CsmObject targetDecl) {
        if (checkDecl.equals(targetDecl)) {
            return true;
        }
        if (CsmKindUtilities.isQualified((CsmObject)checkDecl) && CsmKindUtilities.isQualified((CsmObject)targetDecl)) {
            CharSequence fqnTarget;
            CharSequence fqnCheck = ((CsmQualifiedNamedElement)checkDecl).getQualifiedName();
            if (fqnCheck.equals(fqnTarget = ((CsmQualifiedNamedElement)targetDecl).getQualifiedName())) {
                return true;
            }
            String strFqn = ((Object)fqnCheck).toString().trim();
            if (strFqn.endsWith("const")) {
                int cutConstInd = strFqn.lastIndexOf("const");
                assert (cutConstInd >= 0);
                fqnCheck = CharSequences.create((CharSequence)strFqn.substring(cutConstInd));
            }
            return fqnCheck.equals(fqnTarget);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CsmReferenceKind getReferenceUsageKind(CsmReference ref) {
        CsmReferenceKind kind = CsmReferenceKind.DIRECT_USAGE;
        if (!(ref instanceof ReferenceImpl)) return kind;
        CsmReferenceKind implKind = ReferencesSupport.getRefKindIfPossible(ref);
        if (implKind != null) {
            return implKind;
        }
        BaseDocument doc = ReferencesSupport.getRefDocument(ref);
        doc.readLock();
        try {
            int offset = ref.getStartOffset();
            TokenItem token = CndTokenUtilities.getFirstNonWhiteBwd((Document)doc, (int)offset);
            if (token == null) return kind;
            switch ((CppTokenId)token.id()) {
                case DOT: 
                case DOTMBR: 
                case ARROW: 
                case ARROWMBR: 
                case SCOPE: {
                    kind = CsmReferenceKind.AFTER_DEREFERENCE_USAGE;
                    return kind;
                }
            }
            return kind;
        }
        finally {
            doc.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject getReferencedObject(CsmFile file, int offset, long oldVersion) {
        Object object = this.cacheLock;
        synchronized (object) {
            Map<Integer, CsmObject> map = this.cache.get(file);
            CsmObject out = null;
            if (map != null && (out = map.get(offset)) == FAKE && CsmFileInfoQuery.getDefault().getFileVersion(file) != oldVersion) {
                map.put(offset, null);
                out = null;
            }
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putReferencedObject(CsmFile file, int offset, CsmObject object, long oldVersion) {
        Object object2 = this.cacheLock;
        synchronized (object2) {
            if (object == FAKE && CsmFileInfoQuery.getDefault().getFileVersion(file) != oldVersion) {
                return;
            }
            Map<Integer, CsmObject> map = this.cache.get(file);
            if (map == null) {
                if (this.cache.size() > 10) {
                    this.cache.clear();
                }
                map = new HashMap<Integer, CsmObject>();
                this.cache.put(file, map);
            }
            map.put(offset, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFileReferences(CsmFile file) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (file == null) {
                this.cache.clear();
            } else {
                this.cache.remove(file);
            }
        }
    }

    public static CsmObject findMacro(List<CsmReference> macroUsages, int offset) {
        int index = Collections.binarySearch(macroUsages, new RefOffsetKey(offset), new Comparator<CsmReference>(){

            @Override
            public int compare(CsmReference o1, CsmReference o2) {
                if (o1 instanceof RefOffsetKey ? o2.getStartOffset() <= o1.getStartOffset() && o1.getEndOffset() <= o2.getEndOffset() : o2 instanceof RefOffsetKey && o1.getStartOffset() <= o2.getStartOffset() && o2.getEndOffset() <= o1.getEndOffset()) {
                    return 0;
                }
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        if (index >= 0) {
            CsmReference macroRef = macroUsages.get(index);
            CsmObject csmItem = macroRef.getReferencedObject();
            assert (csmItem != null) : "referenced macro is null. ref " + macroRef + ", file " + macroRef.getContainingFile() + ", name " + macroRef.getText();
            return csmItem;
        }
        return null;
    }

    private static final class RefOffsetKey
    implements CsmReference {
        private final int offset;

        private RefOffsetKey(int offset) {
            this.offset = offset;
        }

        public CsmReferenceKind getKind() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmObject getReferencedObject() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmObject getOwner() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmFile getContainingFile() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getStartOffset() {
            return this.offset;
        }

        public int getEndOffset() {
            return this.offset;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class CacheLock {
        private CacheLock() {
        }
    }

    private static class FileToDoc {
        BaseDocument doc;
        CsmFile file;

        FileToDoc(BaseDocument doc, CsmFile file) {
            this.doc = doc;
            this.file = file;
        }
    }
}

