/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.annotate;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateLine;
import org.netbeans.modules.mercurial.ui.annotate.AnnotationBar;
import org.netbeans.modules.mercurial.ui.annotate.AnnotationBarManager;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AnnotateAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        if (!HgUtils.isFromHgRepository(context)) {
            return false;
        }
        if (context.getRootFiles().size() > 0 && this.activatedEditorCookie(nodes) != null) {
            File file;
            FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
            FileInformation info = cache.getCachedStatus(file = this.activatedFile(nodes));
            if (info != null) {
                int status = info.getStatus();
                return status != 4 && status != 2;
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return this.visible(nodes) ? "CTL_MenuItem_HideAnnotations" : "CTL_MenuItem_ShowAnnotations";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (this.visible(nodes)) {
            JEditorPane pane = this.activatedEditorPane(nodes);
            AnnotationBarManager.hideAnnotationBar(pane);
        } else {
            EditorCookie ec = this.activatedEditorCookie(nodes);
            if (ec == null) {
                return;
            }
            File file = this.activatedFile(nodes);
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes == null) {
                ec.open();
                panes = ec.getOpenedPanes();
            }
            if (panes == null) {
                return;
            }
            JEditorPane currentPane = panes[0];
            AnnotateAction.showAnnotations(currentPane, file, null);
        }
    }

    public static void showAnnotations(JEditorPane currentPane, final File file, final String revision) {
        if (currentPane == null || file == null) {
            return;
        }
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, currentPane);
        tc.requestActive();
        final AnnotationBar ab = AnnotationBarManager.showAnnotationBar(currentPane);
        ab.setAnnotationMessage(NbBundle.getMessage(AnnotateAction.class, (String)"CTL_AnnotationSubstitute"));
        final File repository = Mercurial.getInstance().getRepositoryRoot(file);
        if (repository == null) {
            return;
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                if (revision != null) {
                    ab.setReferencedFile(file);
                }
                OutputLogger logger = this.getLogger();
                logger.outputInRed(NbBundle.getMessage(AnnotateAction.class, (String)"MSG_ANNOTATE_TITLE"));
                logger.outputInRed(NbBundle.getMessage(AnnotateAction.class, (String)"MSG_ANNOTATE_TITLE_SEP"));
                AnnotateAction.computeAnnotations(repository, file, this, ab, revision);
                logger.output("\t" + file.getAbsolutePath());
                logger.outputInRed(NbBundle.getMessage(AnnotateAction.class, (String)"MSG_ANNOTATE_DONE"));
            }
        };
        support.start(rp, repository, NbBundle.getMessage(AnnotateAction.class, (String)"MSG_Annotation_Progress"));
    }

    private static void computeAnnotations(File repository, File file, HgProgressSupport progress, AnnotationBar ab, String revision) {
        List<String> list = null;
        try {
            list = HgCommand.doAnnotate(repository, file, revision, progress.getLogger());
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        if (progress.isCanceled()) {
            ab.setAnnotationMessage(NbBundle.getMessage(AnnotateAction.class, (String)"CTL_AnnotationFailed"));
            return;
        }
        if (list == null) {
            return;
        }
        AnnotateLine[] lines = AnnotateAction.toAnnotateLines(list);
        HashSet<File> setFile = new HashSet<File>();
        setFile.add(file);
        HgLogMessage[] logs = HgCommand.getLogMessagesNoFileInfo(repository, setFile, -1, progress.getLogger());
        if (progress.isCanceled()) {
            return;
        }
        if (logs == null) {
            return;
        }
        AnnotateAction.fillCommitMessages(lines, logs);
        ab.setLogs(logs);
        ab.annotationLines(file, Arrays.asList(lines));
    }

    private static void fillCommitMessages(AnnotateLine[] annotations, HgLogMessage[] logs) {
        long lowestRevisionNumber = Long.MAX_VALUE;
        for (int i = 0; i < annotations.length; ++i) {
            AnnotateLine annotation = annotations[i];
            if (annotation == null) {
                Mercurial.LOG.log(Level.WARNING, "AnnotateAction: annotation {0} of {1} is null", new Object[]{i, annotations.length});
                continue;
            }
            for (int j = 0; j < logs.length; ++j) {
                HgLogMessage log = logs[j];
                if (log == null) {
                    Mercurial.LOG.log(Level.WARNING, "AnnotateAction: log {0} of {1} is null", new Object[]{j, logs.length});
                    continue;
                }
                if (log.getRevisionAsLong() < lowestRevisionNumber) {
                    lowestRevisionNumber = log.getRevisionAsLong();
                }
                if (!annotation.getRevision().equals(log.getRevision())) continue;
                annotation.setDate(log.getDate());
                annotation.setId(log.getCSetShortID());
                annotation.setCommitMessage(log.getMessage());
            }
        }
        String lowestRev = Long.toString(lowestRevisionNumber);
        for (int i = 0; i < annotations.length; ++i) {
            AnnotateLine annotation = annotations[i];
            if (annotation == null) {
                Mercurial.LOG.log(Level.WARNING, "AnnotateAction: annotation {0} of {1} is null", new Object[]{i, annotations.length});
                continue;
            }
            annotation.setCanBeRolledBack(!annotation.getRevision().equals(lowestRev));
        }
    }

    private static AnnotateLine[] toAnnotateLines(List<String> annotations) {
        boolean GROUP_AUTHOR = true;
        int GROUP_REVISION = 2;
        int GROUP_FILENAME = 3;
        int GROUP_CONTENT = 4;
        ArrayList<AnnotateLine> lines = new ArrayList<AnnotateLine>();
        int i = 0;
        Pattern p = Pattern.compile("^\\s*(\\S+\\b)\\s+(\\d+)\\s+(\\b\\S*):\\s(.*)$");
        for (String line : annotations) {
            AnnotateLine anLine;
            ++i;
            Matcher m = p.matcher(line);
            if (!m.matches()) {
                Mercurial.LOG.log(Level.WARNING, "AnnotateAction: toAnnotateLines(): Failed when matching: {0}", new Object[]{line});
                anLine = new FakeAnnotationLine();
            } else {
                anLine = new AnnotateLine();
                anLine.setAuthor(m.group(1));
                anLine.setRevision(m.group(2));
                anLine.setFileName(m.group(3));
                anLine.setContent(m.group(4));
            }
            anLine.setLineNum(i);
            lines.add(anLine);
        }
        return lines.toArray(new AnnotateLine[lines.size()]);
    }

    public boolean visible(Node[] nodes) {
        JEditorPane currentPane = this.activatedEditorPane(nodes);
        return AnnotationBarManager.annotationBarVisible(currentPane);
    }

    private JEditorPane activatedEditorPane(Node[] nodes) {
        EditorCookie ec = this.activatedEditorCookie(nodes);
        if (ec != null && EventQueue.isDispatchThread()) {
            return NbDocument.findRecentEditorPane((EditorCookie)ec);
        }
        return null;
    }

    private EditorCookie activatedEditorCookie(Node[] nodes) {
        if (nodes == null) {
            nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        if (nodes.length == 1) {
            Node node = nodes[0];
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }

    private File activatedFile(Node[] nodes) {
        Node node;
        DataObject dobj;
        if (nodes.length == 1 && (dobj = (DataObject)(node = nodes[0]).getCookie(DataObject.class)) != null) {
            FileObject fo = dobj.getPrimaryFile();
            return FileUtil.toFile((FileObject)fo);
        }
        return null;
    }

    private static class FakeAnnotationLine
    extends AnnotateLine {
        public FakeAnnotationLine() {
            String fakeItem = NbBundle.getMessage(AnnotateAction.class, (String)"MSG_AnnotateAction.lineDetail.unknown");
            this.setAuthor(fakeItem);
            this.setContent(fakeItem);
            this.setRevision(fakeItem);
            this.setFileName(fakeItem);
        }
    }
}

