/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Toolkit;
import java.io.CharConversionException;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;

final class TextDetail {
    static final int DH_SHOW = 1;
    static final int DH_GOTO = 2;
    static final int DH_HIDE = 3;
    private DataObject dobj;
    private int line;
    private String lineText;
    private int column;
    private int markLength;
    private Line lineObj;
    private SearchPattern searchPattern;
    private int startOffset;
    private int endOffset;
    private String matchedText;

    TextDetail(DataObject dobj, SearchPattern pattern) {
        this.dobj = dobj;
        this.searchPattern = pattern;
    }

    void showDetail(int how) {
        JEditorPane[] panes;
        this.prepareLine();
        if (this.lineObj == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (how == 3) {
            return;
        }
        EditorCookie edCookie = (EditorCookie)this.dobj.getCookie(EditorCookie.class);
        if (edCookie != null) {
            edCookie.open();
        }
        if (how == 1) {
            this.lineObj.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE, this.column - 1);
        } else if (how == 2) {
            this.lineObj.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column - 1);
        }
        if (this.markLength > 0 && edCookie != null && (panes = edCookie.getOpenedPanes()) != null && panes.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Caret caret = panes[0].getCaret();
                    caret.moveDot(caret.getDot() + TextDetail.this.markLength);
                }
            });
        }
        SearchHistory.getDefault().setLastSelected(this.searchPattern);
    }

    String getLineText() {
        return this.lineText;
    }

    void setLineText(String text) {
        this.lineText = text;
    }

    String getLineTextPart(int beginIndex, int endIndex) {
        return this.lineText.substring(beginIndex, endIndex);
    }

    String getLineTextPart(int beginIndex) {
        return this.lineText.substring(beginIndex);
    }

    int getLineTextLength() {
        return this.lineText == null ? 0 : this.lineText.length();
    }

    DataObject getDataObject() {
        return this.dobj;
    }

    int getLine() {
        return this.line;
    }

    void setLine(int line) {
        this.line = line;
    }

    int getColumn() {
        return this.column;
    }

    void setColumn(int col) {
        this.column = col;
    }

    int getColumn0() {
        return this.column - 1;
    }

    void setMarkLength(int len) {
        this.markLength = len;
    }

    int getMarkLength() {
        return this.markLength;
    }

    int getEndOffset() {
        return this.endOffset;
    }

    void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    int getStartOffset() {
        return this.startOffset;
    }

    void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    String getMatchedText() {
        return this.matchedText;
    }

    void setMatchedText(String matchedText) {
        this.matchedText = matchedText;
    }

    void associate(int lineNumber, int column, String lineText) {
        this.setLine(lineNumber);
        this.setColumn(column);
        this.setLineText(lineText);
    }

    private void prepareLine() {
        LineCookie lineCookie;
        if (this.dobj == null || !this.dobj.isValid()) {
            this.lineObj = null;
        } else if (this.lineObj == null && (lineCookie = (LineCookie)this.dobj.getCookie(LineCookie.class)) != null) {
            Line.Set lineSet = lineCookie.getLineSet();
            try {
                this.lineObj = lineSet.getOriginal(this.line - 1);
            }
            catch (IndexOutOfBoundsException ioobex) {
                this.lineObj = lineSet.getOriginal(TextDetail.findMaxLine(lineSet));
                this.markLength = 0;
                this.column = 0;
            }
        }
    }

    private static int findMaxLine(Line.Set set) {
        int from = 0;
        int to = 32000;
        try {
            while (true) {
                set.getOriginal(to);
                from = to;
                to *= 2;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            while (from < to) {
                int middle = (from + to + 1) / 2;
                try {
                    set.getOriginal(middle);
                    from = middle;
                }
                catch (IndexOutOfBoundsException ex2) {
                    to = middle - 1;
                }
            }
            return from;
        }
    }

    private static class GotoDetailAction
    extends NodeAction {
        private GotoDetailAction() {
        }

        public String getName() {
            return NbBundle.getBundle(GotoDetailAction.class).getString("LBL_GotoDetailAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(GotoDetailAction.class);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes != null && activatedNodes.length != 0 && activatedNodes[0] instanceof DetailNode;
        }

        protected void performAction(Node[] activatedNodes) {
            if (this.enable(activatedNodes)) {
                ((DetailNode)activatedNodes[0]).gotoDetail();
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    static final class DetailNode
    extends AbstractNode
    implements OutputListener {
        private TextDetail txtDetail;

        public DetailNode(TextDetail txtDetail) {
            super(Children.LEAF);
            this.txtDetail = txtDetail;
            this.setShortDescription(DetailNode.getShortDesc(txtDetail));
            this.setValue("output line", DetailNode.getFullDesc(txtDetail));
            txtDetail.prepareLine();
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                return new Action[]{this.getPreferredAction()};
            }
            return new Action[0];
        }

        public Action getPreferredAction() {
            return SystemAction.get(GotoDetailAction.class);
        }

        public boolean equals(Object anotherObj) {
            return anotherObj != null && anotherObj.getClass() == DetailNode.class && ((DetailNode)((Object)anotherObj)).txtDetail.equals(this.txtDetail);
        }

        public int hashCode() {
            return this.txtDetail.hashCode() + 1;
        }

        public String getName() {
            return this.txtDetail.getLineText() + "      [" + DetailNode.getName(this.txtDetail) + "]";
        }

        public String getHtmlDisplayName() {
            try {
                StringBuffer text = new StringBuffer();
                if (this.canBeMarked()) {
                    this.appendMarkedText(text);
                } else {
                    text.append(DetailNode.escape(this.txtDetail.getLineText()));
                }
                text.append("      ");
                text.append("<font color='!controlShadow'>[");
                text.append(DetailNode.escape(DetailNode.getName(this.txtDetail)));
                text.append("]");
                return text.toString();
            }
            catch (CharConversionException e) {
                return null;
            }
        }

        private boolean canBeMarked() {
            int col0 = this.txtDetail.getColumn0();
            return this.txtDetail.getMarkLength() > 0 && col0 > -1 && col0 < this.txtDetail.getLineTextLength();
        }

        private void appendMarkedText(StringBuffer text) throws CharConversionException {
            int col0 = this.txtDetail.getColumn0();
            int end = col0 + Math.min(this.txtDetail.getMarkLength(), this.txtDetail.getLineTextLength() - col0);
            int markEnd = col0 + this.txtDetail.getMarkLength();
            int detailLen = this.txtDetail.getLineTextLength();
            text.append(DetailNode.escape(this.txtDetail.getLineTextPart(0, col0)));
            text.append("<b>");
            if (markEnd > detailLen) {
                text.append(DetailNode.escape(this.txtDetail.getLineTextPart(col0, end)));
                text.append(" ...");
            } else {
                text.append(DetailNode.escape(this.txtDetail.getLineTextPart(col0, end)));
            }
            text.append("</b>");
            if (detailLen > end) {
                text.append(DetailNode.escape(this.txtDetail.getLineTextPart(end)));
            }
        }

        private static String escape(String s) throws CharConversionException {
            return XMLUtil.toElementContent((String)s);
        }

        void gotoDetail() {
            this.txtDetail.showDetail(2);
        }

        private void showDetail() {
            this.txtDetail.showDetail(1);
        }

        public void outputLineSelected(OutputEvent evt) {
            this.txtDetail.showDetail(1);
        }

        public void outputLineAction(OutputEvent evt) {
            this.txtDetail.showDetail(2);
        }

        public void outputLineCleared(OutputEvent evt) {
            this.txtDetail.showDetail(3);
        }

        private static String getName(TextDetail det) {
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME1", (Object)Integer.toString(line), (Object)Integer.toString(col));
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME2", (Object)Integer.toString(line));
        }

        private static String getShortDesc(TextDetail det) {
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT1", (Object[])new Object[]{Integer.toString(line), Integer.toString(col)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT2", (Object)Integer.toString(line));
        }

        private static String getFullDesc(TextDetail det) {
            String filename = det.getDataObject().getPrimaryFile().getNameExt();
            String lineText = det.getLineText();
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL1", (Object[])new Object[]{lineText, filename, Integer.toString(line), Integer.toString(col)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL2", (Object[])new Object[]{lineText, filename, Integer.toString(line)});
        }
    }
}

