/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.MarkOccurrencesHighlighter;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CaretAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class MarkOccurrencesHighlighterFactory
extends CaretAwareCsmFileTaskFactory {
    protected CsmFileTaskFactory.PhaseRunner createTask(FileObject fo) {
        Object ph = null;
        if (MarkOccurrencesHighlighterFactory.enabled()) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                StyledDocument doc = ec.getDocument();
                if (doc != null) {
                    ph = new MarkOccurrencesHighlighter(doc);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return ph != null ? ph : new CsmFileTaskFactory.PhaseRunner(){
            private boolean valid = true;

            public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
                this.valid = !MarkOccurrencesHighlighterFactory.enabled();
            }

            public boolean isValid() {
                return this.valid;
            }

            public void cancel() {
                this.valid = !MarkOccurrencesHighlighterFactory.enabled();
            }

            public boolean isHighPriority() {
                return false;
            }
        };
    }

    private static boolean enabled() {
        return SemanticHighlightingOptions.instance().getEnableMarkOccurrences() && !HighlighterBase.MINIMAL;
    }

    protected int taskDelay() {
        return ModelUtils.OCCURRENCES_DELAY;
    }

    protected int rescheduleDelay() {
        return ModelUtils.RESCHEDULE_OCCURRENCES_DELAY;
    }
}

