/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring.rename;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.jpa.refactoring.PersistenceXmlRefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.jpa.refactoring.rename.PersistenceXmlRename;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PersistenceXmlPackageRename
extends PersistenceXmlRefactoring {
    private final RenameRefactoring renameRefactoring;

    public PersistenceXmlPackageRename(RenameRefactoring renameRefactoring) {
        this.renameRefactoring = renameRefactoring;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.renameRefactoring;
    }

    @Override
    protected boolean shouldHandle() {
        return true;
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.isPackage()) {
            FileObject fileObject = ((NonRecursiveFolder)this.renameRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder();
            String string = JavaIdentifiers.getQualifiedName((FileObject)fileObject);
            return this.doPrepare(refactoringElementsBag, fileObject, string, this.renameRefactoring.getNewName());
        }
        if (this.isFolder()) {
            FileObject fileObject = (FileObject)this.renameRefactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null) {
                return null;
            }
            FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
            if (fileObject2 == null) {
                return null;
            }
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent()).replace('/', '.');
            String string2 = this.buildName(string, fileObject.getName());
            String string3 = this.buildName(string, this.renameRefactoring.getNewName());
            return this.doPrepare(refactoringElementsBag, fileObject, string2, string3);
        }
        return null;
    }

    private boolean isPackage() {
        return this.renameRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null;
    }

    private boolean isFolder() {
        FileObject fileObject = (FileObject)this.renameRefactoring.getRefactoringSource().lookup(FileObject.class);
        return fileObject != null && fileObject.isFolder();
    }

    private Problem doPrepare(RefactoringElementsBag refactoringElementsBag, FileObject fileObject, String string, String string2) {
        Problem problem = null;
        for (FileObject fileObject2 : this.getPersistenceXmls(fileObject)) {
            try {
                PUDataObject pUDataObject = ProviderUtil.getPUDataObject((FileObject)fileObject2);
                for (String string3 : this.getClasses(fileObject, new ArrayList<String>())) {
                    List<PersistenceUnit> list = this.getAffectedPersistenceUnits(pUDataObject, string3);
                    String string4 = string3.replace(string, string2);
                    for (PersistenceUnit persistenceUnit : list) {
                        refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new PersistenceXmlPackageRenameRefactoringElement(persistenceUnit, string3, string4, pUDataObject, fileObject2));
                    }
                }
            }
            catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
                Problem problem2 = new Problem(false, NbBundle.getMessage(PersistenceXmlRefactoring.class, (String)"TXT_PersistenceXmlInvalidProblem", (Object)invalidPersistenceXmlException.getPath()));
                problem = RefactoringUtil.addToEnd(problem2, problem);
            }
        }
        return problem;
    }

    private String buildName(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        return string + "." + string2;
    }

    private List<String> getClasses(FileObject fileObject, List<String> list) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (fileObject2.isFolder()) {
                this.getClasses(fileObject2, list);
                continue;
            }
            list.add(JavaIdentifiers.getQualifiedName((FileObject)fileObject2));
        }
        return list;
    }

    @Override
    protected RefactoringElementImplementation getRefactoringElement(PersistenceUnit persistenceUnit, FileObject fileObject, PUDataObject pUDataObject, FileObject fileObject2) {
        return null;
    }

    private static class PersistenceXmlPackageRenameRefactoringElement
    extends PersistenceXmlRefactoring.PersistenceXmlRefactoringElement {
        private final String newName;

        public PersistenceXmlPackageRenameRefactoringElement(PersistenceUnit persistenceUnit, String string, String string2, PUDataObject pUDataObject, FileObject fileObject) {
            super(persistenceUnit, string, pUDataObject, fileObject);
            this.newName = string2;
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.parentFile.getNameExt(), this.clazz, this.newName};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlRename.class, (String)"TXT_PersistenceXmlRename"), objectArray);
        }

        public void undoChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.clazz, (String)this.newName, (PUDataObject)this.puDataObject);
        }

        public void performChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.newName, (String)this.clazz, (PUDataObject)this.puDataObject);
        }
    }
}

