/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Annotation;
import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class ExtendedAnnotation {
    public final Annotation annotation;
    public final Position position;

    ExtendedAnnotation(ClassReader cr) throws IOException, Annotation.InvalidAnnotation {
        this.annotation = new Annotation(cr);
        this.position = ExtendedAnnotation.read_position(cr);
    }

    public ExtendedAnnotation(ConstantPool constant_pool, Annotation annotation, Position position) {
        this.annotation = annotation;
        this.position = position;
    }

    public int length() {
        int n = this.annotation.length();
        return n += ExtendedAnnotation.position_length(this.position);
    }

    private static Position read_position(ClassReader cr) throws IOException, Annotation.InvalidAnnotation {
        byte tag = (byte)cr.readUnsignedByte();
        if (!TargetType.isValidTargetTypeValue(tag)) {
            throw new Annotation.InvalidAnnotation("invalid type annotation target type value: " + tag);
        }
        TargetType type = TargetType.fromTargetTypeValue(tag);
        Position position = new Position();
        position.type = type;
        switch (type) {
            case TYPECAST: 
            case TYPECAST_GENERIC_OR_ARRAY: 
            case INSTANCEOF: 
            case INSTANCEOF_GENERIC_OR_ARRAY: 
            case NEW: 
            case NEW_GENERIC_OR_ARRAY: {
                position.offset = cr.readUnsignedShort();
                break;
            }
            case LOCAL_VARIABLE: 
            case LOCAL_VARIABLE_GENERIC_OR_ARRAY: {
                int table_length = cr.readUnsignedShort();
                position.lvarOffset = new int[table_length];
                position.lvarLength = new int[table_length];
                position.lvarIndex = new int[table_length];
                for (int i = 0; i < table_length; ++i) {
                    position.lvarOffset[i] = cr.readUnsignedShort();
                    position.lvarLength[i] = cr.readUnsignedShort();
                    position.lvarIndex[i] = cr.readUnsignedShort();
                }
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                position.parameter_index = cr.readUnsignedByte();
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case CLASS_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: 
            case METHOD_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: {
                position.parameter_index = cr.readUnsignedByte();
                position.bound_index = cr.readUnsignedByte();
                break;
            }
            case WILDCARD_BOUND: 
            case WILDCARD_BOUND_GENERIC_OR_ARRAY: {
                position.wildcard_position = ExtendedAnnotation.read_position(cr);
                break;
            }
            case CLASS_EXTENDS: 
            case CLASS_EXTENDS_GENERIC_OR_ARRAY: {
                position.type_index = cr.readUnsignedByte();
                break;
            }
            case THROWS: {
                position.type_index = cr.readUnsignedByte();
                break;
            }
            case CLASS_LITERAL: 
            case CLASS_LITERAL_GENERIC_OR_ARRAY: {
                position.offset = cr.readUnsignedShort();
                break;
            }
            case METHOD_PARAMETER_GENERIC_OR_ARRAY: {
                position.parameter_index = cr.readUnsignedByte();
                break;
            }
            case NEW_TYPE_ARGUMENT: 
            case NEW_TYPE_ARGUMENT_GENERIC_OR_ARRAY: 
            case METHOD_TYPE_ARGUMENT: 
            case METHOD_TYPE_ARGUMENT_GENERIC_OR_ARRAY: {
                position.offset = cr.readUnsignedShort();
                position.type_index = cr.readUnsignedByte();
                break;
            }
            case METHOD_RETURN_GENERIC_OR_ARRAY: 
            case FIELD_GENERIC_OR_ARRAY: {
                break;
            }
            case UNKNOWN: {
                break;
            }
            default: {
                throw new AssertionError((Object)"Cannot be here");
            }
        }
        if (type.hasLocation()) {
            int len = cr.readUnsignedShort();
            ArrayList<Integer> loc = new ArrayList<Integer>(len);
            for (int i = 0; i < len; ++i) {
                loc.add(cr.readUnsignedByte());
            }
            position.location = loc;
        }
        return position;
    }

    private static int position_length(Position pos) {
        int n = 0;
        ++n;
        switch (pos.type) {
            case TYPECAST: 
            case TYPECAST_GENERIC_OR_ARRAY: 
            case INSTANCEOF: 
            case INSTANCEOF_GENERIC_OR_ARRAY: 
            case NEW: 
            case NEW_GENERIC_OR_ARRAY: {
                n += 2;
                break;
            }
            case LOCAL_VARIABLE: 
            case LOCAL_VARIABLE_GENERIC_OR_ARRAY: {
                n += 2;
                int table_length = pos.lvarOffset.length;
                n += 2 * table_length;
                n += 2 * table_length;
                n += 2 * table_length;
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                ++n;
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case CLASS_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: 
            case METHOD_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: {
                ++n;
                ++n;
                break;
            }
            case WILDCARD_BOUND: 
            case WILDCARD_BOUND_GENERIC_OR_ARRAY: {
                n += ExtendedAnnotation.position_length(pos.wildcard_position);
                break;
            }
            case CLASS_EXTENDS: 
            case CLASS_EXTENDS_GENERIC_OR_ARRAY: {
                ++n;
                break;
            }
            case THROWS: {
                ++n;
                break;
            }
            case CLASS_LITERAL: 
            case CLASS_LITERAL_GENERIC_OR_ARRAY: {
                ++n;
                break;
            }
            case METHOD_PARAMETER_GENERIC_OR_ARRAY: {
                ++n;
                break;
            }
            case NEW_TYPE_ARGUMENT: 
            case NEW_TYPE_ARGUMENT_GENERIC_OR_ARRAY: 
            case METHOD_TYPE_ARGUMENT: 
            case METHOD_TYPE_ARGUMENT_GENERIC_OR_ARRAY: {
                n += 2;
                ++n;
                break;
            }
            case METHOD_RETURN_GENERIC_OR_ARRAY: 
            case FIELD_GENERIC_OR_ARRAY: {
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        if (pos.type.hasLocation()) {
            n += 2;
            n += 1 * pos.location.size();
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TargetAttribute {
        HasLocation,
        HasParameter,
        HasBound;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TargetType {
        TYPECAST(0, new TargetAttribute[0]),
        TYPECAST_GENERIC_OR_ARRAY(1, TargetAttribute.HasLocation),
        INSTANCEOF(2, new TargetAttribute[0]),
        INSTANCEOF_GENERIC_OR_ARRAY(3, TargetAttribute.HasLocation),
        NEW(4, new TargetAttribute[0]),
        NEW_GENERIC_OR_ARRAY(5, TargetAttribute.HasLocation),
        METHOD_RECEIVER(6, new TargetAttribute[0]),
        LOCAL_VARIABLE(8, new TargetAttribute[0]),
        LOCAL_VARIABLE_GENERIC_OR_ARRAY(9, TargetAttribute.HasLocation),
        METHOD_RETURN_GENERIC_OR_ARRAY(11, TargetAttribute.HasLocation),
        METHOD_PARAMETER_GENERIC_OR_ARRAY(13, TargetAttribute.HasLocation),
        FIELD_GENERIC_OR_ARRAY(15, TargetAttribute.HasLocation),
        CLASS_TYPE_PARAMETER_BOUND(16, TargetAttribute.HasBound, TargetAttribute.HasParameter),
        CLASS_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY(17, TargetAttribute.HasBound, TargetAttribute.HasLocation, TargetAttribute.HasParameter),
        METHOD_TYPE_PARAMETER_BOUND(18, TargetAttribute.HasBound, TargetAttribute.HasParameter),
        METHOD_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY(19, TargetAttribute.HasBound, TargetAttribute.HasLocation, TargetAttribute.HasParameter),
        CLASS_EXTENDS(20, new TargetAttribute[0]),
        CLASS_EXTENDS_GENERIC_OR_ARRAY(21, TargetAttribute.HasLocation),
        THROWS(22, new TargetAttribute[0]),
        NEW_TYPE_ARGUMENT(24, new TargetAttribute[0]),
        NEW_TYPE_ARGUMENT_GENERIC_OR_ARRAY(25, TargetAttribute.HasLocation),
        METHOD_TYPE_ARGUMENT(26, new TargetAttribute[0]),
        METHOD_TYPE_ARGUMENT_GENERIC_OR_ARRAY(27, TargetAttribute.HasLocation),
        WILDCARD_BOUND(28, TargetAttribute.HasBound),
        WILDCARD_BOUND_GENERIC_OR_ARRAY(29, TargetAttribute.HasBound, TargetAttribute.HasLocation),
        CLASS_LITERAL(30, new TargetAttribute[0]),
        CLASS_LITERAL_GENERIC_OR_ARRAY(31, TargetAttribute.HasLocation),
        METHOD_TYPE_PARAMETER(32, TargetAttribute.HasParameter),
        CLASS_TYPE_PARAMETER(34, TargetAttribute.HasParameter),
        UNKNOWN(-1, new TargetAttribute[0]);

        static final int MAXIMUM_TARGET_TYPE_VALUE = 34;
        private final int targetTypeValue;
        private Set<TargetAttribute> flags;
        private static TargetType[] targets;

        private TargetType(int targetTypeValue, TargetAttribute ... attrs) {
            if (targetTypeValue < -128 || targetTypeValue > 127) {
                throw new AssertionError((Object)("attribute type value needs to be a byte: " + targetTypeValue));
            }
            this.targetTypeValue = (byte)targetTypeValue;
            this.flags = EnumSet.noneOf(TargetAttribute.class);
            for (TargetAttribute attr : attrs) {
                this.flags.add(attr);
            }
        }

        public boolean hasLocation() {
            return this.flags.contains((Object)TargetAttribute.HasLocation);
        }

        public TargetType getGenericComplement() {
            if (this.hasLocation()) {
                return this;
            }
            return TargetType.fromTargetTypeValue(this.targetTypeValue() + 1);
        }

        public boolean hasParameter() {
            return this.flags.contains((Object)TargetAttribute.HasParameter);
        }

        public boolean hasBound() {
            return this.flags.contains((Object)TargetAttribute.HasBound);
        }

        public int targetTypeValue() {
            return this.targetTypeValue;
        }

        private static TargetType[] buildTargets() {
            TargetType[] alltargets;
            TargetType[] targets = new TargetType[35];
            for (TargetType target : alltargets = TargetType.values()) {
                if (target.targetTypeValue < 0) continue;
                targets[target.targetTypeValue] = target;
            }
            for (int i = 0; i <= 34; ++i) {
                if (targets[i] != null) continue;
                targets[i] = UNKNOWN;
            }
            return targets;
        }

        public static boolean isValidTargetTypeValue(int tag) {
            if (targets == null) {
                targets = TargetType.buildTargets();
            }
            if ((byte)tag == (byte)TargetType.UNKNOWN.targetTypeValue) {
                return true;
            }
            return tag >= 0 && tag < targets.length;
        }

        public static TargetType fromTargetTypeValue(int tag) {
            if (targets == null) {
                targets = TargetType.buildTargets();
            }
            if ((byte)tag == (byte)TargetType.UNKNOWN.targetTypeValue) {
                return UNKNOWN;
            }
            if (tag < 0 || tag >= targets.length) {
                throw new IllegalArgumentException("Unknown TargetType: " + tag);
            }
            return targets[tag];
        }

        static {
            targets = null;
        }
    }

    public static class Position {
        public TargetType type = TargetType.UNKNOWN;
        public List<Integer> location = new ArrayList<Integer>();
        public int offset = -1;
        public int[] lvarOffset = new int[]{-1};
        public int[] lvarLength = new int[]{-1};
        public int[] lvarIndex = new int[]{-1};
        public int bound_index = -1;
        public int parameter_index = -1;
        public int type_index = -2;
        public Position wildcard_position = null;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append((Object)this.type);
            switch (this.type) {
                case TYPECAST: 
                case TYPECAST_GENERIC_OR_ARRAY: 
                case INSTANCEOF: 
                case INSTANCEOF_GENERIC_OR_ARRAY: 
                case NEW: 
                case NEW_GENERIC_OR_ARRAY: 
                case NEW_TYPE_ARGUMENT: 
                case NEW_TYPE_ARGUMENT_GENERIC_OR_ARRAY: {
                    sb.append(", offset = ");
                    sb.append(this.offset);
                    break;
                }
                case LOCAL_VARIABLE: 
                case LOCAL_VARIABLE_GENERIC_OR_ARRAY: {
                    sb.append(", {");
                    for (int i = 0; i < this.lvarOffset.length; ++i) {
                        if (i != 0) {
                            sb.append("; ");
                        }
                        sb.append(", start_pc = ");
                        sb.append(this.lvarOffset[i]);
                        sb.append(", length = ");
                        sb.append(this.lvarLength[i]);
                        sb.append(", index = ");
                        sb.append(this.lvarIndex[i]);
                    }
                    sb.append("}");
                    break;
                }
                case METHOD_RECEIVER: {
                    break;
                }
                case CLASS_TYPE_PARAMETER: 
                case METHOD_TYPE_PARAMETER: {
                    sb.append(", param_index = ");
                    sb.append(this.parameter_index);
                    break;
                }
                case CLASS_TYPE_PARAMETER_BOUND: 
                case CLASS_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: 
                case METHOD_TYPE_PARAMETER_BOUND: 
                case METHOD_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: {
                    sb.append(", param_index = ");
                    sb.append(this.parameter_index);
                    sb.append(", bound_index = ");
                    sb.append(this.bound_index);
                    break;
                }
                case WILDCARD_BOUND: 
                case WILDCARD_BOUND_GENERIC_OR_ARRAY: {
                    sb.append(", wild_card = ");
                    sb.append(this.wildcard_position);
                    break;
                }
                case CLASS_EXTENDS: 
                case CLASS_EXTENDS_GENERIC_OR_ARRAY: {
                    sb.append(", type_index = ");
                    sb.append(this.type_index);
                    break;
                }
                case THROWS: {
                    sb.append(", type_index = ");
                    sb.append(this.type_index);
                    break;
                }
                case CLASS_LITERAL: 
                case CLASS_LITERAL_GENERIC_OR_ARRAY: {
                    sb.append(", offset = ");
                    sb.append(this.offset);
                    break;
                }
                case METHOD_PARAMETER_GENERIC_OR_ARRAY: {
                    sb.append(", param_index = ");
                    sb.append(this.parameter_index);
                    break;
                }
                case METHOD_TYPE_ARGUMENT: 
                case METHOD_TYPE_ARGUMENT_GENERIC_OR_ARRAY: {
                    sb.append(", offset = ");
                    sb.append(this.offset);
                    sb.append(", type_index = ");
                    sb.append(this.type_index);
                    break;
                }
                case METHOD_RETURN_GENERIC_OR_ARRAY: 
                case FIELD_GENERIC_OR_ARRAY: {
                    break;
                }
                case UNKNOWN: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown type: " + (Object)((Object)this.type)));
                }
            }
            if (this.type.hasLocation()) {
                sb.append(", location = (");
                sb.append(this.location);
                sb.append(")");
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

