/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.util.List;

public class TypeAnnotationPosition {
    public TargetType type = TargetType.UNKNOWN;
    public List<Integer> location = List.nil();
    public int pos = -1;
    public boolean isValidOffset = false;
    public int offset = -1;
    public int[] lvarOffset = new int[]{-1};
    public int[] lvarLength = new int[]{-1};
    public int[] lvarIndex = new int[]{-1};
    public int bound_index = -1;
    public int parameter_index = -1;
    public int type_index = -2;
    public TypeAnnotationPosition wildcard_position = null;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append((Object)this.type);
        switch (this.type) {
            case TYPECAST: 
            case TYPECAST_GENERIC_OR_ARRAY: 
            case INSTANCEOF: 
            case INSTANCEOF_GENERIC_OR_ARRAY: 
            case NEW: 
            case NEW_GENERIC_OR_ARRAY: 
            case NEW_TYPE_ARGUMENT: 
            case NEW_TYPE_ARGUMENT_GENERIC_OR_ARRAY: {
                sb.append(", offset = ");
                sb.append(this.offset);
                break;
            }
            case LOCAL_VARIABLE: 
            case LOCAL_VARIABLE_GENERIC_OR_ARRAY: {
                sb.append(", {");
                for (int i = 0; i < this.lvarOffset.length; ++i) {
                    if (i != 0) {
                        sb.append("; ");
                    }
                    sb.append(", start_pc = ");
                    sb.append(this.lvarOffset[i]);
                    sb.append(", length = ");
                    sb.append(this.lvarLength[i]);
                    sb.append(", index = ");
                    sb.append(this.lvarIndex[i]);
                }
                sb.append("}");
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                sb.append(", param_index = ");
                sb.append(this.parameter_index);
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case CLASS_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: 
            case METHOD_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: {
                sb.append(", param_index = ");
                sb.append(this.parameter_index);
                sb.append(", bound_index = ");
                sb.append(this.bound_index);
                break;
            }
            case WILDCARD_BOUND: 
            case WILDCARD_BOUND_GENERIC_OR_ARRAY: {
                sb.append(", wild_card = ");
                sb.append(this.wildcard_position);
                break;
            }
            case CLASS_EXTENDS: 
            case CLASS_EXTENDS_GENERIC_OR_ARRAY: {
                sb.append(", type_index = ");
                sb.append(this.type_index);
                break;
            }
            case THROWS: {
                sb.append(", type_index = ");
                sb.append(this.type_index);
                break;
            }
            case CLASS_LITERAL: {
                sb.append(", offset = ");
                sb.append(this.offset);
                break;
            }
            case METHOD_PARAMETER_GENERIC_OR_ARRAY: {
                sb.append(", param_index = ");
                sb.append(this.parameter_index);
                break;
            }
            case METHOD_TYPE_ARGUMENT: 
            case METHOD_TYPE_ARGUMENT_GENERIC_OR_ARRAY: {
                sb.append(", offset = ");
                sb.append(this.offset);
                sb.append(", type_index = ");
                sb.append(this.type_index);
                break;
            }
            case METHOD_RETURN_GENERIC_OR_ARRAY: 
            case FIELD_GENERIC_OR_ARRAY: {
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        if (this.type.hasLocation()) {
            sb.append(", location = (");
            sb.append(this.location);
            sb.append(")");
        }
        sb.append(", pos = ");
        sb.append(this.pos);
        sb.append(']');
        return sb.toString();
    }

    public boolean emitToClassfile() {
        if (this.type == TargetType.WILDCARD_BOUND || this.type == TargetType.WILDCARD_BOUND_GENERIC_OR_ARRAY) {
            return this.wildcard_position.isValidOffset;
        }
        return !this.type.isLocal() || this.isValidOffset;
    }
}

