/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.fsm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProgram;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.openide.util.Exceptions;

public class ProgramImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmProgram,
CsmFunctionDefinition,
Disposable,
RawNamable {
    private final CharSequence name;
    private final CharSequence[] rawName;
    private CsmUID<CsmScope> scopeUID;

    public ProgramImpl(String string, CsmFile csmFile, int n, int n2, CsmType csmType, CsmScope csmScope) {
        super(csmFile, n, n2);
        this.name = QualifiedNameCache.getManager().getString((CharSequence)string);
        this.rawName = new CharSequence[1];
        this.rawName[0] = this.name;
        try {
            this._setScope(csmScope);
        }
        catch (AstRendererException astRendererException) {
            Exceptions.printStackTrace((Throwable)astRendererException);
        }
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    public CharSequence getQualifiedName() {
        return this.name;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    public CharSequence getDeclarationText() {
        return this.name;
    }

    public CsmFunctionDefinition getDefinition() {
        return this;
    }

    public CsmFunction getDeclaration() {
        return this;
    }

    public boolean isOperator() {
        return false;
    }

    public CsmFunction.OperatorKind getOperatorKind() {
        return CsmFunction.OperatorKind.NONE;
    }

    public boolean isInline() {
        return false;
    }

    public CsmType getReturnType() {
        return TypeFactory.createBuiltinType("int", null, 0, null, this.getContainingFile());
    }

    public CsmFunctionParameterList getParameterList() {
        return null;
    }

    public Collection<CsmParameter> getParameters() {
        return Collections.emptyList();
    }

    public CharSequence getSignature() {
        return "";
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return Collections.emptyList();
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    private void _setScope(CsmScope csmScope) throws AstRendererException {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        }
    }

    private synchronized CsmScope _getScope() {
        CsmScope csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        return csmScope;
    }

    public CsmCompoundStatement getBody() {
        return null;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        uIDObjectFactory.writeUID(this.scopeUID, dataOutput);
    }

    public ProgramImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.name != null);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.scopeUID = uIDObjectFactory.readUID(dataInput);
    }
}

