/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.antlr.debug.misc.JTreeASTModel;
import org.netbeans.modules.cnd.modelimpl.trace.TraceUtils;

public class ASTFrameEx
extends JFrame {
    JTree tree;
    JTextArea text;

    private void displayText(String string) {
        this.text.setText(string);
    }

    private void appendText(String string) {
        this.text.setText(this.text.getText() + string);
    }

    public ASTFrameEx(String string, AST aST) {
        super(string);
        JTreeASTModel jTreeASTModel = new JTreeASTModel(aST);
        this.tree = new JTree((TreeModel)jTreeASTModel);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        MyTreeSelectionListener myTreeSelectionListener = new MyTreeSelectionListener();
        this.tree.addTreeSelectionListener(myTreeSelectionListener);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.text = new JTextArea(){

            @Override
            public Insets getInsets() {
                return new Insets(6, 6, 6, 6);
            }
        };
        this.text.setEditable(false);
        this.text.setTabSize(4);
        JScrollPane jScrollPane2 = new JScrollPane(this.text);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(jScrollPane2);
        jSplitPane.setDividerSize(2);
        jSplitPane.setResizeWeight(0.6);
        container.add((Component)jSplitPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Frame frame = (Frame)windowEvent.getSource();
                frame.setVisible(false);
                frame.dispose();
            }
        });
        this.setSize(320, 480);
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            AST aST = (AST)treePath.getLastPathComponent();
            ASTFrameEx.this.displayText("name:\t" + aST.getText());
            ASTFrameEx.this.appendText("\ntype:\t" + TraceUtils.getTokenTypeName(aST));
            ASTFrameEx.this.appendText("\npos:\t" + aST.getLine() + ':' + aST.getColumn());
        }
    }
}

