/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.jackpot.impl.JavaFixImpl;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.impl.pm.Pattern;
import org.netbeans.modules.java.hints.jackpot.spi.Hacks;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;

public abstract class JavaFix {
    private final TreePathHandle handle;
    private static java.util.regex.Pattern SPEC_VERSION = java.util.regex.Pattern.compile("[0-9]+(\\.[0-9]+)+");
    private static final Map<Tree.Kind, Integer> OPERATOR_PRIORITIES = new EnumMap<Tree.Kind, Integer>(Tree.Kind.class);

    protected JavaFix(CompilationInfo compilationInfo, TreePath treePath) {
        this.handle = TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo);
    }

    protected abstract String getText();

    protected abstract void performRewrite(WorkingCopy var1, TreePath var2, UpgradeUICallback var3);

    final ChangeInfo process(WorkingCopy workingCopy, UpgradeUICallback upgradeUICallback) throws Exception {
        TreePath treePath = this.handle.resolve((CompilationInfo)workingCopy);
        if (treePath == null) {
            Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", this.handle);
            return null;
        }
        this.performRewrite(workingCopy, treePath, upgradeUICallback);
        return null;
    }

    final FileObject getFile() {
        return this.handle.getFileObject();
    }

    public static Fix rewriteFix(HintContext hintContext, String string, TreePath treePath, String string2, String ... stringArray) {
        return JavaFix.rewriteFix(hintContext, string, treePath, string2, Collections.<String, TypeMirror>emptyMap(), stringArray);
    }

    public static Fix rewriteFix(HintContext hintContext, String string, TreePath treePath, String string2, Map<String, TypeMirror> map, String ... stringArray) {
        return JavaFix.rewriteFix(hintContext.getInfo(), string, treePath, string2, hintContext.getVariables(), hintContext.getMultiVariables(), hintContext.getVariableNames(), map, stringArray);
    }

    public static Fix rewriteFix(CompilationInfo compilationInfo, String string, TreePath treePath, String string2, Map<String, TreePath> map, Map<String, Collection<? extends TreePath>> map2, Map<String, String> map3, Map<String, TypeMirror> map4, String ... stringArray) {
        HashMap<String, TreePathHandle> hashMap2 = new HashMap<String, TreePathHandle>();
        for (Map.Entry<String, TreePath> hashMap3 : map.entrySet()) {
            hashMap2.put(hashMap3.getKey(), TreePathHandle.create((TreePath)hashMap3.getValue(), (CompilationInfo)compilationInfo));
        }
        HashMap hashMap4 = new HashMap();
        for (Map.Entry<String, Collection<? extends TreePath>> entry : map2.entrySet()) {
            LinkedList<TreePathHandle> linkedList = new LinkedList<TreePathHandle>();
            for (TreePath treePath2 : entry.getValue()) {
                linkedList.add(TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo));
            }
            hashMap4.put(entry.getKey(), linkedList);
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, TypeMirror> entry : map4.entrySet()) {
            hashMap.put(entry.getKey(), TypeMirrorHandle.create((TypeMirror)entry.getValue()));
        }
        if (string == null) {
            string = JavaFix.defaultFixDisplayName(compilationInfo, map, string2);
        }
        return JavaFix.toEditorFix(new JavaFixRealImpl(compilationInfo, treePath, string, string2, hashMap2, hashMap4, map3, hashMap, Arrays.asList(stringArray)));
    }

    private static boolean isFakeBlock(Tree tree) {
        if (!(tree instanceof BlockTree)) {
            return false;
        }
        BlockTree blockTree = (BlockTree)tree;
        if (blockTree.getStatements().isEmpty()) {
            return false;
        }
        CharSequence charSequence = Utilities.getWildcardTreeName(blockTree.getStatements().get(0));
        if (charSequence == null) {
            return false;
        }
        return ((Object)charSequence).toString().startsWith("$$");
    }

    private static boolean isFakeClass(Tree tree) {
        if (!(tree instanceof ClassTree)) {
            return false;
        }
        ClassTree classTree = (ClassTree)tree;
        if (classTree.getMembers().isEmpty()) {
            return false;
        }
        CharSequence charSequence = Utilities.getWildcardTreeName(classTree.getMembers().get(0));
        if (charSequence == null) {
            return false;
        }
        return ((Object)charSequence).toString().startsWith("$$");
    }

    private static String defaultFixDisplayName(CompilationInfo compilationInfo, Map<String, TreePath> map, String string) {
        Object object;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, TreePath> entry : map.entrySet()) {
            object2 = entry.getValue().getLeaf();
            object = compilationInfo.getTrees().getSourcePositions();
            int n = (int)object.getStartPosition(compilationInfo.getCompilationUnit(), (Tree)object2);
            int n2 = (int)object.getEndPosition(compilationInfo.getCompilationUnit(), (Tree)object2);
            if (n >= 0 && n2 >= 0) {
                hashMap.put(entry.getKey(), compilationInfo.getText().substring(n, n2));
                continue;
            }
            hashMap.put(entry.getKey(), "");
        }
        if (!hashMap.containsKey("$this")) {
            hashMap.put("$this", "this");
        }
        for (Map.Entry<String, TreePath> entry : hashMap.entrySet()) {
            object2 = java.util.regex.Pattern.quote(entry.getKey());
            object = Matcher.quoteReplacement((String)((Object)entry.getValue()));
            string = string.replaceAll((String)object2, (String)object);
        }
        return "Rewrite to " + string;
    }

    private static void checkDependency(WorkingCopy workingCopy, Element element, UpgradeUICallback upgradeUICallback) {
        SpecificationVersion specificationVersion = JavaFix.computeSpecVersion((CompilationInfo)workingCopy, element);
        while (specificationVersion == null && element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
            specificationVersion = JavaFix.computeSpecVersion((CompilationInfo)workingCopy, element);
        }
        if (specificationVersion == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)workingCopy.getFileObject());
        if (project == null) {
            return;
        }
        FileObject fileObject = JavaFix.getFile(workingCopy, element);
        if (fileObject == null) {
            return;
        }
        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project2 == null || project.getProjectDirectory().equals(project2.getProjectDirectory())) {
            return;
        }
        JavaFix.resolveNbModuleDependencies(project, project2, specificationVersion, upgradeUICallback);
    }

    public static SpecificationVersion computeSpecVersion(CompilationInfo compilationInfo, Element element) {
        Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
        if (doc == null) {
            return null;
        }
        for (Tag tag : doc.tags("@since")) {
            String string = tag.text();
            Matcher matcher = SPEC_VERSION.matcher(string);
            if (!matcher.find()) continue;
            return new SpecificationVersion(matcher.group());
        }
        return null;
    }

    public static Fix toEditorFix(JavaFix javaFix) {
        return new JavaFixImpl(javaFix);
    }

    private static void resolveNbModuleDependencies(Project project, Project project2, SpecificationVersion specificationVersion, UpgradeUICallback upgradeUICallback) throws IllegalArgumentException {
    }

    private static FileObject getFile(WorkingCopy workingCopy, Element element) {
        return SourceUtils.getFile((Element)element, (ClasspathInfo)workingCopy.getClasspathInfo());
    }

    private static boolean isStaticElement(Element element) {
        if (element == null) {
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return element.getKind().isClass() || element.getKind().isInterface();
        }
        if (element.getKind().isClass() || element.getKind().isInterface()) {
            return element.getEnclosingElement().getKind() == ElementKind.PACKAGE;
        }
        return false;
    }

    private static boolean requiresParenthesis(Tree tree, Tree tree2, Tree tree3) {
        if (!ExpressionTree.class.isAssignableFrom(tree.getKind().asInterface())) {
            return false;
        }
        if (!ExpressionTree.class.isAssignableFrom(tree3.getKind().asInterface())) {
            return false;
        }
        if (tree3.getKind() == Tree.Kind.PARENTHESIZED || tree.getKind() == Tree.Kind.PARENTHESIZED) {
            return false;
        }
        Integer n = OPERATOR_PRIORITIES.get((Object)tree.getKind());
        Integer n2 = OPERATOR_PRIORITIES.get((Object)tree3.getKind());
        if (n == null || n2 == null) {
            Logger.getLogger(JavaFix.class.getName()).log(Level.WARNING, "Unknown tree kind(s): {0}/{1}", new Object[]{tree.getKind(), tree3.getKind()});
            return true;
        }
        if (n > n2) {
            return true;
        }
        if (n < n2) {
            return false;
        }
        if (BinaryTree.class.isAssignableFrom(tree3.getKind().asInterface())) {
            BinaryTree binaryTree = (BinaryTree)tree3;
            return binaryTree.getRightOperand() == tree2;
        }
        if (CompoundAssignmentTree.class.isAssignableFrom(tree3.getKind().asInterface())) {
            CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)tree3;
            return compoundAssignmentTree.getVariable() == tree2;
        }
        if (AssignmentTree.class.isAssignableFrom(tree3.getKind().asInterface())) {
            AssignmentTree assignmentTree = (AssignmentTree)tree3;
            return assignmentTree.getVariable() == tree2;
        }
        return false;
    }

    static {
        OPERATOR_PRIORITIES.put(Tree.Kind.IDENTIFIER, 0);
        for (Tree.Kind kind : Tree.Kind.values()) {
            if (kind.asInterface() != LiteralTree.class) continue;
            OPERATOR_PRIORITIES.put(kind, 0);
        }
        OPERATOR_PRIORITIES.put(Tree.Kind.ARRAY_ACCESS, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.METHOD_INVOCATION, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.MEMBER_SELECT, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.POSTFIX_DECREMENT, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.POSTFIX_INCREMENT, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.NEW_ARRAY, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.NEW_CLASS, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.BITWISE_COMPLEMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.LOGICAL_COMPLEMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.PREFIX_DECREMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.PREFIX_INCREMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNARY_MINUS, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNARY_PLUS, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.TYPE_CAST, 3);
        OPERATOR_PRIORITIES.put(Tree.Kind.DIVIDE, 4);
        OPERATOR_PRIORITIES.put(Tree.Kind.MULTIPLY, 4);
        OPERATOR_PRIORITIES.put(Tree.Kind.REMAINDER, 4);
        OPERATOR_PRIORITIES.put(Tree.Kind.MINUS, 5);
        OPERATOR_PRIORITIES.put(Tree.Kind.PLUS, 5);
        OPERATOR_PRIORITIES.put(Tree.Kind.LEFT_SHIFT, 6);
        OPERATOR_PRIORITIES.put(Tree.Kind.RIGHT_SHIFT, 6);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT, 6);
        OPERATOR_PRIORITIES.put(Tree.Kind.INSTANCE_OF, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.GREATER_THAN, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.GREATER_THAN_EQUAL, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.LESS_THAN, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.LESS_THAN_EQUAL, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.EQUAL_TO, 8);
        OPERATOR_PRIORITIES.put(Tree.Kind.NOT_EQUAL_TO, 8);
        OPERATOR_PRIORITIES.put(Tree.Kind.AND, 9);
        OPERATOR_PRIORITIES.put(Tree.Kind.OR, 11);
        OPERATOR_PRIORITIES.put(Tree.Kind.XOR, 10);
        OPERATOR_PRIORITIES.put(Tree.Kind.CONDITIONAL_AND, 12);
        OPERATOR_PRIORITIES.put(Tree.Kind.CONDITIONAL_OR, 13);
        OPERATOR_PRIORITIES.put(Tree.Kind.CONDITIONAL_EXPRESSION, 14);
        OPERATOR_PRIORITIES.put(Tree.Kind.AND_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.DIVIDE_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.MINUS_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.MULTIPLY_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.OR_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.PLUS_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.REMAINDER_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.XOR_ASSIGNMENT, 15);
        JavaFixImpl.Accessor.INSTANCE = new JavaFixImpl.Accessor(){

            @Override
            public String getText(JavaFix javaFix) {
                return javaFix.getText();
            }

            @Override
            public ChangeInfo process(JavaFix javaFix, WorkingCopy workingCopy, UpgradeUICallback upgradeUICallback) throws Exception {
                return javaFix.process(workingCopy, upgradeUICallback);
            }

            @Override
            public FileObject getFile(JavaFix javaFix) {
                return javaFix.getFile();
            }
        };
    }

    private static class JavaFixRealImpl
    extends JavaFix {
        private final String displayName;
        private final Map<String, TreePathHandle> params;
        private final Map<String, Collection<TreePathHandle>> paramsMulti;
        private final Map<String, String> parameterNames;
        private final Map<String, TypeMirrorHandle<?>> constraintsHandles;
        private final Iterable<? extends String> imports;
        private final String to;

        public JavaFixRealImpl(CompilationInfo compilationInfo, TreePath treePath, String string, String string2, Map<String, TreePathHandle> map, Map<String, Collection<TreePathHandle>> map2, Map<String, String> map3, Map<String, TypeMirrorHandle<?>> map4, Iterable<? extends String> iterable) {
            super(compilationInfo, treePath);
            this.displayName = string;
            this.to = string2;
            this.params = map;
            this.paramsMulti = map2;
            this.parameterNames = map3;
            this.constraintsHandles = map4;
            this.imports = iterable;
        }

        @Override
        protected String getText() {
            return this.displayName;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void performRewrite(final WorkingCopy workingCopy, TreePath treePath, final UpgradeUICallback upgradeUICallback) {
            void var7_15;
            List<? extends Tree> list;
            Object object;
            Object object22;
            final HashMap<String, TreePath> hashMap = new HashMap<String, TreePath>();
            for (Map.Entry<String, TreePathHandle> object42 : this.params.entrySet()) {
                TreePath treePath2 = object42.getValue().resolve((CompilationInfo)workingCopy);
                if (treePath2 == null) {
                    Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", object42.getValue());
                }
                hashMap.put(object42.getKey(), treePath2);
            }
            final HashMap hashMap2 = new HashMap();
            for (Map.Entry<String, Collection<TreePathHandle>> entry : this.paramsMulti.entrySet()) {
                LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
                for (Object object22 : entry.getValue()) {
                    object = object22.resolve((CompilationInfo)workingCopy);
                    if (object == null) {
                        Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", entry.getValue());
                    }
                    linkedList.add((TreePath)object);
                }
                hashMap2.put(entry.getKey(), linkedList);
            }
            HashMap<String, TypeMirror> hashMap3 = new HashMap<String, TypeMirror>();
            for (Map.Entry<String, TypeMirrorHandle<?>> entry : this.constraintsHandles.entrySet()) {
                hashMap3.put(entry.getKey(), entry.getValue().resolve((CompilationInfo)workingCopy));
            }
            Tree tree = Pattern.parseAndAttribute((CompilationInfo)workingCopy, this.to, hashMap3, new Scope[1], this.imports);
            if (!(JavaFix.isFakeBlock(tree) || JavaFix.isFakeClass(tree) || treePath.getLeaf().getKind() == Tree.Kind.BLOCK && hashMap2.containsKey("$$1$") && tree.getKind() != Tree.Kind.BLOCK)) {
                workingCopy.rewrite(treePath.getLeaf(), tree);
            } else if (JavaFix.isFakeBlock(tree)) {
                TreePath treePath3 = treePath.getParentPath();
                list = ((BlockTree)tree).getStatements();
                list = list.subList(1, list.size() - 1);
                if (treePath3.getLeaf().getKind() == Tree.Kind.BLOCK) {
                    object22 = new LinkedList();
                    for (StatementTree statementTree : ((BlockTree)treePath3.getLeaf()).getStatements()) {
                        if (statementTree == treePath.getLeaf()) {
                            object22.addAll(list);
                            continue;
                        }
                        object22.add(statementTree);
                    }
                    workingCopy.rewrite(treePath3.getLeaf(), (Tree)workingCopy.getTreeMaker().Block((List)object22, ((BlockTree)treePath3.getLeaf()).isStatic()));
                } else {
                    workingCopy.rewrite(treePath.getLeaf(), (Tree)workingCopy.getTreeMaker().Block(list, false));
                }
            } else if (JavaFix.isFakeClass(tree)) {
                TreePath treePath4 = treePath.getParentPath();
                list = ((ClassTree)tree).getMembers();
                list = list.subList(1, list.size());
                assert (treePath4.getLeaf().getKind() == Tree.Kind.CLASS);
                object22 = new LinkedList();
                object = (ClassTree)treePath4.getLeaf();
                for (Tree tree2 : object.getMembers()) {
                    if (tree2 == treePath.getLeaf()) {
                        object22.addAll(list);
                        continue;
                    }
                    object22.add(tree2);
                }
                workingCopy.rewrite(treePath4.getLeaf(), (Tree)workingCopy.getTreeMaker().Class(object.getModifiers(), (CharSequence)object.getSimpleName(), object.getTypeParameters(), object.getExtendsClause(), object.getImplementsClause(), (List)object22));
            } else {
                LinkedList<StatementTree> linkedList = new LinkedList<StatementTree>();
                linkedList.add(workingCopy.getTreeMaker().ExpressionStatement((ExpressionTree)workingCopy.getTreeMaker().Identifier((CharSequence)"$$1$")));
                linkedList.add((StatementTree)tree);
                linkedList.add(workingCopy.getTreeMaker().ExpressionStatement((ExpressionTree)workingCopy.getTreeMaker().Identifier((CharSequence)"$$2$")));
                BlockTree blockTree = workingCopy.getTreeMaker().Block(linkedList, ((BlockTree)treePath.getLeaf()).isStatic());
                workingCopy.rewrite(treePath.getLeaf(), (Tree)blockTree);
            }
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitIdentifier(IdentifierTree identifierTree, Void void_) {
                    String string;
                    String string2 = identifierTree.getName().toString();
                    TreePath treePath = (TreePath)hashMap.get(string2);
                    if (treePath != null) {
                        if (treePath.getLeaf() instanceof Hacks.RenameTree) {
                            Hacks.RenameTree renameTree = (Hacks.RenameTree)treePath.getLeaf();
                            Tree tree = workingCopy.getTreeMaker().setLabel(renameTree.originalTree, (CharSequence)renameTree.newName);
                            workingCopy.rewrite((Tree)identifierTree, tree);
                            return null;
                        }
                        if (!JavaFixRealImpl.this.parameterNames.containsKey(string2)) {
                            Tree tree = treePath.getLeaf();
                            if (JavaFix.requiresParenthesis(tree, identifierTree, this.getCurrentPath().getParentPath().getLeaf())) {
                                tree = workingCopy.getTreeMaker().Parenthesized((ExpressionTree)tree);
                            }
                            workingCopy.rewrite((Tree)identifierTree, tree);
                            return null;
                        }
                    }
                    if ((string = (String)JavaFixRealImpl.this.parameterNames.get(string2)) != null) {
                        workingCopy.rewrite((Tree)identifierTree, (Tree)workingCopy.getTreeMaker().Identifier((CharSequence)string));
                        return null;
                    }
                    Element element = workingCopy.getTrees().getElement(this.getCurrentPath());
                    if (element != null && JavaFix.isStaticElement(element)) {
                        workingCopy.rewrite((Tree)identifierTree, (Tree)workingCopy.getTreeMaker().QualIdent(element));
                    }
                    return (Void)super.visitIdentifier(identifierTree, void_);
                }

                @Override
                public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void void_) {
                    Element element = workingCopy.getTrees().getElement(this.getCurrentPath());
                    if (element == null || element.getKind() == ElementKind.CLASS && ((TypeElement)element).asType().getKind() == TypeKind.ERROR) {
                        String string;
                        if (memberSelectTree.getExpression().getKind() == Tree.Kind.IDENTIFIER && (string = ((IdentifierTree)memberSelectTree.getExpression()).getName().toString()).startsWith("$") && hashMap.get(string) == null) {
                            workingCopy.rewrite((Tree)memberSelectTree, (Tree)workingCopy.getTreeMaker().Identifier((CharSequence)memberSelectTree.getIdentifier()));
                            return null;
                        }
                        return (Void)super.visitMemberSelect(memberSelectTree, void_);
                    }
                    JavaFix.checkDependency(workingCopy, element, upgradeUICallback);
                    if (JavaFix.isStaticElement(element)) {
                        workingCopy.rewrite((Tree)memberSelectTree, (Tree)workingCopy.getTreeMaker().QualIdent(element));
                        return null;
                    }
                    return (Void)super.visitMemberSelect(memberSelectTree, void_);
                }

                @Override
                public Void visitVariable(VariableTree variableTree, Void void_) {
                    String string;
                    String string2 = variableTree.getName().toString();
                    if (string2.startsWith("$") && (string = (String)JavaFixRealImpl.this.parameterNames.get(string2)) != null) {
                        VariableTree variableTree2 = workingCopy.getTreeMaker().Variable(variableTree.getModifiers(), (CharSequence)string, variableTree.getType(), variableTree.getInitializer());
                        workingCopy.rewrite((Tree)variableTree, (Tree)variableTree2);
                        return (Void)super.visitVariable(variableTree2, void_);
                    }
                    return (Void)super.visitVariable(variableTree, void_);
                }

                @Override
                public Void visitExpressionStatement(ExpressionStatementTree expressionStatementTree, Void void_) {
                    TreePath treePath;
                    CharSequence charSequence = Utilities.getWildcardTreeName(expressionStatementTree);
                    if (charSequence != null && (treePath = (TreePath)hashMap.get(((Object)charSequence).toString())) != null) {
                        workingCopy.rewrite((Tree)expressionStatementTree, treePath.getLeaf());
                        return null;
                    }
                    return (Void)super.visitExpressionStatement(expressionStatementTree, void_);
                }

                @Override
                public Void visitBlock(BlockTree blockTree, Void void_) {
                    List<? extends StatementTree> list = this.resolveMultiParameters(blockTree.getStatements());
                    BlockTree blockTree2 = workingCopy.getTreeMaker().Block(list, blockTree.isStatic());
                    workingCopy.rewrite((Tree)blockTree, (Tree)blockTree2);
                    return (Void)super.visitBlock(blockTree2, void_);
                }

                @Override
                public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void void_) {
                    List<? extends Tree> list = this.resolveMultiParameters(methodInvocationTree.getTypeArguments());
                    List<? extends ExpressionTree> list2 = this.resolveMultiParameters(methodInvocationTree.getArguments());
                    MethodInvocationTree methodInvocationTree2 = workingCopy.getTreeMaker().MethodInvocation(list, methodInvocationTree.getMethodSelect(), list2);
                    workingCopy.rewrite((Tree)methodInvocationTree, (Tree)methodInvocationTree2);
                    return (Void)super.visitMethodInvocation(methodInvocationTree2, void_);
                }

                @Override
                public Void visitNewClass(NewClassTree newClassTree, Void void_) {
                    List<? extends Tree> list = this.resolveMultiParameters(newClassTree.getTypeArguments());
                    List<? extends ExpressionTree> list2 = this.resolveMultiParameters(newClassTree.getArguments());
                    NewClassTree newClassTree2 = workingCopy.getTreeMaker().NewClass(newClassTree.getEnclosingExpression(), list, newClassTree.getIdentifier(), list2, newClassTree.getClassBody());
                    workingCopy.rewrite((Tree)newClassTree, (Tree)newClassTree2);
                    return (Void)super.visitNewClass(newClassTree2, void_);
                }

                @Override
                public Void visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Void void_) {
                    List<? extends Tree> list = this.resolveMultiParameters(parameterizedTypeTree.getTypeArguments());
                    ParameterizedTypeTree parameterizedTypeTree2 = workingCopy.getTreeMaker().ParameterizedType(parameterizedTypeTree.getType(), list);
                    workingCopy.rewrite((Tree)parameterizedTypeTree, (Tree)parameterizedTypeTree2);
                    return (Void)super.visitParameterizedType(parameterizedTypeTree, void_);
                }

                private <T extends Tree> List<T> resolveMultiParameters(List<T> list) {
                    if (!Utilities.containsMultistatementTrees(list)) {
                        return list;
                    }
                    LinkedList<Tree> linkedList = new LinkedList<Tree>();
                    for (Tree tree : list) {
                        if (Utilities.isMultistatementWildcardTree(tree)) {
                            Collection collection = (Collection)hashMap2.get(((Object)Utilities.getWildcardTreeName(tree)).toString());
                            if (collection == null) continue;
                            for (TreePath treePath : collection) {
                                linkedList.add(treePath.getLeaf());
                            }
                            continue;
                        }
                        linkedList.add(tree);
                    }
                    return linkedList;
                }
            }.scan(new TreePath(treePath.getParentPath(), (Tree)var7_15), (Void)null);
        }
    }

    public static interface UpgradeUICallback {
        public boolean shouldUpgrade(String var1);
    }
}

