/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.compiler.impl;

import java.util.Arrays;
import org.jruby.nb.compiler.CompilerCallback;
import org.jruby.nb.compiler.impl.AbstractVariableCompiler;
import org.jruby.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.compiler.impl.StandardASMCompiler;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.CodegenUtils;
import org.objectweb.asm.Label;

public class HeapBasedVariableCompiler
extends AbstractVariableCompiler {
    public HeapBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method, StaticScope scope, boolean specificArity, int argsIndex, int firstTempIndex) {
        super(methodCompiler, method, scope, specificArity, argsIndex, firstTempIndex);
    }

    @Override
    public void beginMethod(CompilerCallback argsCallback, StaticScope scope) {
        if (scope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadThreadContext();
            this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.methodCompiler.getDynamicScopeIndex());
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            this.method.astore(this.methodCompiler.getVarsArrayIndex());
            this.method.aload(this.methodCompiler.getVarsArrayIndex());
            this.methodCompiler.loadNil();
            this.method.invokestatic(CodegenUtils.p(Arrays.class), "fill", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object[].class, Object.class)));
        }
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        }
    }

    @Override
    public void declareLocals(StaticScope scope, Label start, Label end) {
        this.method.visitLocalVariable("locals", CodegenUtils.ci(DynamicScope.class), null, start, end, this.methodCompiler.getDynamicScopeIndex());
    }

    @Override
    public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.dup();
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
        this.method.astore(this.methodCompiler.getVarsArrayIndex());
        bodyPrep.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.dup();
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
        this.method.astore(this.methodCompiler.getVarsArrayIndex());
        this.method.aload(this.methodCompiler.getVarsArrayIndex());
        this.methodCompiler.loadNil();
        this.method.invokestatic(CodegenUtils.p(Arrays.class), "fill", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object[].class, Object.class)));
    }

    @Override
    public void beginClosure(CompilerCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        this.method.aload(this.methodCompiler.getDynamicScopeIndex());
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
        this.method.astore(this.methodCompiler.getVarsArrayIndex());
        if (scope != null && scope.getNumberOfVariables() >= 1) {
            switch (scope.getNumberOfVariables()) {
                case 1: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0);
                    this.method.pop();
                    break;
                }
                case 2: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0);
                    this.assignLocalVariable(1);
                    this.method.pop();
                    break;
                }
                case 3: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0);
                    this.assignLocalVariable(1);
                    this.assignLocalVariable(2);
                    this.method.pop();
                    break;
                }
                case 4: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0);
                    this.assignLocalVariable(1);
                    this.assignLocalVariable(2);
                    this.assignLocalVariable(3);
                    this.method.pop();
                    break;
                }
                default: {
                    this.method.aload(this.methodCompiler.getVarsArrayIndex());
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0);
                    this.assignLocalVariable(1);
                    this.assignLocalVariable(2);
                    this.assignLocalVariable(3);
                    this.method.invokestatic(CodegenUtils.p(Arrays.class), "fill", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object[].class, Object.class)));
                }
            }
        }
        if (argsCallback != null) {
            this.method.aload(this.argsIndex);
            argsCallback.call(this.methodCompiler);
            this.method.pop();
        }
    }

    @Override
    public void assignLocalVariable(int index) {
        switch (index) {
            case 0: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 1: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 2: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 3: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            default: {
                this.method.dup();
                this.method.aload(this.methodCompiler.getVarsArrayIndex());
                this.method.swap();
                this.method.pushInt(index);
                this.method.swap();
                this.method.arraystore();
            }
        }
    }

    public void assignLocalVariable(int index, CompilerCallback value) {
        switch (index) {
            case 0: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                value.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 1: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                value.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 2: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                value.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 3: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                value.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            default: {
                this.method.aload(this.methodCompiler.getVarsArrayIndex());
                this.method.pushInt(index);
                value.call(this.methodCompiler);
                this.method.dup_x2();
                this.method.arraystore();
            }
        }
    }

    @Override
    public void assignLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.assignLocalVariable(index);
            return;
        }
        this.assignHeapLocal(depth, index);
    }

    @Override
    public void assignLocalVariable(int index, int depth, CompilerCallback value) {
        if (depth == 0) {
            this.assignLocalVariable(index, value);
            return;
        }
        this.assignHeapLocal(value, depth, index);
    }

    @Override
    public void retrieveLocalVariable(int index) {
        switch (index) {
            case 0: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 1: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 2: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueTwoDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueThreeDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.aload(this.methodCompiler.getVarsArrayIndex());
                this.method.pushInt(index);
                this.method.arrayload();
            }
        }
    }

    @Override
    public void retrieveLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index);
            return;
        }
        this.retrieveHeapLocal(depth, index);
    }
}

