/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyInstanceConfig;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObjectAdapter;
import org.jruby.nb.RubyRuntimeAdapter;
import org.jruby.nb.RubyString;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.ClassCache;

public class JavaEmbedUtils {
    public static Ruby initialize(List loadPaths) {
        return JavaEmbedUtils.initialize(loadPaths, new RubyInstanceConfig());
    }

    public static Ruby initialize(List loadPaths, ClassCache classCache) {
        RubyInstanceConfig config = new RubyInstanceConfig();
        if (classCache != null) {
            config.setClassCache(classCache);
        }
        return JavaEmbedUtils.initialize(loadPaths, config);
    }

    public static Ruby initialize(List loadPaths, RubyInstanceConfig config) {
        Ruby runtime = Ruby.newInstance(config);
        runtime.getLoadService().init(loadPaths);
        runtime.getLoadService().require("java");
        return runtime;
    }

    public static ClassCache createClassCache(ClassLoader loader) {
        return new ClassCache(loader, new RubyInstanceConfig().getJitMax());
    }

    public static RubyObjectAdapter newObjectAdapter() {
        return new RubyObjectAdapter(){

            @Override
            public boolean isKindOf(IRubyObject value, RubyModule rubyModule) {
                return rubyModule.isInstance(value);
            }

            @Override
            public IRubyObject setInstanceVariable(IRubyObject obj, String variableName, IRubyObject value) {
                return obj.getInstanceVariables().setInstanceVariable(variableName, value);
            }

            @Override
            public IRubyObject[] convertToJavaArray(IRubyObject array) {
                return ((RubyArray)array).toJavaArray();
            }

            @Override
            public RubyInteger convertToRubyInteger(IRubyObject obj) {
                return obj.convertToInteger();
            }

            @Override
            public IRubyObject getInstanceVariable(IRubyObject obj, String variableName) {
                return obj.getInstanceVariables().getInstanceVariable(variableName);
            }

            @Override
            public RubyString convertToRubyString(IRubyObject obj) {
                return obj.convertToString();
            }

            @Override
            public IRubyObject callMethod(IRubyObject receiver, String methodName) {
                return receiver.callMethod(receiver.getRuntime().getCurrentContext(), methodName);
            }

            @Override
            public IRubyObject callMethod(IRubyObject receiver, String methodName, IRubyObject singleArg) {
                return receiver.callMethod(receiver.getRuntime().getCurrentContext(), methodName, singleArg);
            }

            @Override
            public IRubyObject callMethod(IRubyObject receiver, String methodName, IRubyObject[] args) {
                return receiver.callMethod(receiver.getRuntime().getCurrentContext(), methodName, args);
            }

            @Override
            public IRubyObject callMethod(IRubyObject receiver, String methodName, IRubyObject[] args, Block block) {
                return receiver.callMethod(receiver.getRuntime().getCurrentContext(), methodName, args, block);
            }

            @Override
            public IRubyObject callSuper(IRubyObject receiver, IRubyObject[] args) {
                return receiver.callSuper(receiver.getRuntime().getCurrentContext(), args, Block.NULL_BLOCK);
            }

            @Override
            public IRubyObject callSuper(IRubyObject receiver, IRubyObject[] args, Block block) {
                return receiver.callSuper(receiver.getRuntime().getCurrentContext(), args, block);
            }
        };
    }

    public static RubyRuntimeAdapter newRuntimeAdapter() {
        return new RubyRuntimeAdapter(){

            @Override
            public IRubyObject eval(Ruby runtime, String script) {
                return runtime.evalScriptlet(script);
            }
        };
    }

    public static void terminate(Ruby runtime) {
        runtime.tearDown();
    }

    public static Object invokeMethod(Ruby runtime, Object receiver, String method, Object[] args, Class returnType) {
        IRubyObject rubyReceiver = receiver != null ? JavaUtil.convertJavaToRuby(runtime, receiver) : runtime.getTopSelf();
        IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime, args);
        for (int i = 0; i < rubyArgs.length; ++i) {
            IRubyObject obj = rubyArgs[i];
            if (!(obj instanceof JavaObject)) continue;
            rubyArgs[i] = Java.wrap(runtime, obj);
        }
        IRubyObject result = rubyReceiver.callMethod(runtime.getCurrentContext(), method, rubyArgs);
        return JavaEmbedUtils.rubyToJava(runtime, result, returnType);
    }

    public static Object rubyToJava(Ruby runtime, IRubyObject value, Class type) {
        return JavaUtil.convertArgument(runtime, Java.ruby_to_java(runtime.getObject(), value, Block.NULL_BLOCK), type);
    }

    public static IRubyObject javaToRuby(Ruby runtime, Object value) {
        if (value instanceof IRubyObject) {
            return (IRubyObject)value;
        }
        IRubyObject result = JavaUtil.convertJavaToRuby(runtime, value);
        return result instanceof JavaObject ? Java.wrap(runtime, result) : result;
    }

    public static IRubyObject javaToRuby(Ruby runtime, boolean value) {
        return JavaEmbedUtils.javaToRuby(runtime, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public static IRubyObject javaToRuby(Ruby runtime, byte value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Byte(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, char value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Character(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, double value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Double(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, float value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Float(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, int value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Integer(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, long value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Long(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, short value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Short(value));
    }
}

