/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.IterNode;
import org.jruby.nb.ast.MultipleAsgnNode;
import org.jruby.nb.ast.NilImplicitNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.util.ArgsUtil;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.evaluator.AssignmentVisitor;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class InterpretedBlock
extends BlockBody {
    private final IterNode iterNode;
    private final boolean hasVarNode;
    private final Node varNode;
    private final Node bodyNode;
    private final StaticScope scope;
    private final Arity arity;

    public static Block newInterpretedClosure(ThreadContext context, IterNode iterNode, IRubyObject self) {
        Frame f = context.getCurrentFrame();
        return InterpretedBlock.newInterpretedClosure(iterNode, self, Arity.procArityOf(iterNode.getVarNode()), f, f.getVisibility(), context.getRubyClass(), context.getCurrentScope());
    }

    public static Block newInterpretedClosure(ThreadContext context, InterpretedBlock body, IRubyObject self) {
        Frame f = context.getCurrentFrame();
        Binding binding = new Binding(self, f, f.getVisibility(), context.getRubyClass(), context.getCurrentScope());
        return new Block(body, binding);
    }

    public static Block newInterpretedClosure(IterNode iterNode, IRubyObject self, Arity arity, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope) {
        NodeType argsNodeId = InterpretedBlock.getArgumentTypeWackyHack(iterNode);
        InterpretedBlock body = new InterpretedBlock(iterNode, arity, InterpretedBlock.asArgumentType(argsNodeId));
        Binding binding = new Binding(self, frame, visibility, klass, dynamicScope);
        return new Block(body, binding);
    }

    public InterpretedBlock(IterNode iterNode, int argumentType) {
        this(iterNode, Arity.procArityOf(iterNode == null ? null : iterNode.getVarNode()), argumentType);
    }

    public InterpretedBlock(IterNode iterNode, Arity arity, int argumentType) {
        super(argumentType);
        this.iterNode = iterNode;
        this.arity = arity;
        this.hasVarNode = iterNode.getVarNode() != null;
        this.varNode = iterNode.getVarNode();
        this.bodyNode = iterNode.getBodyNode() == null ? NilImplicitNode.NIL : iterNode.getBodyNode();
        this.scope = iterNode.getScope();
    }

    protected Frame pre(ThreadContext context, RubyModule klass, Binding binding) {
        return context.preYieldSpecificBlock(binding, this.iterNode.getScope(), klass);
    }

    protected void post(ThreadContext context, Binding binding, Visibility vis, Frame lastFrame) {
        binding.getFrame().setVisibility(vis);
        context.postYield(binding, lastFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, Binding binding, Block.Type type) {
        IRubyObject self = this.prepareSelf(binding);
        Visibility oldVis = binding.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding);
        try {
            if (this.hasVarNode) {
                this.setupBlockArg(context, this.varNode, value, self);
            }
            IRubyObject iRubyObject = this.evalBlockBody(context, self);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type);
            return iRubyObject;
        }
        finally {
            this.post(context, binding, oldVis, lastFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
        if (klass == null) {
            self = this.prepareSelf(binding);
        }
        Visibility oldVis = binding.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding);
        try {
            if (this.hasVarNode) {
                if (aValue) {
                    this.setupBlockArgs(context, this.varNode, value, self);
                } else {
                    this.setupBlockArg(context, this.varNode, value, self);
                }
            }
            IRubyObject iRubyObject = this.evalBlockBody(context, self);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type);
            return iRubyObject;
        }
        finally {
            this.post(context, binding, oldVis, lastFrame);
        }
    }

    /*
     * Loose catch block
     */
    private IRubyObject evalBlockBody(ThreadContext context, IRubyObject self) {
        while (true) {
            try {
                return this.bodyNode.interpret(context.getRuntime(), context, self, Block.NULL_BLOCK);
            }
            catch (JumpException.RedoJump rj) {
                context.pollThreadEvents();
                continue;
            }
            break;
        }
        catch (StackOverflowError sfe) {
            throw context.getRuntime().newSystemStackError("stack level too deep");
        }
    }

    private IRubyObject prepareSelf(Binding binding) {
        IRubyObject self = binding.getSelf();
        binding.getFrame().setSelf(self);
        return self;
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type) {
        return type == Block.Type.LAMBDA ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
    }

    private void setupBlockArgs(ThreadContext context, Node varNode, IRubyObject value, IRubyObject self) {
        Ruby runtime = context.getRuntime();
        switch (varNode.nodeId) {
            case ZEROARGNODE: {
                break;
            }
            case MULTIPLEASGNNODE: {
                value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)varNode, (RubyArray)value, false);
                break;
            }
            default: {
                this.defaultArgsLogic(context, runtime, self, value);
            }
        }
    }

    private void setupBlockArg(ThreadContext context, Node varNode, IRubyObject value, IRubyObject self) {
        Ruby runtime = context.getRuntime();
        switch (varNode.nodeId) {
            case ZEROARGNODE: {
                return;
            }
            case MULTIPLEASGNNODE: {
                value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)varNode, ArgsUtil.convertToRubyArray(runtime, value, ((MultipleAsgnNode)varNode).getHeadNode() != null), false);
                break;
            }
            default: {
                this.defaultArgLogic(context, runtime, self, value);
            }
        }
    }

    private final void defaultArgsLogic(ThreadContext context, Ruby ruby, IRubyObject self, IRubyObject value) {
        int length = ArgsUtil.arrayLength(value);
        switch (length) {
            case 0: {
                value = ruby.getNil();
                break;
            }
            case 1: {
                value = ((RubyArray)value).eltInternal(0);
                break;
            }
            default: {
                ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length + " for 1)", new Object[0]);
            }
        }
        this.varNode.assign(ruby, context, self, value, Block.NULL_BLOCK, false);
    }

    private final void defaultArgLogic(ThreadContext context, Ruby ruby, IRubyObject self, IRubyObject value) {
        if (value == null) {
            ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
        }
        this.varNode.assign(ruby, context, self, value, Block.NULL_BLOCK, false);
    }

    @Override
    public StaticScope getStaticScope() {
        return this.scope;
    }

    @Override
    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    public IterNode getIterNode() {
        return this.iterNode;
    }

    @Override
    public Arity arity() {
        return this.arity;
    }
}

