/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class GenericMap
implements Map {
    protected int size;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected int keyHash(Object key) {
        if (key == null) {
            return 0;
        }
        return key.hashCode();
    }

    protected boolean keyEquals(Object containedKey, Object givenKey) {
        if (containedKey == null) {
            return givenKey == null;
        }
        return containedKey.equals(givenKey);
    }

    protected int valueHash(Object value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    protected boolean valueEquals(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    public void putAll(Map other) {
        if (other == this) {
            return;
        }
        for (Map.Entry entry : other.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected abstract Iterator entryIterator();

    protected Iterator keyIterator() {
        return new KeyIterator();
    }

    protected Iterator valueIterator() {
        return new ValueIterator();
    }

    private static Object[] toArray(Object[] arr, int size, Iterator it) {
        Object[] out = arr != null && arr.length >= size ? arr : (arr == null ? new Object[size] : (Object[])Array.newInstance(arr.getClass().getComponentType(), size));
        for (int i = 0; i < size; ++i) {
            out[i] = it.next();
        }
        if (out.length > size) {
            out[size] = null;
        }
        return out;
    }

    public Collection values() {
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                return GenericMap.this.valueIterator();
            }

            @Override
            public int size() {
                return GenericMap.this.size();
            }

            @Override
            public Object[] toArray(Object[] arr) {
                return GenericMap.toArray(arr, this.size(), this.iterator());
            }
        };
    }

    public Set keySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return GenericMap.this.keyIterator();
            }

            @Override
            public int size() {
                return GenericMap.this.size();
            }

            @Override
            public Object[] toArray(Object[] arr) {
                return GenericMap.toArray(arr, this.size(), this.iterator());
            }
        };
    }

    @Override
    public int hashCode() {
        int code = 0;
        Iterator it = this.entryIterator();
        while (it.hasNext()) {
            code += it.next().hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Map) {
            Map map = (Map)other;
            if (map.size() != this.size()) {
                return false;
            }
            Iterator it = this.entryIterator();
            while (it.hasNext()) {
                Object otherVal;
                Entry ent = (Entry)it.next();
                Object key = ent.getKey();
                Object val = ent.getValue();
                if (!map.containsKey(key) || this.valueEquals(val, otherVal = map.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return GenericMap.this.entryIterator();
            }

            @Override
            public int size() {
                return GenericMap.this.size;
            }

            @Override
            public Object[] toArray(Object[] arr) {
                return GenericMap.toArray(arr, this.size(), this.iterator());
            }
        };
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator it = this.valueIterator();
        while (it.hasNext()) {
            if (!this.valueEquals(value, it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    class ValueIterator
    extends KeyOrValueIterator {
        ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    class KeyIterator
    extends KeyOrValueIterator {
        KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class KeyOrValueIterator
    implements Iterator {
        Iterator iter;

        KeyOrValueIterator() {
            this.iter = GenericMap.this.entryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        protected Map.Entry nextEntry() {
            return (Map.Entry)this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    abstract class Entry
    implements Map.Entry {
        Entry() {
        }

        @Override
        public int hashCode() {
            return GenericMap.this.keyHash(this.getKey()) ^ GenericMap.this.valueHash(this.getValue());
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Map.Entry) {
                Map.Entry ent = (Map.Entry)other;
                return GenericMap.this.keyEquals(this.getKey(), ent.getKey()) && GenericMap.this.valueEquals(this.getValue(), ent.getValue());
            }
            return false;
        }
    }
}

