/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.nodes;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class KenaiInstanceProperties
extends HashMap<String, String> {
    private Sheet.Set set;
    public static final String INSTANCE_URL = "url";
    public static final String INSTANCE_NAME = "display_name";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public KenaiInstanceProperties(String name, String url) {
        this.put(INSTANCE_URL, url);
        this.put(INSTANCE_NAME, name);
    }

    public KenaiInstanceProperties(Map<String, String> properties) {
        super(properties);
    }

    @Override
    public synchronized String put(String key, String value) {
        String o = super.put(key, value);
        this.pcs.firePropertyChange(key, o, value);
        return o;
    }

    @Override
    public synchronized String remove(Object key) {
        String o = (String)super.remove((String)key);
        this.pcs.firePropertyChange((String)key, o, null);
        return o;
    }

    public boolean isPersisted() {
        return true;
    }

    public Sheet.Set getSheetSet() {
        if (null == this.set) {
            this.set = Sheet.createPropertiesSet();
            this.set.setDisplayName((String)this.get(INSTANCE_NAME));
            this.set.put((Node.Property[])new PropertySupport[]{new KenaiInstanceProperty(INSTANCE_NAME, NbBundle.getMessage(KenaiInstanceProperties.class, (String)"TXT_Instance_Prop_Name"), NbBundle.getMessage(KenaiInstanceProperties.class, (String)"DESC_Instance_Prop_Name"), true, false), new KenaiInstanceProperty(INSTANCE_URL, NbBundle.getMessage(KenaiInstanceProperties.class, (String)"TXT_Instance_Prop_Url"), NbBundle.getMessage(KenaiInstanceProperties.class, (String)"DESC_Instance_Prop_Url"), true, false)});
        }
        return this.set;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public List<PropertyChangeListener> getCurrentListeners() {
        return Arrays.asList(this.pcs.getPropertyChangeListeners());
    }

    private class KenaiInstanceProperty
    extends PropertySupport<String> {
        private String key;

        public KenaiInstanceProperty(String key, String name, String desc, boolean read, boolean write) {
            super(key, String.class, name, desc, read, write);
            this.key = key;
        }

        public void setValue(String value) {
            KenaiInstanceProperties.this.put(this.key, value);
        }

        public String getValue() {
            return (String)KenaiInstanceProperties.this.get(this.key);
        }
    }
}

