/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.soap.validation;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeader;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeaderBase;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeaderFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPMessageBase;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPOperation;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.validation.MessagePart;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.validation.SOAPComponentValidator;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

public class SOAPComponentVisitor
implements SOAPComponent.Visitor {
    private static final String HTTP_DEFAULT_PORT_TOKEN = "${HttpDefaultPort}";
    private static final String HTTPS_DEFAULT_PORT_TOKEN = "${HttpsDefaultPort}";
    private final SOAPComponentValidator mValidator;
    private final Validation mValidation;
    private final List<Validator.ResultItem> results;

    SOAPComponentVisitor(SOAPComponentValidator validator, Validation validation) {
        this.mValidator = validator;
        this.mValidation = validation;
        this.results = new LinkedList<Validator.ResultItem>();
    }

    public List<Validator.ResultItem> getResultItems() {
        return this.results;
    }

    public void visit(WSDLModel wsdlModel) {
        Definitions defs = wsdlModel.getDefinitions();
        for (Binding binding : defs.getBindings()) {
            int numSoapBindings = binding.getExtensibilityElements(SOAPBinding.class).size();
            if (numSoapBindings > 0 && numSoapBindings != 1) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)binding, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBindingValidator.Only_one_binding_allowed")));
            }
            Iterator soapBindings = binding.getExtensibilityElements(SOAPBinding.class).iterator();
            while (soapBindings.hasNext()) {
                ((SOAPBinding)soapBindings.next()).accept(this);
            }
            for (BindingOperation bindingOp : binding.getBindingOperations()) {
                BindingOutput bindingOutput;
                List soapOpsList = bindingOp.getExtensibilityElements(SOAPOperation.class);
                Iterator soapOps = soapOpsList.iterator();
                while (soapOps.hasNext()) {
                    ((SOAPOperation)soapOps.next()).accept(this);
                }
                if (soapOpsList.size() <= 0) continue;
                BindingInput bindingInput = bindingOp.getBindingInput();
                if (bindingInput != null) {
                    this.visit(bindingInput);
                }
                if ((bindingOutput = bindingOp.getBindingOutput()) != null) {
                    this.visit(bindingOutput);
                }
                for (BindingFault bindingFault : bindingOp.getBindingFaults()) {
                    int numSoapFaults = bindingFault.getExtensibilityElements(SOAPFault.class).size();
                    if (numSoapFaults == 0) {
                        this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.No_soap_fault_defined")));
                    }
                    if (numSoapFaults > 0 && numSoapFaults != 1) {
                        this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.Only_one_fault_allowed")));
                    }
                    for (SOAPFault soapFault : bindingFault.getExtensibilityElements(SOAPFault.class)) {
                        if (soapFault.getName() != null && !soapFault.getName().equals(bindingFault.getName())) {
                            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.Fault_name_not_match")));
                        }
                        soapFault.accept(this);
                    }
                }
            }
        }
        Iterator<Service> services = defs.getServices().iterator();
        while (services.hasNext()) {
            for (Port port : services.next().getPorts()) {
                Binding binding;
                if (port.getBinding() == null || (binding = (Binding)port.getBinding().get()) == null) continue;
                int numRelatedSoapBindings = binding.getExtensibilityElements(SOAPBinding.class).size();
                Iterator soapAddresses = port.getExtensibilityElements(SOAPAddress.class).iterator();
                if (numRelatedSoapBindings > 0 && !soapAddresses.hasNext()) {
                    this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Missing_SoapAddress")));
                }
                if (port.getExtensibilityElements(SOAPAddress.class).size() > 1) {
                    this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Only_one_SoapAddress_allowed")));
                }
                while (soapAddresses.hasNext()) {
                    ((SOAPAddress)soapAddresses.next()).accept(this);
                }
            }
        }
    }

    @Override
    public void visit(SOAPHeader header) {
        String namespace;
        String part;
        NamedComponentReference<Message> message = header.getMessage();
        if (message == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)header, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Missing_message")));
        }
        if ((part = header.getPart()) == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)header, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Missing_part")));
        }
        try {
            SOAPMessageBase.Use use = header.getUse();
            if (use == null) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)header, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Missing_use")));
            }
        }
        catch (Throwable th) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)header, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Unsupported_header_use_attribute")));
        }
        Collection<String> encodingStyles = header.getEncodingStyles();
        if (encodingStyles != null) {
            // empty if block
        }
        if ((namespace = header.getNamespace()) != null) {
            // empty if block
        }
    }

    @Override
    public void visit(SOAPAddress address) {
        int contextStartIndex;
        int colonIndex;
        String location = address.getLocation();
        if (location == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Missing_location")));
            return;
        }
        if ("REPLACE_WITH_ACTUAL_URL".equals(location)) {
            return;
        }
        if (location.indexOf(HTTP_DEFAULT_PORT_TOKEN, 6) > 0) {
            colonIndex = -1;
            contextStartIndex = -1;
            if (location.startsWith("http://")) {
                colonIndex = location.indexOf(":", 7);
                if (HTTP_DEFAULT_PORT_TOKEN.equals(location.substring(colonIndex + 1, contextStartIndex = location.indexOf("/", 7)))) {
                    return;
                }
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_location_attribute")));
                return;
            }
        }
        if (location.indexOf(HTTPS_DEFAULT_PORT_TOKEN, 7) > 0) {
            colonIndex = -1;
            contextStartIndex = -1;
            if (location.startsWith("https://")) {
                colonIndex = location.indexOf(":", 8);
                if (HTTPS_DEFAULT_PORT_TOKEN.equals(location.substring(colonIndex + 1, contextStartIndex = location.indexOf("/", 8)))) {
                    return;
                }
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_location_attribute")));
                return;
            }
        }
        if (this.containsToken(location)) {
            if (!this.isValidSoapAddressToken(location)) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_Token_Format")));
                return;
            }
        } else {
            try {
                URI uri = new URI(location);
                String scheme = uri.getScheme();
                if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                    return;
                }
                URL url = uri.toURL();
            }
            catch (Exception ex) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_location_attribute")));
            }
        }
    }

    @Override
    public void visit(SOAPBinding binding) {
        String transportURI = binding.getTransportURI();
        if (transportURI == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)binding, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBindingValidator.Transport_URI_required")));
        } else if (!transportURI.equals("http://schemas.xmlsoap.org/soap/http")) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)binding, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBindingValidator.Unsupported_transport")));
        }
        try {
            SOAPBinding.Style style = binding.getStyle();
        }
        catch (Throwable th) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)binding, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBindingValidator.Unsupported_style_attribute")));
        }
    }

    @Override
    public void visit(SOAPBody body) {
        String namespace;
        Collection<String> encodingStyles = body.getEncodingStyles();
        if (encodingStyles != null) {
            // empty if block
        }
        if ((namespace = body.getNamespace()) != null) {
            // empty if block
        }
        try {
            SOAPMessageBase.Use use = body.getUse();
        }
        catch (Throwable th) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)body, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Unsupported_use_attribute")));
        }
        List<String> parts = body.getParts();
        if (parts != null) {
            // empty if block
        }
    }

    @Override
    public void visit(SOAPFault fault) {
        String namespace;
        Collection<String> encodingStyles;
        String name = fault.getName();
        if (name == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)fault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.Missing_name")));
        }
        if ((encodingStyles = fault.getEncodingStyles()) != null) {
            // empty if block
        }
        if ((namespace = fault.getNamespace()) != null) {
            // empty if block
        }
        try {
            SOAPMessageBase.Use use = fault.getUse();
        }
        catch (Throwable th) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)fault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPFaultValidator.Unsupported_use_attribute")));
        }
    }

    @Override
    public void visit(SOAPHeaderFault headerFault) {
        String namespace;
        String part;
        NamedComponentReference<Message> message = headerFault.getMessage();
        if (message == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)headerFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Missing_header_fault_message")));
        }
        if ((part = headerFault.getPart()) == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)headerFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Missing_header_fault_part")));
        }
        try {
            SOAPMessageBase.Use use = headerFault.getUse();
            if (use == null) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)headerFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Missing_header_fault_use")));
            }
        }
        catch (Throwable th) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)headerFault, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Unsupported_header_fault_use_attribute")));
        }
        Collection<String> encodingStyles = headerFault.getEncodingStyles();
        if (encodingStyles != null) {
            // empty if block
        }
        if ((namespace = headerFault.getNamespace()) != null) {
            // empty if block
        }
    }

    @Override
    public void visit(SOAPOperation operation) {
        String soapActionURI = operation.getSoapAction();
        if (soapActionURI != null) {
            // empty if block
        }
        try {
            SOAPBinding.Style style = operation.getStyle();
        }
        catch (Throwable th) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)operation, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPOperationValidator.Unsupported_style_attribute")));
        }
    }

    private void visit(BindingInput bindingInput) {
        HashMap<MessagePart, SOAPMessageBase> partMap = new HashMap<MessagePart, SOAPMessageBase>();
        List soapHeaders = bindingInput.getExtensibilityElements(SOAPHeader.class);
        for (SOAPHeader header : soapHeaders) {
            header.accept(this);
            this.ensureUniqueParts(partMap, header);
            Collection<SOAPHeaderFault> soapHeaderFaults = header.getSOAPHeaderFaults();
            for (SOAPHeaderFault fault : soapHeaderFaults) {
                fault.accept(this);
                this.ensureUniqueParts(partMap, fault);
            }
        }
        int numSoapBodies = bindingInput.getExtensibilityElements(SOAPBody.class).size();
        if (numSoapBodies != 0 && numSoapBodies > 0 && numSoapBodies != 1) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Only_one_body_allowed")));
        }
        List soapBodies = bindingInput.getExtensibilityElements(SOAPBody.class);
        for (SOAPBody body : soapBodies) {
            body.accept(this);
            this.ensureUniqueParts(partMap, body, bindingInput);
        }
    }

    private void visit(BindingOutput bindingOutput) {
        HashMap<MessagePart, SOAPMessageBase> partMap = new HashMap<MessagePart, SOAPMessageBase>();
        List soapHeaders = bindingOutput.getExtensibilityElements(SOAPHeader.class);
        for (SOAPHeader soapHeader : soapHeaders) {
            soapHeader.accept(this);
            this.ensureUniqueParts(partMap, soapHeader);
            Collection<SOAPHeaderFault> soapHeaderFaults = soapHeader.getSOAPHeaderFaults();
            for (SOAPHeaderFault fault : soapHeaderFaults) {
                fault.accept(this);
                this.ensureUniqueParts(partMap, fault);
            }
        }
        int numSoapBodies = bindingOutput.getExtensibilityElements(SOAPBody.class).size();
        if (numSoapBodies != 0 && numSoapBodies > 0 && numSoapBodies != 1) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Only_one_body_allowed")));
        }
        List soapBodies = bindingOutput.getExtensibilityElements(SOAPBody.class);
        for (SOAPBody body : soapBodies) {
            body.accept(this);
            this.ensureUniqueParts(partMap, body, bindingOutput);
        }
    }

    private void ensureUniqueParts(Map<MessagePart, SOAPMessageBase> partsMap, SOAPBody elem, WSDLComponent parent) {
        OperationParameter param;
        if (parent instanceof BindingInput) {
            param = (OperationParameter)((BindingInput)parent).getInput().get();
        } else if (parent instanceof BindingOutput) {
            param = (OperationParameter)((BindingOutput)parent).getOutput().get();
        } else {
            throw new IllegalArgumentException("(Internal error) Unexpected WSDLComponent sub-type " + parent.getClass().getName());
        }
        if (param == null || param.getMessage() == null || param.getMessage().get() == null) {
            return;
        }
        Message msg = (Message)param.getMessage().get();
        List<String> partNames = elem.getParts();
        if (partNames == null || partNames.isEmpty()) {
            Collection<Part> parts = msg.getParts();
            partNames = new ArrayList<String>(parts.size());
            for (Part part : parts) {
                partNames.add(part.getName());
            }
        }
        for (String name : partNames) {
            if (name == null || "".equals(name)) continue;
            MessagePart msgpart = new MessagePart(msg, name);
            if (!partsMap.containsKey(msgpart)) {
                partsMap.put(msgpart, elem);
                continue;
            }
            SOAPMessageBase conflictElem = partsMap.get(msgpart);
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)elem, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPBodyValidator.Part_already_in_use_by_elem", (Object)name, (Object)msg.getName(), (Object)conflictElem.getQName().toString())));
        }
    }

    private void ensureUniqueParts(Map<MessagePart, SOAPMessageBase> partsMap, SOAPHeaderBase elem) {
        NamedComponentReference<Message> comp = elem.getMessage();
        if (elem == null || elem.getMessage() == null || elem.getMessage().get() == null) {
            return;
        }
        Message msg = (Message)comp.get();
        String part = elem.getPart();
        if (part != null && !"".equals(part)) {
            MessagePart msgpart = new MessagePart(msg, part);
            if (!partsMap.containsKey(msgpart)) {
                partsMap.put(msgpart, elem);
            } else {
                SOAPMessageBase conflictElem = partsMap.get(msgpart);
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)elem, NbBundle.getMessage(SOAPComponentVisitor.class, (String)"SOAPHeaderValidator.Part_already_in_use_by_elem", (Object)part, (Object)msg.getName(), (Object)conflictElem.getQName().toString())));
            }
        }
    }

    private List<String> allMessageParts(Message msg) {
        Collection<Part> parts = msg.getParts();
        LinkedList<String> partNames = new LinkedList<String>();
        for (Part part : parts) {
            partNames.add(part.getName());
        }
        return partNames;
    }

    private boolean containsToken(String val) {
        return val.contains("${");
    }

    private boolean isValidSoapAddressToken(String tokenString) {
        boolean containsProtocolInfo = false;
        boolean isValidToken = true;
        if (tokenString.startsWith("http://")) {
            tokenString = tokenString.substring(7, tokenString.length());
            containsProtocolInfo = true;
        }
        if (tokenString.startsWith("https://")) {
            tokenString = tokenString.substring(8, tokenString.length());
            containsProtocolInfo = true;
        }
        if (!containsProtocolInfo) {
            int indexOfTokenStart = tokenString.indexOf("${");
            int indexOfTokenEnd = tokenString.indexOf("}");
            if (indexOfTokenEnd == tokenString.length() - 1 && indexOfTokenStart == 0) {
                isValidToken = true;
            } else {
                return false;
            }
        }
        if (tokenString.contains("${")) {
            int indexOfPortSeparator = tokenString.indexOf(":");
            int indexOfContextSeparator = tokenString.lastIndexOf("/");
            if (indexOfContextSeparator != -1) {
                String host;
                int indexOfTokenEnd;
                int indexOfTokenEnd2;
                String context = tokenString.substring(indexOfContextSeparator + 1, tokenString.length());
                int indexOfContextTokenStart = context.indexOf("${");
                if (indexOfContextTokenStart == 0 ? (indexOfTokenEnd2 = context.indexOf("}")) < indexOfContextTokenStart : context.indexOf("}") > 0) {
                    return false;
                }
                int indexOfTokenStart = tokenString.indexOf("${");
                if (indexOfTokenStart == 0 ? (indexOfTokenEnd = (host = tokenString.substring(1, indexOfPortSeparator)).indexOf("}")) < 1 : tokenString.substring(1, indexOfPortSeparator).indexOf("}") > 0) {
                    return false;
                }
                String port = tokenString.substring(indexOfPortSeparator + 1, indexOfContextSeparator);
                if (port.indexOf("${") != -1 && port.indexOf("}") > 0) {
                    isValidToken = true;
                } else {
                    return false;
                }
            }
        }
        return isValidToken;
    }
}

