/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.bridge;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.bridge.BridgingServerInstanceProvider;
import org.netbeans.modules.j2ee.deployment.impl.bridge.ServerInstanceProviderLookup;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.netbeans.spi.server.ServerWizardProvider;
import org.openide.WizardDescriptor;

public class BridgingServerWizardProvider
implements ServerWizardProvider {
    private final Server server;
    private final OptionalDeploymentManagerFactory optional;

    public BridgingServerWizardProvider(Server server, OptionalDeploymentManagerFactory optionalDeploymentManagerFactory) {
        this.server = server;
        this.optional = optionalDeploymentManagerFactory;
    }

    public WizardDescriptor.InstantiatingIterator getInstantiatingIterator() {
        if (this.optional.getAddInstanceIterator() == null) {
            return null;
        }
        return new InstantiatingIteratorBridge(this.optional.getAddInstanceIterator(), this.server);
    }

    public String getDisplayName() {
        return this.server.getDisplayName();
    }

    private static class InstantiatingIteratorBridge
    implements WizardDescriptor.InstantiatingIterator {
        private final WizardDescriptor.InstantiatingIterator iterator;
        private final Server server;

        public InstantiatingIteratorBridge(WizardDescriptor.InstantiatingIterator instantiatingIterator, Server server) {
            this.iterator = instantiatingIterator;
            this.server = server;
        }

        public void uninitialize(WizardDescriptor wizardDescriptor) {
            this.iterator.uninitialize(wizardDescriptor);
        }

        public Set instantiate() throws IOException {
            HashSet<org.netbeans.api.server.ServerInstance> hashSet = this.iterator.instantiate();
            if (!hashSet.isEmpty()) {
                org.netbeans.api.server.ServerInstance serverInstance;
                Object e = hashSet.iterator().next();
                String string = null;
                if (e instanceof String) {
                    string = (String)e;
                } else if (e instanceof InstanceProperties) {
                    string = ((InstanceProperties)e).getProperty("url");
                }
                if (string != null && (serverInstance = this.getBridge(ServerRegistry.getInstance().getServerInstance(string))) != null) {
                    hashSet = new HashSet<org.netbeans.api.server.ServerInstance>();
                    hashSet.add(serverInstance);
                }
            }
            return hashSet;
        }

        public void initialize(WizardDescriptor wizardDescriptor) {
            this.iterator.initialize(wizardDescriptor);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.iterator.removeChangeListener(changeListener);
        }

        public void previousPanel() {
            this.iterator.previousPanel();
        }

        public void nextPanel() {
            this.iterator.nextPanel();
        }

        public String name() {
            return this.iterator.name();
        }

        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public WizardDescriptor.Panel current() {
            return this.iterator.current();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.iterator.addChangeListener(changeListener);
        }

        private org.netbeans.api.server.ServerInstance getBridge(ServerInstance serverInstance) {
            Collection collection = ServerInstanceProviderLookup.getInstance().lookupAll(ServerInstanceProvider.class);
            for (ServerInstanceProvider serverInstanceProvider : collection) {
                org.netbeans.api.server.ServerInstance serverInstance2;
                if (!(serverInstanceProvider instanceof BridgingServerInstanceProvider) || (serverInstance2 = ((BridgingServerInstanceProvider)serverInstanceProvider).getBridge(serverInstance)) == null) continue;
                return serverInstance2;
            }
            return null;
        }
    }
}

