/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.support.DataModelSchemeProvider;
import org.netbeans.modules.dlight.api.visualizer.TableBasedVisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.datacollector.CpuSamplingSupport;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStackActionsProvider;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ThreadStackVisualizerConfiguration
implements TableBasedVisualizerConfiguration {
    public static final String ID = "ThreadStackVisualizerConfiguration.id";
    private ThreadDump threadDump;
    private long dumpTime;
    private StackNameProvider stackNameProvider;
    private long preferredSelection;
    private ThreadStackActionsProvider actionsProvider;
    private ExpansionMode expansionMode;
    private StackNameProvider defaultStackNameProvider = new StackNameProvider(){

        @Override
        public String getStackName(ThreadSnapshot snapshot) {
            String name = "";
            ThreadState.MSAState msa = snapshot.getState();
            ThreadStateResources res = ThreadStateResources.forState(msa);
            if (res != null) {
                name = res.name;
            }
            long time = ThreadStateColumnImpl.timeInervalToMilliSeconds(snapshot.getTimestamp());
            String at = TimeLineUtils.getMillisValue(time);
            return NbBundle.getMessage(ThreadStackVisualizerConfiguration.class, (String)"ThreadStackVisualizerStackAt1", (Object)name, (Object)snapshot.getThreadInfo().getThreadName(), (Object)at);
        }
    };

    public ThreadStackVisualizerConfiguration(long dumpTime, ThreadDump threadDump, StackNameProvider stackNameProvider, long preferredSelection, ThreadStackActionsProvider actionsProvider) {
        this.dumpTime = dumpTime;
        this.threadDump = threadDump;
        this.stackNameProvider = stackNameProvider;
        this.preferredSelection = preferredSelection;
        this.actionsProvider = actionsProvider;
        int i = NbPreferences.forModule(ThreadStackVisualizerConfiguration.class).getInt("expansionMode", 1);
        i = Math.max(Math.min(i, 2), 0);
        this.expansionMode = ExpansionMode.values()[i];
    }

    void update(ThreadStackVisualizerConfiguration another) {
        this.dumpTime = another.dumpTime;
        this.threadDump = another.threadDump;
        this.stackNameProvider = another.stackNameProvider;
        this.preferredSelection = another.preferredSelection;
        this.actionsProvider = another.actionsProvider;
        this.expansionMode = another.expansionMode;
    }

    ThreadDump getThreadDump() {
        return this.threadDump;
    }

    long getDumpTime() {
        return this.dumpTime;
    }

    ThreadStackActionsProvider getStackNodeActionsProvider() {
        return this.actionsProvider;
    }

    StackNameProvider getStackNameProvider() {
        if (this.stackNameProvider == null) {
            return this.defaultStackNameProvider;
        }
        return this.stackNameProvider;
    }

    long getPreferredSelection() {
        return this.preferredSelection;
    }

    ExpansionMode getPrefferedExpansion() {
        return this.expansionMode;
    }

    public DataModelScheme getSupportedDataScheme() {
        return DataModelSchemeProvider.getInstance().getScheme("model:stack");
    }

    public String getID() {
        return ID;
    }

    public DataTableMetadata getMetadata() {
        return CpuSamplingSupport.CPU_SAMPLE_TABLE;
    }

    public static interface StackNameProvider {
        public String getStackName(ThreadSnapshot var1);
    }

    public static enum ExpansionMode {
        ExpandAll,
        ExpandCurrent,
        CollapseAll;

    }
}

