/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class CheckTreeNode
extends DefaultMutableTreeNode {
    public static final int STATE_CHECKED = 1;
    public static final int STATE_UNCHECKED = 2;
    public static final int STATE_PARTIALLY_CHECKED = 4;
    protected int checkState = 2;
    private Icon icon;

    public CheckTreeNode() {
        this(null);
    }

    public CheckTreeNode(Object userObject) {
        this(userObject, null);
    }

    public CheckTreeNode(Object userObject, Icon icon) {
        super(userObject);
        this.setChecked(false);
        this.icon = icon;
    }

    public int getCheckState() {
        return this.checkState;
    }

    public Collection setChecked(boolean checked) {
        if (checked) {
            return this.setFullyChecked();
        }
        return this.setUnchecked();
    }

    public boolean isFullyChecked() {
        return this.getCheckState() == 1;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isPartiallyChecked() {
        return this.getCheckState() == 4;
    }

    public Collection toggleState() {
        if (this.getCheckState() == 1) {
            return this.setUnchecked();
        }
        return this.setFullyChecked();
    }

    protected Collection setPartiallyChecked() {
        LinkedList<CheckTreeNode> changedNodes = new LinkedList<CheckTreeNode>();
        changedNodes.add(this);
        if (this.checkState == 4) {
            return changedNodes;
        }
        this.checkState = 4;
        TreeNode parent = this.getParent();
        if (parent != null && parent instanceof CheckTreeNode) {
            changedNodes.addAll(((CheckTreeNode)parent).setPartiallyChecked());
        }
        return changedNodes;
    }

    private Collection setFullyChecked() {
        TreeNode parent;
        LinkedList<CheckTreeNode> changedNodes = new LinkedList<CheckTreeNode>();
        changedNodes.add(this);
        if (this.checkState == 1) {
            return changedNodes;
        }
        this.checkState = 1;
        if (!this.isLeaf()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeNode node = this.getChildAt(i);
                if (!(node instanceof CheckTreeNode)) continue;
                changedNodes.addAll(((CheckTreeNode)node).setFullyChecked());
            }
        }
        if ((parent = this.getParent()) != null && parent instanceof CheckTreeNode) {
            if (this.areSiblingsFullyChecked()) {
                changedNodes.addAll(((CheckTreeNode)parent).setFullyChecked());
            } else {
                changedNodes.addAll(((CheckTreeNode)parent).setPartiallyChecked());
            }
        }
        return changedNodes;
    }

    private Collection setUnchecked() {
        TreeNode parent;
        LinkedList<CheckTreeNode> changedNodes = new LinkedList<CheckTreeNode>();
        changedNodes.add(this);
        if (this.checkState == 2) {
            return changedNodes;
        }
        this.checkState = 2;
        if (!this.isLeaf()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeNode node = this.getChildAt(i);
                if (!(node instanceof CheckTreeNode)) continue;
                changedNodes.addAll(((CheckTreeNode)node).setUnchecked());
            }
        }
        if ((parent = this.getParent()) != null && parent instanceof CheckTreeNode) {
            if (this.areSiblingsUnchecked()) {
                changedNodes.addAll(((CheckTreeNode)parent).setUnchecked());
            } else {
                changedNodes.addAll(((CheckTreeNode)parent).setPartiallyChecked());
            }
        }
        return changedNodes;
    }

    private boolean areSiblingsFullyChecked() {
        TreeNode parent = this.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode node = parent.getChildAt(i);
            if (node == this || node instanceof CheckTreeNode && ((CheckTreeNode)node).getCheckState() == 1) continue;
            return false;
        }
        return true;
    }

    private boolean areSiblingsUnchecked() {
        TreeNode parent = this.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode node = parent.getChildAt(i);
            if (node == this || node instanceof CheckTreeNode && ((CheckTreeNode)node).getCheckState() == 2) continue;
            return false;
        }
        return true;
    }
}

