/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.security.auth.Refreshable;
import javax.swing.JToolTip;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesNodeModelFilter;
import org.netbeans.modules.debugger.jpda.ui.views.VariablesViewButtons;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class VariablesTableModel
implements TableModel,
Constants {
    private JPDADebugger debugger;

    public VariablesTableModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if ("LocalsToString".equals(string) || "WatchToString".equals(string)) {
            if (object instanceof Super) {
                return "";
            }
            if (object instanceof ObjectVariable) {
                try {
                    return ((ObjectVariable)object).getToStringValue();
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    return VariablesTableModel.getMessage(invalidExpressionException);
                }
            }
            if (object instanceof Variable) {
                return ((Variable)object).getValue();
            }
            if (object instanceof EditorContext.Operation || object == "lastOperations" || object instanceof String && ((String)object).startsWith("operationArguments ")) {
                return "";
            }
        } else if ("LocalsType".equals(string) || "WatchType".equals(string)) {
            if (object instanceof Variable) {
                return VariablesTableModel.getShort(((Variable)object).getType());
            }
            if (object instanceof JToolTip && (object = ((JToolTip)object).getClientProperty("getShortDescription")) instanceof Variable) {
                if (object instanceof Refreshable && !((Refreshable)object).isCurrent()) {
                    return "";
                }
                return ((Variable)object).getType();
            }
        } else if ("LocalsValue".equals(string) || "WatchValue".equals(string)) {
            if (VariablesViewButtons.isShowValuesAsString()) {
                return this.getValueAt(object, "LocalsToString");
            }
            if (object instanceof JPDAWatch) {
                JPDAWatch jPDAWatch = (JPDAWatch)object;
                String string2 = jPDAWatch.getExceptionDescription();
                if (string2 != null) {
                    return BoldVariablesTableModelFilterFirst.toHTML(">" + string2 + "<", false, false, Color.RED);
                }
                return jPDAWatch.getValue();
            }
            if (object instanceof Variable) {
                return ((Variable)object).getValue();
            }
        }
        if (object instanceof JPDAClassType) {
            return "";
        }
        if (object.toString().startsWith("SubArray")) {
            return "";
        }
        if (object instanceof EditorContext.Operation || object == "lastOperations" || object instanceof String && ((String)object).startsWith("operationArguments ")) {
            return "";
        }
        if (object == "noDebugInfoWarning") {
            return "";
        }
        if (object == "No current thread") {
            return "";
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof Variable) {
            if ("LocalsToString".equals(string) || "WatchToString".equals(string) || "LocalsType".equals(string) || "WatchType".equals(string)) {
                return true;
            }
            if ("LocalsValue".equals(string) || "WatchValue".equals(string)) {
                Object object2;
                if (object instanceof This) {
                    return true;
                }
                if (object instanceof JPDAWatch && object instanceof Refreshable) {
                    if (!((Refreshable)object).isCurrent()) {
                        return true;
                    }
                    try {
                        object2 = object.getClass().getDeclaredMethod("getEvaluatedWatch", new Class[0]);
                        ((Method)object2).setAccessible(true);
                        object = (JPDAWatch)((Method)object2).invoke(object, new Object[0]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (object instanceof ObjectVariable && !"java.lang.String".equals(object2 = object instanceof LocalVariable ? ((LocalVariable)object).getDeclaredType() : (object instanceof Field ? ((Field)object).getDeclaredType() : ((ObjectVariable)object).getType()))) {
                    return true;
                }
                if (object instanceof LocalVariable || object instanceof Field || object instanceof JPDAWatch) {
                    if (WatchesNodeModelFilter.isEmptyWatch(object)) {
                        return true;
                    }
                    return !this.debugger.canBeModified();
                }
                return true;
            }
        }
        if (object instanceof JPDAClassType) {
            return true;
        }
        if (object.toString().startsWith("SubArray")) {
            return true;
        }
        if (object instanceof EditorContext.Operation) {
            return true;
        }
        if (object == "noDebugInfoWarning") {
            return true;
        }
        if (object == "No current thread") {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof LocalVariable && "LocalsValue".equals(string)) {
            try {
                ((LocalVariable)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        if (object instanceof Field && ("LocalsValue".equals(string) || "WatchValue".equals(string))) {
            try {
                ((Field)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        if (object instanceof JPDAWatch && ("LocalsValue".equals(string) || "WatchValue".equals(string))) {
            try {
                ((JPDAWatch)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    static String getShort(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    static String getMessage(InvalidExpressionException invalidExpressionException) {
        Throwable throwable;
        String string = invalidExpressionException.getLocalizedMessage();
        if (string == null) {
            string = invalidExpressionException.getMessage();
        }
        if (string == null) {
            string = NbBundle.getMessage(VariablesTableModel.class, (String)"MSG_NA");
        }
        if ((throwable = invalidExpressionException.getTargetException()) != null && throwable instanceof ApplicationException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            string = string + " \n" + stringWriter.toString();
        }
        return BoldVariablesTableModelFilterFirst.toHTML(">" + string + "<", false, false, Color.RED);
    }
}

