/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.platform.server;

import java.io.IOException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.logging.SessionLogEntry;

public class ServerLog
extends AbstractSessionLog {
    public ServerLog() {
        this.setLevel(5);
    }

    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel())) {
            return;
        }
        String message = this.getSupplementDetailString(entry);
        message = entry.hasException() ? message + entry.getException() : message + this.formatMessage(entry);
        this.basicLog(entry.getLevel(), message);
    }

    protected void basicLog(int level, String message) {
        try {
            this.printPrefixString(level);
            this.getWriter().write(message);
            this.getWriter().write(Helper.cr());
            this.getWriter().flush();
        }
        catch (IOException exception) {
            throw ValidationException.logIOError(exception);
        }
    }
}

