/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemInstallInfo;
import org.netbeans.modules.ruby.platform.gems.GemListModel;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.gems.GemUISupport;
import org.netbeans.modules.ruby.platform.gems.InstallationSettingsPanel;
import org.netbeans.modules.ruby.platform.gems.UninstallationSettingsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class GemPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(GemPanel.class.getName());
    private static final String LAST_GEM_DIRECTORY = "lastLocalGemDirectory";
    private static final String LAST_PLATFORM_ID = "gemPanelLastPlatformID";
    private RequestProcessor updateTasksQueue;
    private boolean closed;
    private boolean gemsModified;
    private String filter;
    private FilterFieldListener sfl;
    private static final RequestProcessor FILTER_PROCESSOR = new RequestProcessor("rubygems-filter-processor");
    private final RequestProcessor.Task filterTask;
    private final GemListModel emptyGemListModel = new GemListModel(Collections.<Gem>emptyList(), null);
    private JCheckBox allVersionsCheckbox;
    private JButton browseGemHome;
    private JCheckBox descriptionCheckbox;
    private JLabel gemHome;
    private JTextField gemHomeValue;
    private JTabbedPane gemsTab;
    private JButton installButton;
    private JButton installLocalButton;
    private JTextPane installedDesc;
    private JList installedList;
    private JPanel installedPanel;
    private JProgressBar installedProgress;
    private JLabel installedProgressLabel;
    private JScrollPane installedSP;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JButton manageButton;
    private JTextPane newDesc;
    private JList newList;
    private JPanel newPanel;
    private JProgressBar newProgress;
    private JLabel newProgressLabel;
    private JScrollPane newSP;
    private JLabel oldRubyGemsText;
    private JComboBox platforms;
    private JButton proxyButton;
    private JButton reloadInstalledButton;
    private JButton reloadNewButton;
    private JButton reloadUpdatedButton;
    private JLabel rubyPlatformLabel;
    private JLabel searchInstLbl;
    private JTextField searchInstText;
    private JLabel searchNewLbl;
    private JTextField searchNewText;
    private JLabel searchUpdatedLbl;
    private JTextField searchUpdatedText;
    private JPanel settingsPanel;
    private JButton uninstallButton;
    private JButton updateAllButton;
    private JButton updateButton;
    private JTextPane updatedDesc;
    private JList updatedList;
    private JPanel updatedPanel;
    private JProgressBar updatedProgress;
    private JLabel updatedProgressLabel;
    private JScrollPane updatedSP;
    private JCheckBox verboseCheckBox;

    public GemPanel(String initialFilter) {
        this(initialFilter, null, true);
    }

    public GemPanel(String initialFilter, RubyPlatform preselected, boolean canManagePlatforms) {
        this.updateTasksQueue = new RequestProcessor("Gem Updater", 5);
        this.filterTask = FILTER_PROCESSOR.create(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GemPanel.this.applyFilter();
                    }
                });
            }
        });
        this.initComponents();
        if (!canManagePlatforms) {
            this.manageButton.setVisible(false);
        }
        this.oldRubyGemsText.setForeground(UIManager.getColor("nb.errorForeground"));
        if (preselected == null) {
            Util.preselectPlatform(this.platforms, LAST_PLATFORM_ID);
        } else {
            this.platforms.setSelectedItem(preselected);
        }
        GemManager gemManager = this.getGemManager();
        if (gemManager != null) {
            this.allVersionsCheckbox.setSelected(!gemManager.hasAncientRubyGemsVersion() && RubyPreferences.shallFetchAllVersions());
        }
        this.descriptionCheckbox.setSelected(RubyPreferences.shallFetchGemDescriptions());
        this.installedList.setCellRenderer(new GemUISupport.GemListRenderer());
        this.installedList.setSelectionMode(2);
        this.installedList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.installedList, this.installedDesc, this.uninstallButton));
        this.newList.setCellRenderer(new GemUISupport.GemListRenderer());
        this.newList.setSelectionMode(2);
        this.newList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.newList, this.newDesc, this.installButton));
        this.updatedList.setCellRenderer(new GemUISupport.GemListRenderer());
        this.updatedList.setSelectionMode(2);
        this.updatedList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.updatedList, this.updatedDesc, this.updateButton));
        PlatformComponentFactory.addPlatformChangeListener(this.platforms, new PlatformComponentFactory.PlatformChangeListener(){

            @Override
            public void platformChanged() {
                GemPanel.this.platformChanged();
            }
        });
        this.platformChanged();
        if (initialFilter != null) {
            this.setFilter(initialFilter);
            this.gemsTab.setSelectedIndex(TabIndex.NEW.getPosition());
            this.applyFilter();
        } else {
            this.gemsTab.setSelectedIndex(TabIndex.INSTALLED.getPosition());
        }
        this.verboseCheckBox.setSelected(RubyPreferences.isGemVerboseOutput());
    }

    private void platformChanged() {
        assert (EventQueue.isDispatchThread());
        this.cancelRunningTasks();
        boolean paltformsAreBeingLoaded = PlatformComponentFactory.isLoadingPlatforms(this.platforms);
        RubyPlatform platform = this.getSelectedPlatform();
        if (paltformsAreBeingLoaded || platform == null || !platform.isValid() || !platform.hasRubyGemsInstalled()) {
            if (!paltformsAreBeingLoaded) {
                this.gemHomeValue.setForeground(PlatformComponentFactory.INVALID_PLAF_COLOR);
                this.gemHomeValue.setText(platform == null ? GemPanel.getMessage("GemPanel.select.valid.platform", new Object[0]) : GemManager.getNotInstalledMessage());
            }
            this.updateList(TabIndex.INSTALLED, Collections.<Gem>emptyList());
            this.updateList(TabIndex.NEW, Collections.<Gem>emptyList());
            this.updateList(TabIndex.UPDATED, Collections.<Gem>emptyList());
            this.setEnabledGUI(false);
            this.hideProgressBars();
            this.oldRubyGemsText.setVisible(false);
            return;
        }
        GemManager gemManager = this.getGemManager();
        this.oldRubyGemsText.setVisible(gemManager.hasOldRubyGemsVersion());
        if (gemManager.hasOldRubyGemsVersion()) {
            this.oldRubyGemsText.setText(GemPanel.getMessage("GemPanel.oldRubyGems.warning", gemManager.getRubyGemsVersion()));
        }
        assert (gemManager != null) : "gemManager must not be null";
        this.allVersionsCheckbox.setEnabled(!gemManager.hasAncientRubyGemsVersion());
        this.gemHomeValue.setText(this.getGemManager().getGemHome());
        this.gemHomeValue.setForeground(UIManager.getColor("Label.foreground"));
        this.refreshAllGems();
    }

    public void setFilter(String filter) {
        assert (EventQueue.isDispatchThread());
        this.filter = filter;
    }

    public String getFilter() {
        assert (EventQueue.isDispatchThread());
        return this.filter;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.sfl = new FilterFieldListener();
        this.addFilterDocumentListeners();
    }

    private void addFilterDocumentListeners() {
        this.searchInstText.getDocument().addDocumentListener(this.sfl);
        this.searchNewText.getDocument().addDocumentListener(this.sfl);
        this.searchUpdatedText.getDocument().addDocumentListener(this.sfl);
    }

    private void removeFilterDocumentListeners() {
        this.searchInstText.getDocument().removeDocumentListener(this.sfl);
        this.searchNewText.getDocument().removeDocumentListener(this.sfl);
        this.searchUpdatedText.getDocument().removeDocumentListener(this.sfl);
    }

    @Override
    public void removeNotify() {
        this.closed = true;
        this.removeFilterDocumentListeners();
        this.cancelRunningTasks();
        if (this.getSelectedPlatform() != null) {
            RubyPreferences.getPreferences().put(LAST_PLATFORM_ID, this.getSelectedPlatform().getID());
        }
        super.removeNotify();
    }

    private void cancelRunningTasks() {
        LOGGER.finer("Cancelling all running GemPanel tasks");
    }

    private static void updateGemDescription(JList list, JTextPane pane, JButton button) {
        Object o = list.getSelectedValue();
        if (o instanceof Gem) {
            button.setEnabled(true);
            if (pane != null) {
                GemPanel.updateGemDescription(pane, (Gem)o);
            }
            return;
        }
        if (pane != null) {
            pane.setText("");
        }
        button.setEnabled(false);
    }

    private static void updateGemDescription(JTextPane pane, Gem gem) {
        assert (EventQueue.isDispatchThread());
        if (gem == null) {
            pane.setText("");
            return;
        }
        String htmlMimeType = "text/html";
        pane.setContentType(htmlMimeType);
        pane.setText(GemUISupport.getGemHTMLDescriptionForTextPane(gem));
        pane.setCaretPosition(0);
    }

    private void setEnabledGUI(boolean enabled) {
        this.setEnabledLocalsGUI(enabled);
        this.setEnabledRemoteGUI(enabled);
    }

    private void setEnabledLocalsGUI(boolean enabled) {
        this.setEnabled(TabIndex.INSTALLED, enabled);
    }

    private void setEnabledRemoteGUI(boolean enabled) {
        this.setEnabled(TabIndex.NEW, enabled);
        this.setEnabled(TabIndex.UPDATED, enabled);
    }

    private void enableLocalReloadGUI() {
        this.reloadInstalledButton.setEnabled(true);
    }

    private void enableRemoteReloadGUI() {
        this.reloadNewButton.setEnabled(true);
        this.reloadUpdatedButton.setEnabled(true);
    }

    private void setEnabled(TabIndex tab, boolean enabled) {
        switch (tab) {
            case NEW: {
                this.reloadNewButton.setEnabled(enabled);
                if (!enabled) {
                    this.installButton.setEnabled(enabled);
                }
                this.installLocalButton.setEnabled(enabled);
                this.newPanel.setEnabled(enabled);
                this.newList.setEnabled(enabled);
                this.newSP.setEnabled(enabled);
                this.searchNewLbl.setEnabled(enabled);
                this.searchNewText.setEnabled(enabled);
                break;
            }
            case UPDATED: {
                if (!enabled) {
                    this.updateButton.setEnabled(enabled);
                }
                this.updateAllButton.setEnabled(enabled);
                this.reloadUpdatedButton.setEnabled(enabled);
                this.updatedPanel.setEnabled(enabled);
                this.updatedList.setEnabled(enabled);
                this.updatedSP.setEnabled(enabled);
                this.searchUpdatedLbl.setEnabled(enabled);
                this.searchUpdatedText.setEnabled(enabled);
                break;
            }
            case INSTALLED: {
                this.reloadInstalledButton.setEnabled(enabled);
                if (!enabled) {
                    this.uninstallButton.setEnabled(enabled);
                }
                this.installedPanel.setEnabled(enabled);
                this.installedList.setEnabled(enabled);
                this.installedSP.setEnabled(enabled);
                this.searchInstLbl.setEnabled(enabled);
                this.searchInstText.setEnabled(enabled);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknonw tab: " + (Object)((Object)tab));
            }
        }
        boolean everythingDone = this.newPanel.isEnabled() && this.updatedPanel.isEnabled() && this.installedPanel.isEnabled();
        this.browseGemHome.setEnabled(everythingDone);
    }

    private synchronized void notifyLocalGemsUpdated() {
        assert (EventQueue.isDispatchThread());
        GemManager gemManager = this.getGemManager();
        assert (gemManager != null) : "gemManager must not be null";
        assert (!gemManager.needsLocalReload()) : "local gems are ready";
        LOGGER.finer("Updating local gems UI for: " + gemManager);
        this.hideLocalProgressBars();
        List<Gem> local = gemManager.getLocalGems();
        this.updateList(TabIndex.INSTALLED, local);
        this.refreshGemsToUpdate();
    }

    private synchronized void notifyRemoteGemsUpdated() {
        assert (EventQueue.isDispatchThread());
        GemManager gemManager = this.getGemManager();
        assert (gemManager != null) : "gemManager must not be null";
        assert (!gemManager.needsRemoteReload()) : "remote gems are ready";
        LOGGER.finer("Updating local gems UI for: " + gemManager);
        this.hideRemoteProgressBars();
        List<Gem> remoteGems = gemManager.getRemoteGems();
        this.updateList(TabIndex.NEW, remoteGems);
        this.refreshGemsToUpdate();
    }

    private void refreshGemsToUpdate() {
        assert (EventQueue.isDispatchThread());
        List<Gem> localGems = this.getGemManager().getLocalGems();
        if (localGems.isEmpty()) {
            return;
        }
        List<Gem> remoteGems = this.getGemManager().getRemoteGems();
        if (remoteGems.isEmpty()) {
            return;
        }
        HashMap<String, Gem> localsNameToGem = new HashMap<String, Gem>();
        for (Gem gem : localGems) {
            localsNameToGem.put(gem.getName(), gem);
        }
        Set localNames = localsNameToGem.keySet();
        ArrayList<Gem> gemsNeedingUpdated = new ArrayList<Gem>();
        for (Gem gem : remoteGems) {
            Gem localGem;
            String latestInstalled;
            String latestAvailable;
            if (!localNames.contains(gem.getName()) || Util.compareVersions(latestAvailable = gem.getLatestAvailable(), latestInstalled = (localGem = (Gem)localsNameToGem.get(gem.getName())).getLatestInstalled()) <= 0) continue;
            Gem update = new Gem(gem.getName(), localGem.getInstalledVersionsAsString(), latestAvailable);
            update.setDescription(localGem.getDescription());
            gemsNeedingUpdated.add(update);
        }
        this.updateList(TabIndex.UPDATED, gemsNeedingUpdated);
    }

    private void hideProgressBars() {
        this.hideLocalProgressBars();
        this.hideRemoteProgressBars();
    }

    private void hideRemoteProgressBars() {
        this.updatedProgress.setVisible(false);
        this.updatedProgressLabel.setVisible(false);
        this.newProgress.setVisible(false);
        this.newProgressLabel.setVisible(false);
    }

    private void hideLocalProgressBars() {
        this.installedProgress.setVisible(false);
        this.installedProgressLabel.setVisible(false);
    }

    private void updateList(TabIndex tab, List<Gem> gems) {
        JList list;
        assert (EventQueue.isDispatchThread());
        switch (tab) {
            case NEW: {
                list = this.newList;
                break;
            }
            case UPDATED: {
                list = this.updatedList;
                break;
            }
            case INSTALLED: {
                list = this.installedList;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknonw tab: " + (Object)((Object)tab));
            }
        }
        if (gems == null) {
            return;
        }
        GemListModel model = new GemListModel(gems, this.getFilter());
        list.clearSelection();
        list.setModel(model);
        list.invalidate();
        list.repaint();
        this.setTabTitle(tab, model);
        this.setEnabled(tab, true);
    }

    private void setTabTitle(TabIndex tab, GemListModel model) {
        int allSize = model.getAllSize();
        int nOfGems = model.getSize();
        String count = nOfGems < allSize ? nOfGems + "/" + allSize : Integer.toString(allSize);
        String tabTitle = tab.getTitle() + '(' + count + ')';
        this.gemsTab.setTitleAt(tab.getPosition(), tabTitle);
    }

    public boolean isModified() {
        return this.gemsModified;
    }

    private static void showProgressBar(JList list, JTextPane description, JProgressBar progress, JLabel progressLabel) {
        assert (EventQueue.isDispatchThread());
        if (list.getSelectedIndex() != -1) {
            GemPanel.updateGemDescription(description, null);
        }
        progress.setVisible(true);
        progressLabel.setVisible(true);
    }

    private void initComponents() {
        this.gemsTab = new JTabbedPane();
        this.updatedPanel = new JPanel();
        this.searchUpdatedText = new JTextField();
        this.searchUpdatedLbl = new JLabel();
        this.reloadUpdatedButton = new JButton();
        this.updatedSP = new JScrollPane();
        this.updatedList = new JList();
        this.updateButton = new JButton();
        this.updateAllButton = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.updatedDesc = new JTextPane();
        this.updatedProgress = new JProgressBar();
        this.updatedProgressLabel = new JLabel();
        this.installedPanel = new JPanel();
        this.searchInstText = new JTextField();
        this.searchInstLbl = new JLabel();
        this.reloadInstalledButton = new JButton();
        this.uninstallButton = new JButton();
        this.installedSP = new JScrollPane();
        this.installedList = new JList();
        this.jScrollPane5 = new JScrollPane();
        this.installedDesc = new JTextPane();
        this.installedProgress = new JProgressBar();
        this.installedProgressLabel = new JLabel();
        this.newPanel = new JPanel();
        this.searchNewText = new JTextField();
        this.searchNewLbl = new JLabel();
        this.reloadNewButton = new JButton();
        this.installButton = new JButton();
        this.newSP = new JScrollPane();
        this.newList = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.newDesc = new JTextPane();
        this.newProgress = new JProgressBar();
        this.newProgressLabel = new JLabel();
        this.installLocalButton = new JButton();
        this.settingsPanel = new JPanel();
        this.proxyButton = new JButton();
        this.allVersionsCheckbox = new JCheckBox();
        this.descriptionCheckbox = new JCheckBox();
        this.verboseCheckBox = new JCheckBox();
        this.rubyPlatformLabel = new JLabel();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.manageButton = new JButton();
        this.gemHome = new JLabel();
        this.gemHomeValue = new JTextField();
        this.browseGemHome = new JButton();
        this.oldRubyGemsText = new JLabel();
        FormListener formListener = new FormListener();
        this.searchUpdatedText.setColumns(14);
        this.searchUpdatedText.addActionListener(formListener);
        this.searchUpdatedLbl.setLabelFor(this.searchUpdatedText);
        Mnemonics.setLocalizedText((JLabel)this.searchUpdatedLbl, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchUpdatedLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadUpdatedButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadUpdatedButton.text"));
        this.reloadUpdatedButton.addActionListener(formListener);
        this.updatedSP.setViewportView(this.updatedList);
        this.updatedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedList.AccessibleContext.accessibleName"));
        this.updatedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.updateButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateButton.text"));
        this.updateButton.setEnabled(false);
        this.updateButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.updateAllButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateAllButton.text"));
        this.updateAllButton.addActionListener(formListener);
        this.updatedDesc.setEditable(false);
        this.jScrollPane6.setViewportView(this.updatedDesc);
        this.updatedDesc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedDesc.AccessibleContext.accessibleName"));
        this.updatedDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedDesc.AccessibleContext.accessibleDescription"));
        this.updatedProgress.setIndeterminate(true);
        Mnemonics.setLocalizedText((JLabel)this.updatedProgressLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedProgressLabel.text"));
        GroupLayout updatedPanelLayout = new GroupLayout((Container)this.updatedPanel);
        this.updatedPanel.setLayout((LayoutManager)updatedPanelLayout);
        updatedPanelLayout.setHorizontalGroup((GroupLayout.Group)updatedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)updatedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)updatedPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)updatedPanelLayout.createSequentialGroup().add((Component)this.reloadUpdatedButton).addPreferredGap(0, 442, Short.MAX_VALUE).add((Component)this.searchUpdatedLbl).addPreferredGap(0).add((Component)this.searchUpdatedText, -2, 156, -2)).add((GroupLayout.Group)updatedPanelLayout.createSequentialGroup().add((Component)this.updateButton).addPreferredGap(0).add((Component)this.updateAllButton).addPreferredGap(0, 366, Short.MAX_VALUE).add((Component)this.updatedProgressLabel).addPreferredGap(0).add((Component)this.updatedProgress, -2, -1, -2)).add(2, (GroupLayout.Group)updatedPanelLayout.createSequentialGroup().add((Component)this.updatedSP, -1, 489, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane6, -2, 283, -2))).addContainerGap()));
        updatedPanelLayout.setVerticalGroup((GroupLayout.Group)updatedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)updatedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)updatedPanelLayout.createParallelGroup(3).add((Component)this.searchUpdatedLbl).add((Component)this.searchUpdatedText, -2, -1, -2).add((Component)this.reloadUpdatedButton)).addPreferredGap(0).add((GroupLayout.Group)updatedPanelLayout.createParallelGroup(2).add((Component)this.jScrollPane6, -1, 262, Short.MAX_VALUE).add((Component)this.updatedSP, -1, 262, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)updatedPanelLayout.createParallelGroup(2).add((GroupLayout.Group)updatedPanelLayout.createParallelGroup(3).add((Component)this.updateButton).add((Component)this.updateAllButton)).add((Component)this.updatedProgress, -2, -1, -2).add((Component)this.updatedProgressLabel)).addContainerGap()));
        this.searchUpdatedText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchUpdatedText.AccessibleContext.accessibleDescription"));
        this.searchUpdatedLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchUpdatedLbl.AccessibleContext.accessibleDescription"));
        this.reloadUpdatedButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadReposButton.AccessibleContext.accessibleDescription"));
        this.updatedSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane3.AccessibleContext.accessibleDescription"));
        this.updateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateButton.AccessibleContext.accessibleDescription"));
        this.updateAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateAllButton.AccessibleContext.accessibleDescription"));
        this.jScrollPane6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane6.AccessibleContext.accessibleDescription"));
        this.updatedProgress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedProgress.AccessibleContext.accessibleDescription"));
        this.updatedProgressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedProgressLabel.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedPanel.TabConstraints.tabTitle"), this.updatedPanel);
        this.searchInstText.setColumns(14);
        this.searchInstText.addActionListener(formListener);
        this.searchInstLbl.setLabelFor(this.searchInstText);
        Mnemonics.setLocalizedText((JLabel)this.searchInstLbl, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchInstLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadInstalledButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadInstalledButton.text"));
        this.reloadInstalledButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.uninstallButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.uninstallButton.text"));
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.addActionListener(formListener);
        this.installedSP.setViewportView(this.installedList);
        this.installedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedList.AccessibleContext.accessibleName"));
        this.installedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedList.AccessibleContext.accessibleDescription"));
        this.installedDesc.setEditable(false);
        this.jScrollPane5.setViewportView(this.installedDesc);
        this.installedDesc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedDesc.AccessibleContext.accessibleName"));
        this.installedDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedDesc.AccessibleContext.accessibleDescription"));
        this.installedProgress.setIndeterminate(true);
        Mnemonics.setLocalizedText((JLabel)this.installedProgressLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedProgressLabel.text"));
        GroupLayout installedPanelLayout = new GroupLayout((Container)this.installedPanel);
        this.installedPanel.setLayout((LayoutManager)installedPanelLayout);
        installedPanelLayout.setHorizontalGroup((GroupLayout.Group)installedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)installedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)installedPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)installedPanelLayout.createSequentialGroup().add((Component)this.reloadInstalledButton).addPreferredGap(0, 442, Short.MAX_VALUE).add((Component)this.searchInstLbl).addPreferredGap(0).add((Component)this.searchInstText, -2, 156, -2)).add((GroupLayout.Group)installedPanelLayout.createSequentialGroup().add((Component)this.uninstallButton).addPreferredGap(0, 468, Short.MAX_VALUE).add((Component)this.installedProgressLabel).addPreferredGap(0).add((Component)this.installedProgress, -2, -1, -2)).add(2, (GroupLayout.Group)installedPanelLayout.createSequentialGroup().add((Component)this.installedSP, -1, 489, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane5, -2, 283, -2))).addContainerGap()));
        installedPanelLayout.setVerticalGroup((GroupLayout.Group)installedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)installedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)installedPanelLayout.createParallelGroup(3).add((Component)this.searchInstLbl).add((Component)this.reloadInstalledButton).add((Component)this.searchInstText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)installedPanelLayout.createParallelGroup(2).add((Component)this.installedSP, -1, 262, Short.MAX_VALUE).add((Component)this.jScrollPane5, -1, 262, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)installedPanelLayout.createParallelGroup(2).add((Component)this.uninstallButton).add((Component)this.installedProgress, -2, -1, -2).add((Component)this.installedProgressLabel)).addContainerGap()));
        this.searchInstText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.instSearchText.AccessibleContext.accessibleDescription"));
        this.searchInstLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.instSearchLbl.AccessibleContext.accessibleDescription"));
        this.reloadInstalledButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadInstalledButton.AccessibleContext.accessibleDescription"));
        this.uninstallButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.uninstallButton.AccessibleContext.accessibleDescription"));
        this.installedSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane1.AccessibleContext.accessibleDescription"));
        this.jScrollPane5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane5.AccessibleContext.accessibleDescription"));
        this.installedProgress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedProgress.AccessibleContext.accessibleDescription"));
        this.installedProgressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedProgressLabel.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedPanel.TabConstraints.tabTitle"), this.installedPanel);
        this.searchNewText.setColumns(14);
        this.searchNewText.addActionListener(formListener);
        this.searchNewLbl.setLabelFor(this.searchNewText);
        Mnemonics.setLocalizedText((JLabel)this.searchNewLbl, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchNewLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadNewButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadNewButton.text"));
        this.reloadNewButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installButton.text"));
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(formListener);
        this.newSP.setViewportView(this.newList);
        this.newList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newList.AccessibleContext.accessibleName"));
        this.newList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newList.AccessibleContext.accessibleDescription"));
        this.newDesc.setEditable(false);
        this.jScrollPane4.setViewportView(this.newDesc);
        this.newDesc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newDesc.AccessibleContext.accessibleName"));
        this.newDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newDesc.AccessibleContext.accessibleDescription"));
        this.newProgress.setIndeterminate(true);
        Mnemonics.setLocalizedText((JLabel)this.newProgressLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newProgressLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.installLocalButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installLocalButton.text"));
        this.installLocalButton.addActionListener(formListener);
        GroupLayout newPanelLayout = new GroupLayout((Container)this.newPanel);
        this.newPanel.setLayout((LayoutManager)newPanelLayout);
        newPanelLayout.setHorizontalGroup((GroupLayout.Group)newPanelLayout.createParallelGroup(1).add((GroupLayout.Group)newPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)newPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)newPanelLayout.createSequentialGroup().add((Component)this.reloadNewButton).addPreferredGap(0, 442, Short.MAX_VALUE).add((Component)this.searchNewLbl).addPreferredGap(0).add((Component)this.searchNewText, -2, 156, -2)).add((GroupLayout.Group)newPanelLayout.createSequentialGroup().add((Component)this.installButton).addPreferredGap(0).add((Component)this.installLocalButton).addPreferredGap(0, 347, Short.MAX_VALUE).add((Component)this.newProgressLabel).addPreferredGap(0).add((Component)this.newProgress, -2, -1, -2)).add(2, (GroupLayout.Group)newPanelLayout.createSequentialGroup().add((Component)this.newSP, -1, 489, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane4, -2, 283, -2))).addContainerGap()));
        newPanelLayout.setVerticalGroup((GroupLayout.Group)newPanelLayout.createParallelGroup(1).add((GroupLayout.Group)newPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)newPanelLayout.createParallelGroup(3).add((Component)this.searchNewLbl).add((Component)this.reloadNewButton).add((Component)this.searchNewText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)newPanelLayout.createParallelGroup(1).add((Component)this.newSP, -1, 262, Short.MAX_VALUE).add((Component)this.jScrollPane4, -1, 262, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)newPanelLayout.createParallelGroup(2).add((GroupLayout.Group)newPanelLayout.createParallelGroup(3).add((Component)this.installButton).add((Component)this.installLocalButton)).add((Component)this.newProgress, -2, -1, -2).add((Component)this.newProgressLabel)).addContainerGap()));
        this.searchNewText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchNewText.AccessibleContext.accessibleDescription"));
        this.searchNewLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchNewLbl.AccessibleContext.accessibleDescription"));
        this.reloadNewButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadNewButton.AccessibleContext.accessibleDescription"));
        this.installButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installButton.AccessibleContext.accessibleDescription"));
        this.newSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane2.AccessibleContext.accessibleDescription"));
        this.jScrollPane4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane4.AccessibleContext.accessibleDescription"));
        this.newProgress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newProgress.AccessibleContext.accessibleDescription"));
        this.newProgressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newProgressLabel.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newPanel.TabConstraints.tabTitle"), this.newPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.proxyButton.text"));
        this.proxyButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.allVersionsCheckbox, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.allVersionsCheckbox.text"));
        this.allVersionsCheckbox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.descriptionCheckbox, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.descriptionCheckbox.text"));
        this.descriptionCheckbox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.verboseCheckBox, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.verboseCheckBox.text"));
        this.verboseCheckBox.addItemListener(formListener);
        GroupLayout settingsPanelLayout = new GroupLayout((Container)this.settingsPanel);
        this.settingsPanel.setLayout((LayoutManager)settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup((GroupLayout.Group)settingsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)settingsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)settingsPanelLayout.createParallelGroup(1).add((Component)this.verboseCheckBox).add((Component)this.descriptionCheckbox).add((Component)this.proxyButton).add((Component)this.allVersionsCheckbox)).addContainerGap(458, Short.MAX_VALUE)));
        settingsPanelLayout.setVerticalGroup((GroupLayout.Group)settingsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)settingsPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.proxyButton).add(18, 18, 18).add((Component)this.allVersionsCheckbox).addPreferredGap(1).add((Component)this.descriptionCheckbox).addPreferredGap(1).add((Component)this.verboseCheckBox).addContainerGap(216, Short.MAX_VALUE)));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.proxyButton.AccessibleContext.accessibleDescription"));
        this.allVersionsCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.allVersionsCheckbox.AccessibleContext.accessibleDescription"));
        this.descriptionCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.descriptionCheckbox.AccessibleContext.accessibleDescription"));
        this.verboseCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.verboseCheckBox.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.settingsPanel.TabConstraints.tabTitle"), this.settingsPanel);
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.rubyPlatformLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.manageButton.text"));
        this.manageButton.addActionListener(formListener);
        this.gemHome.setLabelFor(this.gemHomeValue);
        Mnemonics.setLocalizedText((JLabel)this.gemHome, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemHome.text"));
        this.gemHomeValue.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseGemHome, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.browseGemHome.text"));
        this.browseGemHome.addActionListener(formListener);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.gemsTab, -1, 819, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.gemHome, -1, -1, Short.MAX_VALUE).add((Component)this.rubyPlatformLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.gemHomeValue, -1, 591, Short.MAX_VALUE).add(2, (Component)this.platforms, 0, 591, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.manageButton).add(2, (Component)this.browseGemHome, -2, 80, -2))).add(1, (Component)this.oldRubyGemsText, -1, 819, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.browseGemHome, this.manageButton}, 1);
        layout.linkSize(new Component[]{this.gemHome, this.rubyPlatformLabel}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rubyPlatformLabel).add((Component)this.manageButton).add((Component)this.platforms, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.gemHome).add((Component)this.browseGemHome).add((Component)this.gemHomeValue, -2, -1, -2)).addPreferredGap(1).add((Component)this.gemsTab, -1, 375, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.oldRubyGemsText).addContainerGap()));
        this.gemsTab.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemsTab.AccessibleContext.accessibleName"));
        this.gemsTab.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemsTab.AccessibleContext.accessibleDescription"));
        this.platforms.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.platforms.AccessibleContext.accessibleName"));
        this.platforms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.platforms.AccessibleContext.accessibleDescription"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.manageButton.AccessibleContext.accessibleDescription"));
        this.gemHomeValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemHomeValue.AccessibleContext.accessibleName"));
        this.gemHomeValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemHomeValue.AccessibleContext.accessibleDescription"));
        this.browseGemHome.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.browseGemHome.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.AccessibleContext.accessibleDescription"));
    }

    private void reloadNewButtonActionPerformed(ActionEvent evt) {
        this.getGemManager().resetRemote();
        this.refreshRemoteGems();
    }

    private void proxyButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void applyFilter() {
        assert (EventQueue.isDispatchThread());
        this.removeFilterDocumentListeners();
        this.applyFilter(TabIndex.NEW, this.searchNewText, this.newList, this.newDesc, this.installButton);
        this.applyFilter(TabIndex.UPDATED, this.searchUpdatedText, this.updatedList, this.updatedDesc, this.updateButton);
        this.applyFilter(TabIndex.INSTALLED, this.searchInstText, this.installedList, this.installedDesc, this.uninstallButton);
        this.addFilterDocumentListeners();
    }

    private void applyFilter(TabIndex tab, JTextField searchField, JList list, JTextPane desc, JButton button) {
        int pos = searchField.getCaretPosition();
        String _filter = this.getFilter();
        searchField.setText(_filter);
        searchField.setCaretPosition(pos > _filter.length() ? _filter.length() : pos);
        GemListModel gemModel = (GemListModel)list.getModel();
        gemModel.applyFilter(this.getFilter());
        this.setTabTitle(tab, gemModel);
        if (list.getSelectedValue() == null) {
            list.setSelectedIndex(0);
        }
        GemPanel.updateGemDescription(list, desc, button);
    }

    private void reloadUpdatedButtonActionPerformed(ActionEvent evt) {
        this.getGemManager().reset();
        this.refreshAllGems();
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        Gem gem;
        assert (EventQueue.isDispatchThread());
        int[] indices = this.newList.getSelectedIndices();
        ArrayList<Gem> gems = new ArrayList<Gem>();
        for (int index : indices) {
            Object o = this.newList.getModel().getElementAt(index);
            if (!(o instanceof Gem)) continue;
            gem = (Gem)o;
            gems.add(gem);
        }
        if (!gems.isEmpty()) {
            for (Gem chosen : gems) {
                InstallationSettingsPanel panel = new InstallationSettingsPanel(chosen);
                panel.getAccessibleContext().setAccessibleDescription(GemPanel.getMessage("InstallationSettingsPanel.AccessibleContext.accessibleDescription", new Object[0]));
                DialogDescriptor dd = new DialogDescriptor((Object)panel, GemPanel.getMessage("ChooseGemSettings", new Object[0]));
                dd.setOptionType(2);
                dd.setModal(true);
                dd.setHelpCtx(new HelpCtx(GemPanel.class));
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (!result.equals(NotifyDescriptor.OK_OPTION)) continue;
                gem = new Gem(panel.getGemName(), null, null);
                GemListRefresher completionTask = new GemListRefresher();
                this.getGemManager().install(new Gem[]{gem}, this, false, false, panel.getVersion(), panel.getIncludeDepencies(), true, completionTask);
            }
        }
    }

    private void updateAllButtonActionPerformed(ActionEvent evt) {
        GemListRefresher completionTask = new GemListRefresher();
        this.getGemManager().update(null, this, false, false, false, true, completionTask);
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        int[] indices = this.updatedList.getSelectedIndices();
        ArrayList<Gem> gems = new ArrayList<Gem>();
        if (indices != null) {
            for (int index : indices) {
                assert (index >= 0);
                Object o = this.updatedList.getModel().getElementAt(index);
                if (!(o instanceof Gem)) continue;
                Gem gem = (Gem)o;
                gems.add(gem);
            }
        }
        if (!gems.isEmpty()) {
            GemListRefresher completionTask = new GemListRefresher();
            this.getGemManager().update(gems.toArray(new Gem[gems.size()]), this, false, false, false, true, completionTask);
        }
    }

    private void uninstallButtonActionPerformed(ActionEvent evt) {
        Object gem;
        assert (EventQueue.isDispatchThread());
        int[] indices = this.installedList.getSelectedIndices();
        ArrayList<Gem> gems = new ArrayList<Gem>();
        if (indices != null) {
            for (int index : indices) {
                assert (index >= 0);
                Object o = this.installedList.getModel().getElementAt(index);
                if (!(o instanceof Gem)) continue;
                gem = (Gem)o;
                gems.add((Gem)gem);
            }
        }
        if (!gems.isEmpty()) {
            for (Gem chosen : gems) {
                UninstallationSettingsPanel panel = new UninstallationSettingsPanel(chosen);
                panel.getAccessibleContext().setAccessibleDescription(GemPanel.getMessage("InstallationSettingsPanel.AccessibleContext.accessibleDescription", new Object[0]));
                DialogDescriptor dd = new DialogDescriptor((Object)panel, GemPanel.getMessage("GemUninstallationSettings", new Object[0]));
                dd.setOptionType(2);
                dd.setModal(true);
                dd.setHelpCtx(new HelpCtx(GemPanel.class));
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (!result.equals(NotifyDescriptor.OK_OPTION)) continue;
                gem = new GemInstallInfo(panel.getGemName(), panel.getVersion(), panel.getIgnoreDepencies());
                GemListRefresher completionTask = new GemListRefresher();
                this.getGemManager().uninstall(Collections.singletonList(gem), this, true, completionTask);
            }
        }
    }

    private void reloadInstalledButtonActionPerformed(ActionEvent evt) {
        this.getGemManager().resetLocal();
        this.refreshLocalGems();
    }

    private void manageButtonActionPerformed(ActionEvent evt) {
        RubyPlatformCustomizer.manage(this.platforms, false);
    }

    private void browseGemHomeActionPerformed(ActionEvent evt) {
        boolean changed = GemPanel.chooseAndSetGemHome(this, this.getSelectedPlatform());
        if (changed) {
            this.platformChanged();
        }
    }

    private void installLocalButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(RubyPreferences.getPreferences().get(LAST_GEM_DIRECTORY, ""));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && f.getName().toLowerCase(Locale.US).endsWith(".gem");
            }

            @Override
            public String getDescription() {
                return GemPanel.getMessage("GemPanel.rubygems.files.filter", new Object[0]);
            }
        });
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            File gem = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            RubyPreferences.getPreferences().put(LAST_GEM_DIRECTORY, gem.getParentFile().getAbsolutePath());
            GemListRefresher completionTask = new GemListRefresher();
            this.getGemManager().installLocal(gem, this, false, false, true, completionTask);
        }
    }

    private void allVersionsCheckboxActionPerformed(ActionEvent evt) {
        RubyPreferences.setFetchAllVersions(this.allVersionsCheckbox.isSelected());
    }

    private void descriptionCheckboxActionPerformed(ActionEvent evt) {
        RubyPreferences.setFetchGemDescriptions(this.descriptionCheckbox.isSelected());
    }

    private void searchUpdatedTextActionPerformed(ActionEvent evt) {
    }

    private void searchInstTextActionPerformed(ActionEvent evt) {
    }

    private void searchNewTextActionPerformed(ActionEvent evt) {
    }

    private void verboseCheckBoxItemStateChanged(ItemEvent evt) {
        RubyPreferences.setGemVerboseOutput(this.verboseCheckBox.isSelected());
    }

    public static File chooseGemRepository(Component parent) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int ret = chooser.showOpenDialog(parent);
        if (ret == 0) {
            File gemHomeF = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            if (GemManager.isValidGemHome(gemHomeF)) {
                return gemHomeF;
            }
            if (!gemHomeF.exists() || gemHomeF.isDirectory() && gemHomeF.list().length == 0) {
                if (Util.confirmLocalized(GemPanel.class, "GemPanel.empty.create.gemrepo", gemHomeF.getAbsolutePath())) {
                    try {
                        GemManager.initializeRepository(gemHomeF);
                        return gemHomeF;
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.SEVERE, ioe.getLocalizedMessage(), ioe);
                    }
                }
            } else {
                Util.notifyLocalized(GemPanel.class, "GemPanel.invalid.gemHome", gemHomeF.getAbsolutePath());
            }
        }
        return null;
    }

    public static boolean chooseAndSetGemHome(Component parent, RubyPlatform platform) {
        if (platform == null) {
            return false;
        }
        assert (platform.hasRubyGemsInstalled()) : "has RubyGems installed";
        File gemHomeF = GemPanel.chooseGemRepository(parent);
        if (gemHomeF != null) {
            platform.setGemHome(gemHomeF);
            return true;
        }
        return false;
    }

    private void showGemErrors(List<String> errors) {
        assert (EventQueue.isDispatchThread());
        this.getGemManager().reset();
        StringBuilder sb = new StringBuilder();
        for (String error : errors) {
            sb.append(error).append('\n');
        }
        Util.notifyLocalized(GemPanel.class, "GemPanel.GemsFetchingFailed", 0, new Object[]{sb.toString()});
    }

    private void refreshAllGems() {
        assert (EventQueue.isDispatchThread());
        this.refreshLocalGems();
        this.refreshRemoteGems();
    }

    private void refreshLocalGems() {
        assert (EventQueue.isDispatchThread());
        this.setEnabledLocalsGUI(false);
        GemPanel.showProgressBar(this.installedList, this.installedDesc, this.installedProgress, this.installedProgressLabel);
        this.installedList.setModel(this.emptyGemListModel);
        this.gemsTab.setTitleAt(TabIndex.INSTALLED.getPosition(), TabIndex.INSTALLED.getTitle() + "(-)");
        final GemManager gemManager = this.getGemManager();
        Runnable updateTask = new Runnable(){

            @Override
            public void run() {
                LOGGER.finer("Update of local gems for " + gemManager + " scheduled");
                assert (!EventQueue.isDispatchThread());
                final List<String> errors = gemManager.reloadLocalIfNeeded();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean platformHasChanged;
                        LOGGER.finer("Update of local gems for " + gemManager + " finished");
                        if (GemPanel.this.closed) {
                            return;
                        }
                        boolean bl = platformHasChanged = !gemManager.equals(GemPanel.this.getGemManager());
                        if (!errors.isEmpty()) {
                            GemPanel.this.showGemErrors(errors);
                            if (!platformHasChanged) {
                                GemPanel.this.hideLocalProgressBars();
                                GemPanel.this.enableLocalReloadGUI();
                            }
                            return;
                        }
                        if (!platformHasChanged) {
                            GemPanel.this.notifyLocalGemsUpdated();
                        } else {
                            LOGGER.finer("Gem Manager has changed from " + gemManager + " to " + GemPanel.this.getGemManager() + ". Ignoring local gems update.");
                        }
                    }
                });
            }
        };
        LOGGER.finer("Submitting refreshing of gems for: " + gemManager);
        this.updateTasksQueue.post(updateTask);
    }

    private void refreshRemoteGems() {
        assert (EventQueue.isDispatchThread());
        this.setEnabledRemoteGUI(false);
        GemPanel.showProgressBar(this.newList, this.newDesc, this.newProgress, this.newProgressLabel);
        GemPanel.showProgressBar(this.updatedList, this.updatedDesc, this.updatedProgress, this.updatedProgressLabel);
        this.newList.setModel(this.emptyGemListModel);
        this.updatedList.setModel(this.emptyGemListModel);
        this.gemsTab.setTitleAt(TabIndex.NEW.getPosition(), TabIndex.NEW.getTitle() + "(-)");
        this.gemsTab.setTitleAt(TabIndex.UPDATED.getPosition(), TabIndex.UPDATED.getTitle() + "(-)");
        final GemManager gemManager = this.getGemManager();
        Runnable updateTask = new Runnable(){

            @Override
            public void run() {
                LOGGER.finer("Update of remote gems for " + gemManager + " scheduled");
                assert (!EventQueue.isDispatchThread());
                final List<String> errors = gemManager.reloadRemoteIfNeeded();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean platformHasChanged;
                        LOGGER.finer("Update of remote gems for " + gemManager + " finished");
                        if (GemPanel.this.closed) {
                            return;
                        }
                        boolean bl = platformHasChanged = !gemManager.equals(GemPanel.this.getGemManager());
                        if (!errors.isEmpty()) {
                            GemPanel.this.showGemErrors(errors);
                            if (!platformHasChanged) {
                                GemPanel.this.hideRemoteProgressBars();
                                GemPanel.this.enableRemoteReloadGUI();
                            }
                            return;
                        }
                        if (!platformHasChanged) {
                            GemPanel.this.notifyRemoteGemsUpdated();
                        } else {
                            LOGGER.finer("Gem Manager has changed from " + gemManager + " to " + GemPanel.this.getGemManager() + ". Ignoring remote gems update.");
                        }
                    }
                });
            }
        };
        LOGGER.finer("Submitting refreshing of gems for: " + gemManager);
        this.updateTasksQueue.post(updateTask);
    }

    private RubyPlatform getSelectedPlatform() {
        if (!EventQueue.isDispatchThread()) {
            Exceptions.printStackTrace((Throwable)((Object)new AssertionError((Object)"getSelectedPlatform() must be called from EDT")));
        }
        return PlatformComponentFactory.getPlatform(this.platforms);
    }

    private GemManager getGemManager() {
        RubyPlatform platform;
        if (!EventQueue.isDispatchThread()) {
            Exceptions.printStackTrace((Throwable)((Object)new AssertionError((Object)"getGemManager() must be called from EDT")));
        }
        return (platform = this.getSelectedPlatform()) == null ? null : platform.getGemManager();
    }

    private static String getMessage(String key, Object ... params) {
        return NbBundle.getMessage(GemPanel.class, (String)key, (Object[])params);
    }

    private final class FilterFieldListener
    implements DocumentListener {
        private FilterFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String filter = e.getDocument().getText(0, doc.getLength());
                GemPanel.this.setFilter(filter);
                GemPanel.this.filterTask.schedule(350);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class GemListRefresher
    implements Runnable {
        private GemListRefresher() {
        }

        @Override
        public void run() {
            GemPanel.this.gemsModified = true;
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
            } else {
                GemPanel.this.refreshAllGems();
            }
        }
    }

    private static class MyListSelectionListener
    implements ListSelectionListener {
        private final JButton button;
        private final JTextPane pane;
        private final JList list;

        private MyListSelectionListener(JList list, JTextPane pane, JButton button) {
            this.list = list;
            this.pane = pane;
            this.button = button;
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            if (ev.getValueIsAdjusting()) {
                return;
            }
            GemPanel.updateGemDescription(this.list, this.pane, this.button);
        }
    }

    private class FormListener
    implements ActionListener,
    ItemListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == GemPanel.this.searchUpdatedText) {
                GemPanel.this.searchUpdatedTextActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.reloadUpdatedButton) {
                GemPanel.this.reloadUpdatedButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.updateButton) {
                GemPanel.this.updateButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.updateAllButton) {
                GemPanel.this.updateAllButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.searchInstText) {
                GemPanel.this.searchInstTextActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.reloadInstalledButton) {
                GemPanel.this.reloadInstalledButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.uninstallButton) {
                GemPanel.this.uninstallButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.searchNewText) {
                GemPanel.this.searchNewTextActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.reloadNewButton) {
                GemPanel.this.reloadNewButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.installButton) {
                GemPanel.this.installButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.installLocalButton) {
                GemPanel.this.installLocalButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.proxyButton) {
                GemPanel.this.proxyButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.allVersionsCheckbox) {
                GemPanel.this.allVersionsCheckboxActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.descriptionCheckbox) {
                GemPanel.this.descriptionCheckboxActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.manageButton) {
                GemPanel.this.manageButtonActionPerformed(evt);
            } else if (evt.getSource() == GemPanel.this.browseGemHome) {
                GemPanel.this.browseGemHomeActionPerformed(evt);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == GemPanel.this.verboseCheckBox) {
                GemPanel.this.verboseCheckBoxItemStateChanged(evt);
            }
        }
    }

    static enum TabIndex {
        UPDATED(0, "GemPanel.updatedPanel.TabConstraints.tabTitle"),
        INSTALLED(1, "GemPanel.installedPanel.TabConstraints.tabTitle"),
        NEW(2, "GemPanel.newPanel.TabConstraints.tabTitle");

        private final int position;
        private final String title;

        private TabIndex(int position, String titleKey) {
            this.position = position;
            this.title = GemPanel.getMessage(titleKey, new Object[0]);
        }

        private int getPosition() {
            return this.position;
        }

        private String getTitle() {
            return this.title;
        }
    }
}

