/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.spi.WebServiceDataProvider;
import org.netbeans.modules.websvc.project.spi.WebServiceFactory;
import org.netbeans.modules.websvc.project.spi.WebServiceImplementation;

public class MavenJaxWsServicesProvider
implements WebServiceDataProvider,
PropertyChangeListener {
    private JAXWSLightSupport jaxWsSupport;
    private Project prj;
    private List<WebService> providers = new LinkedList<WebService>();
    private List<WebService> consumers = new LinkedList<WebService>();

    public MavenJaxWsServicesProvider(Project prj, JAXWSLightSupport jaxWsSupport) {
        this.jaxWsSupport = jaxWsSupport;
        this.prj = prj;
        jaxWsSupport.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public List<WebService> getServiceProviders() {
        return this.providers;
    }

    public List<WebService> getServiceConsumers() {
        return this.consumers;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.jaxWsSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.jaxWsSupport.removePropertyChangeListener(pcl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block6: {
            block7: {
                if (!"service-added".equals(evt.getPropertyName())) break block7;
                MavenWebService mavenService = new MavenWebService((JaxWsService)evt.getNewValue(), this.prj);
                WebService webService = WebServiceFactory.createWebService((WebServiceImplementation)mavenService);
                if (webService.isServiceProvider()) {
                    this.providers.add(webService);
                } else {
                    this.consumers.add(webService);
                }
                break block6;
            }
            if (!"service-removed".equals(evt.getPropertyName())) break block6;
            JaxWsService jaxWsService = (JaxWsService)evt.getOldValue();
            if (jaxWsService.isServiceProvider()) {
                String implClass = jaxWsService.getImplementationClass();
                for (WebService service : this.providers) {
                    if (!implClass.equals(service.getIdentifier())) continue;
                    this.providers.remove(service);
                    break;
                }
            } else {
                String clientId = jaxWsService.getId();
                for (WebService client : this.consumers) {
                    if (clientId == null || !clientId.equals(client.getIdentifier())) continue;
                    this.consumers.remove(client);
                    break;
                }
            }
        }
    }
}

